<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/init.jsp" %>

<%
CommerceShipmentDisplayContext commerceShipmentDisplayContext = (CommerceShipmentDisplayContext)request.getAttribute(WebKeys.PORTLET_DISPLAY_CONTEXT);

CommerceShipment commerceShipment = commerceShipmentDisplayContext.getCommerceShipment();

Date shippingDate = commerceShipment.getShippingDate();

int shippingDay = 0;
int shippingMonth = -1;
int shippingYear = 0;

if (shippingDate != null) {
	Calendar calendar = CalendarFactoryUtil.getCalendar(shippingDate.getTime());

	shippingDay = calendar.get(Calendar.DAY_OF_MONTH);
	shippingMonth = calendar.get(Calendar.MONTH);
	shippingYear = calendar.get(Calendar.YEAR);
}
%>

<portlet:actionURL name="/commerce_shipment/edit_commerce_shipment" var="editCommerceShipmentURL" />

<commerce-ui:modal-content
	title='<%= LanguageUtil.format(request, "edit-x", "estimated-shipping-date") %>'
>
	<liferay-ui:error exception="<%= CommerceShipmentShippingDateException.class %>" />

	<aui:form action="<%= editCommerceShipmentURL %>" cssClass="container-fluid-1280 p-0" method="post" name="fm">
		<aui:input name="<%= Constants.CMD %>" type="hidden" value="shippingDate" />
		<aui:input name="redirect" type="hidden" value="<%= currentURL %>" />
		<aui:input name="commerceShipmentId" type="hidden" value="<%= commerceShipment.getCommerceShipmentId() %>" />

		<liferay-ui:input-date
			dayParam="shippingDateDay"
			dayValue="<%= shippingDay %>"
			disabled="<%= false %>"
			monthParam="shippingDateMonth"
			monthValue="<%= shippingMonth %>"
			name="shippingDate"
			nullable="<%= true %>"
			showDisableCheckbox="<%= false %>"
			yearParam="shippingDateYear"
			yearValue="<%= shippingYear %>"
		/>
	</aui:form>
</commerce-ui:modal-content>