<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/init.jsp" %>

<%
long commerceShipmentId = ParamUtil.getLong(request, "commerceShipmentId");
long commerceShipmentItemId = ParamUtil.getLong(request, "commerceShipmentItemId");

String title = "shipment";
%>

<portlet:actionURL name="editCommerceShipment" var="editCommerceShipmentURL" />

<c:if test="<%= commerceShipmentItemId > 0 %>">
	<portlet:actionURL name="editCommerceShipmentItem" var="editCommerceShipmentURL" />

	<%
	title = "shipment-item";
	%>

</c:if>

<commerce-ui:modal-content
	title='<%= LanguageUtil.format(request, "delete-x", title) %>'
>
	<liferay-ui:error exception="<%= CommerceShipmentShippingDateException.class %>" />

	<aui:form action="<%= editCommerceShipmentURL %>" cssClass="container-fluid-1280 p-0" method="post" name="fm">
		<aui:input name="<%= Constants.CMD %>" type="hidden" value="<%= Constants.DELETE %>" />
		<aui:input name="redirect" type="hidden" value="<%= currentURL %>" />

		<c:choose>
			<c:when test="<%= commerceShipmentId > 0 %>">
				<aui:input name="commerceShipmentId" type="hidden" value="<%= commerceShipmentId %>" />
			</c:when>
			<c:when test="<%= commerceShipmentItemId > 0 %>">
				<aui:input name="commerceShipmentItemId" type="hidden" value="<%= commerceShipmentItemId %>" />
			</c:when>
		</c:choose>

		<h2><liferay-ui:message key="restock-the-items-that-are-being-deleted" /></h2>

		<aui:input label="yes-restock-the-items" name="restoreStockQuantity" type="checkbox" value="true" />
	</aui:form>
</commerce-ui:modal-content>