<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/init.jsp" %>

<%
CommerceShipmentDisplayContext commerceShipmentDisplayContext = (CommerceShipmentDisplayContext)request.getAttribute(WebKeys.PORTLET_DISPLAY_CONTEXT);

CommerceShipment commerceShipment = commerceShipmentDisplayContext.getCommerceShipment();

Date expectedDate = commerceShipment.getExpectedDate();

int expectedDay = 0;
int expectedMonth = -1;
int expectedYear = 0;

if (expectedDate != null) {
	Calendar calendar = CalendarFactoryUtil.getCalendar(expectedDate.getTime());

	expectedDay = calendar.get(Calendar.DAY_OF_MONTH);
	expectedMonth = calendar.get(Calendar.MONTH);
	expectedYear = calendar.get(Calendar.YEAR);
}
%>

<portlet:actionURL name="editCommerceShipment" var="editCommerceShipmentURL" />

<commerce-ui:modal-content
	title='<%= LanguageUtil.format(request, "edit-x", "estimated-delivery-date") %>'
>
	<liferay-ui:error exception="<%= CommerceShipmentExpectedDateException.class %>" />

	<aui:form action="<%= editCommerceShipmentURL %>" cssClass="container-fluid-1280 p-0" method="post" name="fm">
		<aui:input name="<%= Constants.CMD %>" type="hidden" value="expectedDate" />
		<aui:input name="redirect" type="hidden" value="<%= currentURL %>" />
		<aui:input name="commerceShipmentId" type="hidden" value="<%= commerceShipment.getCommerceShipmentId() %>" />

		<liferay-ui:input-date
			dayParam="expectedDateDay"
			dayValue="<%= expectedDay %>"
			disabled="<%= false %>"
			monthParam="expectedDateMonth"
			monthValue="<%= expectedMonth %>"
			name="expectedDeliveryDate"
			nullable="<%= true %>"
			showDisableCheckbox="<%= false %>"
			yearParam="expectedDateYear"
			yearValue="<%= expectedYear %>"
		/>
	</aui:form>
</commerce-ui:modal-content>