/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipment.web.internal.portlet.action;

import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.exception.NoSuchShipmentException;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_commerce_shipment_web_internal_portlet_CommerceShipmentPortlet", "mvc.command.name=editCommerceShipment"}, service={MVCActionCommand.class})
public class EditCommerceShipmentMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;
    @Reference
    private CommerceShipmentService _commerceShipmentService;

    protected void addCommerceShipmentItems(ActionRequest actionRequest, long commerceShipmentId) throws PortalException {
        long[] commerceOrderItemIds;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommerceShipmentItem.class.getName(), (PortletRequest)actionRequest);
        for (long commerceOrderItemId : commerceOrderItemIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"commerceOrderItemId")) {
            long[] commerceInventoryWarehouseIds;
            for (long commerceInventoryWarehouseId : commerceInventoryWarehouseIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)(commerceOrderItemId + "_warehouse"))) {
                int quantity = ParamUtil.getInteger((PortletRequest)actionRequest, (String)StringBundler.concat((Object[])new Object[]{commerceOrderItemId, "_", commerceInventoryWarehouseId, "_quantity"}));
                if (quantity <= 0) continue;
                this._commerceShipmentItemService.addCommerceShipmentItem(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId, quantity, serviceContext);
            }
        }
    }

    protected void deleteCommerceShipments(ActionRequest actionRequest) throws PortalException {
        long[] deleteCommerceShipmentIds = null;
        long commerceShipmentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentId");
        deleteCommerceShipmentIds = commerceShipmentId > 0L ? new long[]{commerceShipmentId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCommerceShipmentIds"), (long)0L);
        for (long deleteCommerceShipmentId : deleteCommerceShipmentIds) {
            this._commerceShipmentService.deleteCommerceShipment(deleteCommerceShipmentId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                String redirect = this.getSaveAndRedirectRedirect(actionRequest);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else if (cmd.equals("delete")) {
                this.deleteCommerceShipments(actionRequest);
            } else if (cmd.equals("update")) {
                this.updateCommerceShipment(actionRequest);
            } else if (cmd.equals("selectCommerceShipmentItems")) {
                this.selectCommerceShipmentItems(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof CommerceShipmentItemQuantityException) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcRenderCommandName", "selectCommerceShipmentItems");
            }
            if (e instanceof CommerceShipmentStatusException) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcRenderCommandName", "viewCommerceShipmentDetail");
            }
            if (e instanceof NoSuchShipmentException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    protected String getSaveAndRedirectRedirect(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletProviderUtil.getPortletURL((PortletRequest)actionRequest, (Group)themeDisplay.getScopeGroup(), (String)CommerceShipment.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        portletURL.setParameter("mvcRenderCommandName", "selectCommerceShipmentItems");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            portletURL.setParameter("redirect", redirect);
        }
        long commerceOrderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceOrderId");
        portletURL.setParameter("commerceOrderId", String.valueOf(commerceOrderId));
        long commerceShipmentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentId");
        portletURL.setParameter("commerceShipmentId", String.valueOf(commerceShipmentId));
        return portletURL.toString();
    }

    protected void selectCommerceShipmentItems(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        CommerceShipment commerceShipment = null;
        long commerceShipmentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentId");
        commerceShipment = commerceShipmentId > 0L ? this._commerceShipmentService.getCommerceShipment(commerceShipmentId) : this.updateCommerceShipment(actionRequest);
        if (commerceShipment != null) {
            this.addCommerceShipmentItems(actionRequest, commerceShipment.getCommerceShipmentId());
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletProviderUtil.getPortletURL((PortletRequest)actionRequest, (Group)themeDisplay.getScopeGroup(), (String)CommerceShipment.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (commerceShipment != null) {
            portletURL.setParameter("mvcRenderCommandName", "viewCommerceShipmentDetail");
            portletURL.setParameter("commerceShipmentId", String.valueOf(commerceShipment.getCommerceShipmentId()));
        }
        this.sendRedirect(actionRequest, actionResponse, portletURL.toString());
    }

    protected CommerceShipment updateCommerceShipment(ActionRequest actionRequest) throws Exception {
        long commerceShipmentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String street1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"street1");
        String street2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"street2");
        String street3 = ParamUtil.getString((PortletRequest)actionRequest, (String)"street3");
        String city = ParamUtil.getString((PortletRequest)actionRequest, (String)"city");
        String zip = ParamUtil.getString((PortletRequest)actionRequest, (String)"zip");
        long commerceRegionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceRegionId");
        long commerceCountryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceCountryId");
        String phoneNumber = ParamUtil.getString((PortletRequest)actionRequest, (String)"phoneNumber");
        String carrier = ParamUtil.getString((PortletRequest)actionRequest, (String)"carrier");
        String trackingNumber = ParamUtil.getString((PortletRequest)actionRequest, (String)"trackingNumber");
        int status = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"status");
        int shippingDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"shippingDateMonth");
        int shippingDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"shippingDateDay");
        int shippingDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"shippingDateYear");
        int shippingDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"shippingDateHour");
        int shippingDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"shippingDateMinute");
        int shippingDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"shippingDateAmPm");
        if (shippingDateAmPm == 1) {
            shippingDateHour += 12;
        }
        int expectedDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expectedDateMonth");
        int expectedDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expectedDateDay");
        int expectedDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expectedDateYear");
        int expectedDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expectedDateHour");
        int expectedDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expectedDateMinute");
        int expectedDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expectedDateAmPm");
        if (expectedDateAmPm == 1) {
            expectedDateHour += 12;
        }
        CommerceShipment commerceShipment = null;
        if (commerceShipmentId > 0L) {
            commerceShipment = this._commerceShipmentService.updateCommerceShipment(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
        } else {
            long commerceOrderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceOrderId");
            if (commerceOrderId > 0L) {
                ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommerceShipment.class.getName(), (PortletRequest)actionRequest);
                commerceShipment = this._commerceShipmentService.addCommerceShipment(commerceOrderId, serviceContext);
            }
        }
        return commerceShipment;
    }
}

