/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipment.web.internal.display.context;

import com.liferay.commerce.constants.CommerceShipmentConstants;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.search.facet.NegatableMultiValueFacet;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceShipmentItemLocalServiceUtil;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.commerce.shipment.web.internal.display.context.BaseCommerceShipmentDisplayContext;
import com.liferay.commerce.shipment.web.internal.portlet.action.ActionHelper;
import com.liferay.commerce.shipment.web.internal.util.CommerceShipmentPortletUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class CommerceShipmentDisplayContext
extends BaseCommerceShipmentDisplayContext<CommerceShipment> {
    private final CommerceChannelService _commerceChannelService;
    private List<CommerceInventoryWarehouse> _commerceInventoryWarehouses;
    private final CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    private final CommerceOrderItemService _commerceOrderItemService;
    private final CommerceOrderLocalService _commerceOrderLocalService;
    private final CommerceShipmentService _commerceShipmentService;

    public CommerceShipmentDisplayContext(ActionHelper actionHelper, HttpServletRequest httpServletRequest, CommerceChannelService commerceChannelService, CommerceOrderItemService commerceOrderItemService, CommerceOrderLocalService commerceOrderLocalService, CommerceShipmentService commerceShipmentService, CommerceInventoryWarehouseService commerceInventoryWarehouseService) {
        super(actionHelper, httpServletRequest, CommerceShipment.class.getSimpleName());
        this._commerceChannelService = commerceChannelService;
        this._commerceOrderItemService = commerceOrderItemService;
        this._commerceOrderLocalService = commerceOrderLocalService;
        this._commerceShipmentService = commerceShipmentService;
        this._commerceInventoryWarehouseService = commerceInventoryWarehouseService;
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        return this._commerceOrderItemService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItemId, commerceInventoryWarehouseId);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses() throws PortalException {
        if (this._commerceInventoryWarehouses != null) {
            return this._commerceInventoryWarehouses;
        }
        this._commerceInventoryWarehouses = this._commerceInventoryWarehouseService.getCommerceInventoryWarehouses(this.cpRequestHelper.getCompanyId(), -1, -1, null);
        return this._commerceInventoryWarehouses;
    }

    public long getCommerceOrderId(long commerceShipmentId) throws PortalException {
        List commerceShipmentItems = CommerceShipmentItemLocalServiceUtil.getCommerceShipmentItems((long)commerceShipmentId, (int)0, (int)1, null);
        if (commerceShipmentItems.isEmpty()) {
            return 0L;
        }
        CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)commerceShipmentItems.get(0);
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        return commerceOrderItem.getCommerceOrderId();
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId) throws PortalException {
        if (commerceOrderId <= 0L) {
            return Collections.emptyList();
        }
        return this._commerceOrderItemService.getAvailableForShipmentCommerceOrderItems(commerceOrderId);
    }

    public List<CommerceOrder> getCommerceOrders() throws PortalException {
        SearchContext searchContext = this._buildSearchContext();
        BaseModelSearchResult baseModelSearchResult = this._commerceOrderLocalService.searchCommerceOrders(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public String getCommerceOrderUrl(long commerceOrderId) throws PortalException {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)this.httpServletRequest, (String)"com_liferay_commerce_order_web_internal_portlet_CommerceOrderPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "editCommerceOrder");
        portletURL.setParameter("commerceOrderId", String.valueOf(commerceOrderId));
        return portletURL.toString();
    }

    public String getCommerceShipmentStatusLabel(int status) {
        return LanguageUtil.get((Locale)this.cpRequestHelper.getLocale(), (String)CommerceShipmentConstants.getShipmentStatusLabel((int)status));
    }

    public String getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this.cpRequestHelper.getRequest(), (String)"navigation", (String)"all");
    }

    public String[] getNavigationKeys() {
        int[] shipmentStatuses = CommerceShipmentConstants.SHIPMENT_STATUSES;
        Object[] navigationKeys = new String[]{};
        navigationKeys = (String[])ArrayUtil.append((Object[])navigationKeys, (Object)"all");
        for (int shipmentStatus : shipmentStatuses) {
            navigationKeys = (String[])ArrayUtil.append((Object[])navigationKeys, (Object)CommerceShipmentConstants.getShipmentStatusLabel((int)shipmentStatus));
        }
        return navigationKeys;
    }

    public int getNumberOfItemsShipped(long commerceShipmentId) throws PortalException {
        return CommerceShipmentItemLocalServiceUtil.getCommerceShipmentItemsCount((long)commerceShipmentId);
    }

    @Override
    public PortletURL getPortletURL() throws PortalException {
        PortletURL portletURL = super.getPortletURL();
        portletURL.setParameter("navigation", this.getNavigation());
        return portletURL;
    }

    @Override
    public SearchContainer<CommerceShipment> getSearchContainer() throws PortalException {
        List results;
        int total;
        if (this.searchContainer != null) {
            return this.searchContainer;
        }
        this.searchContainer = new SearchContainer((PortletRequest)this.liferayPortletRequest, this.getPortletURL(), null, null);
        OrderByComparator<CommerceShipment> orderByComparator = CommerceShipmentPortletUtil.getCommerceShipmentOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        String emptyResultsMessage = "no-shipments-were-found";
        String navigation = this.getNavigation();
        if (!navigation.equals("all")) {
            emptyResultsMessage = LanguageUtil.format((HttpServletRequest)this.cpRequestHelper.getRequest(), (String)"no-x-shipments-were-found", (Object)navigation, (boolean)true);
        }
        this.searchContainer.setEmptyResultsMessage(emptyResultsMessage);
        this.searchContainer.setOrderByCol(this.getOrderByCol());
        this.searchContainer.setOrderByComparator(orderByComparator);
        this.searchContainer.setOrderByType(this.getOrderByType());
        Integer shipmentStatus = CommerceShipmentConstants.getShipmentStatus((String)navigation);
        if (!navigation.equals("all") && shipmentStatus != null) {
            total = this._commerceShipmentService.getCommerceShipmentsCount(this.cpRequestHelper.getCompanyId(), shipmentStatus.intValue());
            results = this._commerceShipmentService.getCommerceShipments(this.cpRequestHelper.getCompanyId(), shipmentStatus.intValue(), this.searchContainer.getStart(), this.searchContainer.getEnd(), orderByComparator);
        } else {
            total = this._commerceShipmentService.getCommerceShipmentsCount(this.cpRequestHelper.getCompanyId());
            results = this._commerceShipmentService.getCommerceShipments(this.cpRequestHelper.getCompanyId(), this.searchContainer.getStart(), this.searchContainer.getEnd(), orderByComparator);
        }
        this.searchContainer.setTotal(total);
        this.searchContainer.setResults(results);
        return this.searchContainer;
    }

    private SearchContext _addFacetOrderStatus(SearchContext searchContext) {
        NegatableMultiValueFacet negatableMultiValueFacet = new NegatableMultiValueFacet(searchContext);
        negatableMultiValueFacet.setFieldName("orderStatus");
        searchContext.addFacet((Facet)negatableMultiValueFacet);
        boolean negated = false;
        negatableMultiValueFacet.setNegated(negated);
        searchContext.setAttribute(negatableMultiValueFacet.getFieldId(), (Serializable)((Object)StringUtil.merge((int[])CommerceShipmentConstants.ALLOWED_ORDER_STATUSES)));
        return searchContext;
    }

    private SearchContext _buildSearchContext() throws PortalException {
        SearchContext searchContext = new SearchContext();
        this._addFacetOrderStatus(searchContext);
        searchContext.setAttribute("useSearchResultPermissionFilter", (Serializable)Boolean.FALSE);
        searchContext.setCompanyId(this.cpRequestHelper.getCompanyId());
        searchContext.setStart(-1);
        searchContext.setEnd(-1);
        long[] commerceChannelGroupIds = this._getCommerceChannelGroupIds();
        if (commerceChannelGroupIds != null && commerceChannelGroupIds.length > 0) {
            searchContext.setGroupIds(commerceChannelGroupIds);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private long[] _getCommerceChannelGroupIds() throws PortalException {
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(this.cpRequestHelper.getCompanyId());
        Stream stream = commerceChannels.stream();
        return stream.mapToLong(CommerceChannel::getGroupId).toArray();
    }
}

