/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipment.web.internal.display.context;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.product.display.context.util.CPRequestHelper;
import com.liferay.commerce.shipment.web.internal.portlet.action.ActionHelper;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseCommerceShipmentDisplayContext<T> {
    protected final ActionHelper actionHelper;
    protected final CPRequestHelper cpRequestHelper;
    protected final HttpServletRequest httpServletRequest;
    protected final LiferayPortletRequest liferayPortletRequest;
    protected final LiferayPortletResponse liferayPortletResponse;
    protected final PortalPreferences portalPreferences;
    protected SearchContainer<T> searchContainer;
    private CommerceShipment _commerceShipment;
    private String _defaultOrderByCol;
    private String _defaultOrderByType;
    private String _displayStyle;
    private String _orderByCol;
    private String _orderByType;
    private final String _portalPreferenceNamespace;
    private RowChecker _rowChecker;

    public BaseCommerceShipmentDisplayContext(ActionHelper actionHelper, HttpServletRequest httpServletRequest, String portalPreferenceNamespace) {
        this.actionHelper = actionHelper;
        this.httpServletRequest = httpServletRequest;
        this.portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this.httpServletRequest);
        this.cpRequestHelper = new CPRequestHelper(httpServletRequest);
        this.liferayPortletRequest = this.cpRequestHelper.getLiferayPortletRequest();
        this.liferayPortletResponse = this.cpRequestHelper.getLiferayPortletResponse();
        this._portalPreferenceNamespace = portalPreferenceNamespace;
        this._defaultOrderByCol = "create-date";
        this._defaultOrderByType = "desc";
    }

    public CommerceShipment getCommerceShipment() throws PortalException {
        if (this._commerceShipment != null) {
            return this._commerceShipment;
        }
        this._commerceShipment = this.actionHelper.getCommerceShipment(this.cpRequestHelper.getRenderRequest());
        return this._commerceShipment;
    }

    public long getCommerceShipmentId() throws PortalException {
        CommerceShipment commerceShipment = this.getCommerceShipment();
        if (commerceShipment == null) {
            return 0L;
        }
        return commerceShipment.getCommerceShipmentId();
    }

    public String getDisplayStyle() {
        if (this._displayStyle == null) {
            this._displayStyle = this.getDisplayStyle(this.httpServletRequest, this.portalPreferences);
        }
        return this._displayStyle;
    }

    public String getKeywords() {
        return ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"keywords");
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"orderByCol");
        if (Validator.isNull((String)this._orderByCol)) {
            this._orderByCol = this.portalPreferences.getValue(this._portalPreferenceNamespace, "order-by-col", this._defaultOrderByCol);
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this.httpServletRequest, (String)"saveOrderBy");
            if (saveOrderBy) {
                this.portalPreferences.setValue(this._portalPreferenceNamespace, "order-by-col", this._orderByCol);
            }
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"orderByType");
        if (Validator.isNull((String)this._orderByType)) {
            this._orderByType = this.portalPreferences.getValue(this._portalPreferenceNamespace, "order-by-type", this._defaultOrderByType);
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this.httpServletRequest, (String)"saveOrderBy");
            if (saveOrderBy) {
                this.portalPreferences.setValue(this._portalPreferenceNamespace, "order-by-type", this._orderByType);
            }
        }
        return this._orderByType;
    }

    public PortletURL getPortletURL() throws PortalException {
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        String deltaEntry;
        String delta;
        CommerceShipment commerceShipment;
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        String redirect = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            portletURL.setParameter("redirect", redirect);
        }
        if ((commerceShipment = this.getCommerceShipment()) != null) {
            portletURL.setParameter("commerceShipmentId", String.valueOf(this.getCommerceShipmentId()));
        }
        if (Validator.isNotNull((String)(delta = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"delta")))) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(deltaEntry = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"deltaEntry")))) {
            portletURL.setParameter("deltaEntry", deltaEntry);
        }
        if (Validator.isNotNull((String)(displayStyle = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"displayStyle")))) {
            portletURL.setParameter("displayStyle", this.getDisplayStyle());
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public RowChecker getRowChecker() {
        if (this._rowChecker == null) {
            this._rowChecker = new EmptyOnClickRowChecker((PortletResponse)this.liferayPortletResponse);
        }
        return this._rowChecker;
    }

    public abstract SearchContainer<T> getSearchContainer() throws PortalException;

    public boolean hasManageCommerceShipmentsPermission() {
        return PortalPermissionUtil.contains((PermissionChecker)this.cpRequestHelper.getPermissionChecker(), (String)"MANAGE_COMMERCE_SHIPMENTS");
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public void setDefaultOrderByCol(String defaultOrderByCol) {
        this._defaultOrderByCol = defaultOrderByCol;
    }

    public void setDefaultOrderByType(String defaultOrderByType) {
        this._defaultOrderByType = defaultOrderByType;
    }

    protected String getDisplayStyle(HttpServletRequest httpServletRequest, PortalPreferences portalPreferences) {
        String displayStyle = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = portalPreferences.getValue(this._portalPreferenceNamespace, "display-style", "list");
        } else {
            portalPreferences.setValue(this._portalPreferenceNamespace, "display-style", displayStyle);
            httpServletRequest.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        return displayStyle;
    }
}

