/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipment.web.internal.display.context;

import com.liferay.commerce.constants.CommerceShipmentConstants;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.commerce.shipment.web.internal.display.context.BaseCommerceShipmentDisplayContext;
import com.liferay.commerce.shipment.web.internal.portlet.action.ActionHelper;
import com.liferay.commerce.shipment.web.internal.util.CommerceShipmentPortletUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class CommerceShipmentDisplayContext
extends BaseCommerceShipmentDisplayContext<CommerceShipment> {
    private List<CommerceInventoryWarehouse> _commerceInventoryWarehouses;
    private final CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    private final CommerceOrderItemService _commerceOrderItemService;
    private final CommerceOrderService _commerceOrderService;
    private final CommerceShipmentService _commerceShipmentService;

    public CommerceShipmentDisplayContext(ActionHelper actionHelper, HttpServletRequest httpServletRequest, CommerceOrderItemService commerceOrderItemService, CommerceOrderService commerceOrderService, CommerceShipmentService commerceShipmentService, CommerceInventoryWarehouseService commerceInventoryWarehouseService) {
        super(actionHelper, httpServletRequest, CommerceShipment.class.getSimpleName());
        this._commerceOrderItemService = commerceOrderItemService;
        this._commerceOrderService = commerceOrderService;
        this._commerceShipmentService = commerceShipmentService;
        this._commerceInventoryWarehouseService = commerceInventoryWarehouseService;
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        return this._commerceOrderItemService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItemId, commerceInventoryWarehouseId);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses() throws PortalException {
        if (this._commerceInventoryWarehouses != null) {
            return this._commerceInventoryWarehouses;
        }
        this._commerceInventoryWarehouses = this._commerceInventoryWarehouseService.getCommerceInventoryWarehouses(this.cpRequestHelper.getCompanyId(), -1, -1, null);
        return this._commerceInventoryWarehouses;
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId) throws PortalException {
        if (commerceOrderId <= 0L) {
            return Collections.emptyList();
        }
        return this._commerceOrderItemService.getAvailableForShipmentCommerceOrderItems(commerceOrderId);
    }

    public List<CommerceOrder> getCommerceOrders() throws PortalException {
        return this._commerceOrderService.getCommerceOrders(this.cpRequestHelper.getChannelGroupId(), CommerceShipmentConstants.ALLOWED_ORDER_STATUSES);
    }

    public String getCommerceShipmentStatusLabel(int status) {
        return LanguageUtil.get((Locale)this.cpRequestHelper.getLocale(), (String)CommerceShipmentConstants.getShipmentStatusLabel((int)status));
    }

    public String getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this.cpRequestHelper.getRequest(), (String)"navigation", (String)"all");
    }

    public String[] getNavigationKeys() {
        int[] shipmentStatuses = CommerceShipmentConstants.SHIPMENT_STATUSES;
        Object[] navigationKeys = new String[]{};
        navigationKeys = (String[])ArrayUtil.append((Object[])navigationKeys, (Object)"all");
        for (int shipmentStatus : shipmentStatuses) {
            navigationKeys = (String[])ArrayUtil.append((Object[])navigationKeys, (Object)CommerceShipmentConstants.getShipmentStatusLabel((int)shipmentStatus));
        }
        return navigationKeys;
    }

    @Override
    public PortletURL getPortletURL() throws PortalException {
        PortletURL portletURL = super.getPortletURL();
        portletURL.setParameter("navigation", this.getNavigation());
        return portletURL;
    }

    @Override
    public SearchContainer<CommerceShipment> getSearchContainer() throws PortalException {
        List results;
        int total;
        if (this.searchContainer != null) {
            return this.searchContainer;
        }
        this.searchContainer = new SearchContainer((PortletRequest)this.liferayPortletRequest, this.getPortletURL(), null, null);
        OrderByComparator<CommerceShipment> orderByComparator = CommerceShipmentPortletUtil.getCommerceShipmentOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        String emptyResultsMessage = "no-shipments-were-found";
        String navigation = this.getNavigation();
        if (!navigation.equals("all")) {
            emptyResultsMessage = LanguageUtil.format((HttpServletRequest)this.cpRequestHelper.getRequest(), (String)"no-x-shipments-were-found", (Object)navigation, (boolean)true);
        }
        this.searchContainer.setEmptyResultsMessage(emptyResultsMessage);
        this.searchContainer.setOrderByCol(this.getOrderByCol());
        this.searchContainer.setOrderByComparator(orderByComparator);
        this.searchContainer.setOrderByType(this.getOrderByType());
        Integer shipmentStatus = CommerceShipmentConstants.getShipmentStatus((String)navigation);
        if (!navigation.equals("all") && shipmentStatus != null) {
            total = this._commerceShipmentService.getCommerceShipmentsCount(this.cpRequestHelper.getCompanyId(), shipmentStatus.intValue());
            results = this._commerceShipmentService.getCommerceShipments(this.cpRequestHelper.getCompanyId(), shipmentStatus.intValue(), this.searchContainer.getStart(), this.searchContainer.getEnd(), orderByComparator);
        } else {
            total = this._commerceShipmentService.getCommerceShipmentsCount(this.cpRequestHelper.getCompanyId());
            results = this._commerceShipmentService.getCommerceShipments(this.cpRequestHelper.getCompanyId(), this.searchContainer.getStart(), this.searchContainer.getEnd(), orderByComparator);
        }
        this.searchContainer.setTotal(total);
        this.searchContainer.setResults(results);
        return this.searchContainer;
    }
}

