/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipment.web.internal.portlet.action;

import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.exception.NoSuchShipmentItemException;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_commerce_shipment_web_internal_portlet_CommerceShipmentPortlet", "mvc.command.name=editCommerceShipmentItem"}, service={MVCActionCommand.class})
public class EditCommerceShipmentItemMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;

    protected void deleteCommerceShipmentItems(ActionRequest actionRequest) throws PortalException {
        long[] deleteCommerceShipmentItemIds = null;
        long commerceShipmentItemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentItemId");
        deleteCommerceShipmentItemIds = commerceShipmentItemId > 0L ? new long[]{commerceShipmentItemId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCommerceShipmentItemIds"), (long)0L);
        for (long deleteCommerceShipmentItemId : deleteCommerceShipmentItemIds) {
            this._commerceShipmentItemService.deleteCommerceShipmentItem(deleteCommerceShipmentItemId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteCommerceShipmentItems(actionRequest);
            } else if (cmd.equals("update")) {
                this.updateCommerceShipmentItem(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof CommerceShipmentItemQuantityException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                String redirect = this.getSaveAndContinueRedirect(actionRequest);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
            if (e instanceof NoSuchShipmentItemException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest) throws Exception {
        long commerceShipmentItemId;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletProviderUtil.getPortletURL((PortletRequest)actionRequest, (Group)themeDisplay.getScopeGroup(), (String)CommerceShipment.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        portletURL.setParameter("mvcRenderCommandName", "editCommerceShipmentItem");
        long commerceShipmentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentId");
        if (commerceShipmentId > 0L) {
            portletURL.setParameter("commerceShipmentId", String.valueOf(commerceShipmentId));
        }
        if ((commerceShipmentItemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentItemId")) > 0L) {
            portletURL.setParameter("commerceShipmentItemId", String.valueOf(commerceShipmentItemId));
        }
        return portletURL.toString();
    }

    protected CommerceShipmentItem updateCommerceShipmentItem(ActionRequest actionRequest) throws PortalException {
        long commerceShipmentItemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceShipmentItemId");
        int quantity = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"quantity");
        return this._commerceShipmentItemService.updateCommerceShipmentItem(commerceShipmentItemId, quantity);
    }
}

