/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipment.web.internal.portlet.action;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceShipmentItemLocalService;
import com.liferay.commerce.service.CommerceShipmentLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ActionHelper.class})
public class ActionHelper {
    @Reference
    private CommerceShipmentItemLocalService _commerceShipmentItemLocalService;
    @Reference
    private CommerceShipmentLocalService _commerceShipmentLocalService;

    public CommerceShipment getCommerceShipment(RenderRequest renderRequest) throws PortalException {
        CommerceShipment commerceShipment = (CommerceShipment)renderRequest.getAttribute("COMMERCE_SHIPMENT");
        if (commerceShipment != null) {
            return commerceShipment;
        }
        long commerceShipmentId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"commerceShipmentId");
        if (commerceShipmentId > 0L) {
            commerceShipment = this._commerceShipmentLocalService.fetchCommerceShipment(commerceShipmentId);
        }
        if (commerceShipment != null) {
            renderRequest.setAttribute("COMMERCE_SHIPMENT", (Object)commerceShipment);
        }
        return commerceShipment;
    }

    public CommerceShipmentItem getCommerceShipmentItem(RenderRequest renderRequest) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)renderRequest.getAttribute("COMMERCE_SHIPMENT_ITEM");
        if (commerceShipmentItem != null) {
            return commerceShipmentItem;
        }
        long commerceShipmentItemId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"commerceShipmentItemId");
        if (commerceShipmentItemId > 0L) {
            commerceShipmentItem = this._commerceShipmentItemLocalService.fetchCommerceShipmentItem(commerceShipmentItemId);
        }
        if (commerceShipmentItem != null) {
            renderRequest.setAttribute("COMMERCE_SHIPMENT_ITEM", (Object)commerceShipmentItem);
        }
        return commerceShipmentItem;
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(ResourceRequest resourceRequest) throws PortalException {
        long[] commerceShipmentItemIds;
        ArrayList<CommerceShipmentItem> commerceShipmentItems = new ArrayList<CommerceShipmentItem>();
        for (long commerceShipmentItemId : commerceShipmentItemIds = ParamUtil.getLongValues((PortletRequest)resourceRequest, (String)"rowIds")) {
            CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemLocalService.getCommerceShipmentItem(commerceShipmentItemId);
            commerceShipmentItems.add(commerceShipmentItem);
        }
        return commerceShipmentItems;
    }

    public List<CommerceShipment> getCommerceShipments(ResourceRequest resourceRequest) throws PortalException {
        long[] commerceShipmentIds;
        ArrayList<CommerceShipment> commerceShipments = new ArrayList<CommerceShipment>();
        for (long commerceShipmentId : commerceShipmentIds = ParamUtil.getLongValues((PortletRequest)resourceRequest, (String)"rowIds")) {
            CommerceShipment commerceShipment = this._commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
            commerceShipments.add(commerceShipment);
        }
        return commerceShipments;
    }
}

