/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.shipment.web.internal.display.context;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.commerce.shipment.web.internal.display.context.BaseCommerceShipmentDisplayContext;
import com.liferay.commerce.shipment.web.internal.portlet.action.ActionHelper;
import com.liferay.commerce.shipment.web.internal.util.CommerceShipmentPortletUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class CommerceShipmentItemDisplayContext
extends BaseCommerceShipmentDisplayContext<CommerceShipmentItem> {
    private final CommerceOrderItemService _commerceOrderItemService;
    private CommerceShipmentItem _commerceShipmentItem;
    private final CommerceShipmentItemService _commerceShipmentItemService;

    public CommerceShipmentItemDisplayContext(ActionHelper actionHelper, HttpServletRequest httpServletRequest, CommerceOrderItemService commerceOrderItemService, CommerceShipmentItemService commerceShipmentItemService, PortletResourcePermission portletResourcePermission) {
        super(actionHelper, httpServletRequest, CommerceShipmentItem.class.getSimpleName(), portletResourcePermission);
        this._commerceOrderItemService = commerceOrderItemService;
        this._commerceShipmentItemService = commerceShipmentItemService;
    }

    public String getAddCommerceShipmentItemsURL() throws PortalException {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        SearchContainer<CommerceShipmentItem> commerceShipmentItemSearchContainer = this.getSearchContainer();
        List commerceShipmentItems = commerceShipmentItemSearchContainer.getResults();
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this.httpServletRequest));
        if (this.getCommerceShipmentId() > 0L) {
            portletURL.setParameter("commerceShipmentId", String.valueOf(this.getCommerceShipmentId()));
        }
        if (commerceShipmentItems.isEmpty()) {
            portletURL.setParameter("mvcRenderCommandName", "editCommerceShipment");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "selectCommerceShipmentItems");
            CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)commerceShipmentItems.get(0);
            CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
            portletURL.setParameter("commerceOrderId", String.valueOf(commerceOrderItem.getCommerceOrderId()));
        }
        return portletURL.toString();
    }

    public CommerceShipmentItem getCommerceShipmentItem() throws PortalException {
        if (this._commerceShipmentItem != null) {
            return this._commerceShipmentItem;
        }
        this._commerceShipmentItem = this.actionHelper.getCommerceShipmentItem(this.cpRequestHelper.getRenderRequest());
        return this._commerceShipmentItem;
    }

    public long getCommerceShipmentItemId() throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.getCommerceShipmentItem();
        if (commerceShipmentItem == null) {
            return 0L;
        }
        return commerceShipmentItem.getCommerceShipmentItemId();
    }

    @Override
    public PortletURL getPortletURL() throws PortalException {
        PortletURL portletURL = super.getPortletURL();
        portletURL.setParameter("mvcRenderCommandName", "viewCommerceShipmentDetail");
        return portletURL;
    }

    @Override
    public SearchContainer<CommerceShipmentItem> getSearchContainer() throws PortalException {
        if (this.searchContainer != null) {
            return this.searchContainer;
        }
        this.searchContainer = new SearchContainer((PortletRequest)this.liferayPortletRequest, this.getPortletURL(), null, null);
        OrderByComparator<CommerceShipmentItem> orderByComparator = CommerceShipmentPortletUtil.getCommerceShipmentItemOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        this.searchContainer.setEmptyResultsMessage("no-shipment-items-were-found");
        this.searchContainer.setOrderByCol(this.getOrderByCol());
        this.searchContainer.setOrderByComparator(orderByComparator);
        this.searchContainer.setOrderByType(this.getOrderByType());
        int total = this._commerceShipmentItemService.getCommerceShipmentItemsCount(this.getCommerceShipmentId());
        this.searchContainer.setTotal(total);
        List results = this._commerceShipmentItemService.getCommerceShipmentItems(this.getCommerceShipmentId(), this.searchContainer.getStart(), this.searchContainer.getEnd(), orderByComparator);
        this.searchContainer.setResults(results);
        return this.searchContainer;
    }
}

