/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceMessagingConfigurator.class})
public class CommerceMessagingConfigurator {
    @Reference
    private DestinationFactory _destinationFactory;
    private volatile ServiceRegistration<Destination> _orderStatusServiceRegistration;
    private volatile ServiceRegistration<Destination> _paymentStatusServiceRegistration;
    private volatile ServiceRegistration<Destination> _shipmentStatusServiceRegistration;
    private volatile ServiceRegistration<Destination> _stockQuantityServiceRegistration;
    private volatile ServiceRegistration<Destination> _subscriptionStatusServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._orderStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/order_status");
        this._paymentStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/payment_status");
        this._shipmentStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/shipment_status");
        this._stockQuantityServiceRegistration = this._registerDestination(bundleContext, "liferay/stock_quantity");
        this._subscriptionStatusServiceRegistration = this._registerDestination(bundleContext, "liferay/subscription_status");
    }

    @Deactivate
    protected void deactivate() {
        if (this._orderStatusServiceRegistration != null) {
            this._orderStatusServiceRegistration.unregister();
        }
        if (this._paymentStatusServiceRegistration != null) {
            this._paymentStatusServiceRegistration.unregister();
        }
        if (this._shipmentStatusServiceRegistration != null) {
            this._shipmentStatusServiceRegistration.unregister();
        }
        if (this._stockQuantityServiceRegistration != null) {
            this._stockQuantityServiceRegistration.unregister();
        }
        if (this._subscriptionStatusServiceRegistration != null) {
            this._subscriptionStatusServiceRegistration.unregister();
        }
    }

    private ServiceRegistration<Destination> _registerDestination(BundleContext bundleContext, String destinationName) {
        DestinationConfiguration destinationConfiguration = DestinationConfiguration.createParallelDestinationConfiguration((String)destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("destination.name", destination.getName());
        return bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
    }
}

