/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.constants.CommerceSubscriptionNotificationConstants;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/subscription_status"}, service={MessageListener.class})
public class CommerceSubscriptionStatusMessageListener
extends BaseMessageListener {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceNotificationHelper _commerceNotificationHelper;
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;

    protected void doReceive(Message message) throws Exception {
        int subscriptionStatus = message.getInteger("subscriptionStatus");
        long commerceSubscriptionEntryId = message.getLong("commerceSubscriptionEntryId");
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceSubscriptionEntry.getGroupId());
        this._commerceNotificationHelper.sendNotifications(commerceChannel.getSiteGroupId(), commerceSubscriptionEntry.getUserId(), CommerceSubscriptionNotificationConstants.getNotificationKey((int)subscriptionStatus), (Object)commerceSubscriptionEntry);
    }
}

