/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.model.CommerceSubscriptionEntryModel;
import com.liferay.commerce.model.CommerceSubscriptionEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceSubscriptionEntry service. Represents a row in the &quot;CommerceSubscriptionEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceSubscriptionEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceSubscriptionEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceSubscriptionEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceSubscriptionEntryModelImpl
	extends BaseModelImpl<CommerceSubscriptionEntry>
	implements CommerceSubscriptionEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce subscription entry model instance should use the <code>CommerceSubscriptionEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceSubscriptionEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"commerceSubscriptionEntryId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"CPInstanceUuid", Types.VARCHAR}, {"CProductId", Types.BIGINT},
		{"commerceOrderItemId", Types.BIGINT},
		{"subscriptionLength", Types.INTEGER},
		{"subscriptionType", Types.VARCHAR},
		{"subscriptionTypeSettings", Types.CLOB},
		{"currentCycle", Types.BIGINT}, {"maxSubscriptionCycles", Types.BIGINT},
		{"subscriptionStatus", Types.INTEGER},
		{"lastIterationDate", Types.TIMESTAMP},
		{"nextIterationDate", Types.TIMESTAMP}, {"startDate", Types.TIMESTAMP},
		{"deliverySubscriptionLength", Types.INTEGER},
		{"deliverySubscriptionType", Types.VARCHAR},
		{"deliverySubTypeSettings", Types.VARCHAR},
		{"deliveryCurrentCycle", Types.BIGINT},
		{"deliveryMaxSubscriptionCycles", Types.BIGINT},
		{"deliverySubscriptionStatus", Types.INTEGER},
		{"deliveryLastIterationDate", Types.TIMESTAMP},
		{"deliveryNextIterationDate", Types.TIMESTAMP},
		{"deliveryStartDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceSubscriptionEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("CPInstanceUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("subscriptionLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("subscriptionType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subscriptionTypeSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("currentCycle", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("maxSubscriptionCycles", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("subscriptionStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lastIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("nextIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("startDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deliverySubTypeSettings", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deliveryCurrentCycle", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("deliveryMaxSubscriptionCycles", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("deliveryLastIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("deliveryNextIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("deliveryStartDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceSubscriptionEntry (uuid_ VARCHAR(75) null,commerceSubscriptionEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,CPInstanceUuid VARCHAR(75) null,CProductId LONG,commerceOrderItemId LONG,subscriptionLength INTEGER,subscriptionType VARCHAR(75) null,subscriptionTypeSettings TEXT null,currentCycle LONG,maxSubscriptionCycles LONG,subscriptionStatus INTEGER,lastIterationDate DATE null,nextIterationDate DATE null,startDate DATE null,deliverySubscriptionLength INTEGER,deliverySubscriptionType VARCHAR(75) null,deliverySubTypeSettings VARCHAR(75) null,deliveryCurrentCycle LONG,deliveryMaxSubscriptionCycles LONG,deliverySubscriptionStatus INTEGER,deliveryLastIterationDate DATE null,deliveryNextIterationDate DATE null,deliveryStartDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceSubscriptionEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceSubscriptionEntry.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceSubscriptionEntry.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceSubscriptionEntry"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceSubscriptionEntry"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceSubscriptionEntry"),
		true);

	public static final long CPINSTANCEUUID_COLUMN_BITMASK = 1L;

	public static final long CPRODUCTID_COLUMN_BITMASK = 2L;

	public static final long COMMERCEORDERITEMID_COLUMN_BITMASK = 4L;

	public static final long COMPANYID_COLUMN_BITMASK = 8L;

	public static final long GROUPID_COLUMN_BITMASK = 16L;

	public static final long SUBSCRIPTIONSTATUS_COLUMN_BITMASK = 32L;

	public static final long USERID_COLUMN_BITMASK = 64L;

	public static final long UUID_COLUMN_BITMASK = 128L;

	public static final long CREATEDATE_COLUMN_BITMASK = 256L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceSubscriptionEntry toModel(
		CommerceSubscriptionEntrySoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommerceSubscriptionEntry model = new CommerceSubscriptionEntryImpl();

		model.setUuid(soapModel.getUuid());
		model.setCommerceSubscriptionEntryId(
			soapModel.getCommerceSubscriptionEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCPInstanceUuid(soapModel.getCPInstanceUuid());
		model.setCProductId(soapModel.getCProductId());
		model.setCommerceOrderItemId(soapModel.getCommerceOrderItemId());
		model.setSubscriptionLength(soapModel.getSubscriptionLength());
		model.setSubscriptionType(soapModel.getSubscriptionType());
		model.setSubscriptionTypeSettings(
			soapModel.getSubscriptionTypeSettings());
		model.setCurrentCycle(soapModel.getCurrentCycle());
		model.setMaxSubscriptionCycles(soapModel.getMaxSubscriptionCycles());
		model.setSubscriptionStatus(soapModel.getSubscriptionStatus());
		model.setLastIterationDate(soapModel.getLastIterationDate());
		model.setNextIterationDate(soapModel.getNextIterationDate());
		model.setStartDate(soapModel.getStartDate());
		model.setDeliverySubscriptionLength(
			soapModel.getDeliverySubscriptionLength());
		model.setDeliverySubscriptionType(
			soapModel.getDeliverySubscriptionType());
		model.setDeliverySubscriptionTypeSettings(
			soapModel.getDeliverySubscriptionTypeSettings());
		model.setDeliveryCurrentCycle(soapModel.getDeliveryCurrentCycle());
		model.setDeliveryMaxSubscriptionCycles(
			soapModel.getDeliveryMaxSubscriptionCycles());
		model.setDeliverySubscriptionStatus(
			soapModel.getDeliverySubscriptionStatus());
		model.setDeliveryLastIterationDate(
			soapModel.getDeliveryLastIterationDate());
		model.setDeliveryNextIterationDate(
			soapModel.getDeliveryNextIterationDate());
		model.setDeliveryStartDate(soapModel.getDeliveryStartDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceSubscriptionEntry> toModels(
		CommerceSubscriptionEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceSubscriptionEntry> models =
			new ArrayList<CommerceSubscriptionEntry>(soapModels.length);

		for (CommerceSubscriptionEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceSubscriptionEntry"));

	public CommerceSubscriptionEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceSubscriptionEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceSubscriptionEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceSubscriptionEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceSubscriptionEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceSubscriptionEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceSubscriptionEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceSubscriptionEntry, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceSubscriptionEntry)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceSubscriptionEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceSubscriptionEntry, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceSubscriptionEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceSubscriptionEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceSubscriptionEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceSubscriptionEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceSubscriptionEntry.class.getClassLoader(),
			CommerceSubscriptionEntry.class, ModelWrapper.class);

		try {
			Constructor<CommerceSubscriptionEntry> constructor =
				(Constructor<CommerceSubscriptionEntry>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<CommerceSubscriptionEntry, Object>>
			_attributeGetterFunctions;

	static {
		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceSubscriptionEntry, Object>>();

		attributeGetterFunctions.put(
			"uuid",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getUuid();
				}

			});
		attributeGetterFunctions.put(
			"commerceSubscriptionEntryId",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getCommerceSubscriptionEntryId();
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getGroupId();
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getCompanyId();
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getUserId();
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getUserName();
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getCreateDate();
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getModifiedDate();
				}

			});
		attributeGetterFunctions.put(
			"CPInstanceUuid",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getCPInstanceUuid();
				}

			});
		attributeGetterFunctions.put(
			"CProductId",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getCProductId();
				}

			});
		attributeGetterFunctions.put(
			"commerceOrderItemId",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getCommerceOrderItemId();
				}

			});
		attributeGetterFunctions.put(
			"subscriptionLength",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getSubscriptionLength();
				}

			});
		attributeGetterFunctions.put(
			"subscriptionType",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getSubscriptionType();
				}

			});
		attributeGetterFunctions.put(
			"subscriptionTypeSettings",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getSubscriptionTypeSettings();
				}

			});
		attributeGetterFunctions.put(
			"currentCycle",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getCurrentCycle();
				}

			});
		attributeGetterFunctions.put(
			"maxSubscriptionCycles",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getMaxSubscriptionCycles();
				}

			});
		attributeGetterFunctions.put(
			"subscriptionStatus",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getSubscriptionStatus();
				}

			});
		attributeGetterFunctions.put(
			"lastIterationDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getLastIterationDate();
				}

			});
		attributeGetterFunctions.put(
			"nextIterationDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getNextIterationDate();
				}

			});
		attributeGetterFunctions.put(
			"startDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getStartDate();
				}

			});
		attributeGetterFunctions.put(
			"deliverySubscriptionLength",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getDeliverySubscriptionLength();
				}

			});
		attributeGetterFunctions.put(
			"deliverySubscriptionType",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getDeliverySubscriptionType();
				}

			});
		attributeGetterFunctions.put(
			"deliverySubscriptionTypeSettings",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getDeliverySubscriptionTypeSettings();
				}

			});
		attributeGetterFunctions.put(
			"deliveryCurrentCycle",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getDeliveryCurrentCycle();
				}

			});
		attributeGetterFunctions.put(
			"deliveryMaxSubscriptionCycles",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getDeliveryMaxSubscriptionCycles();
				}

			});
		attributeGetterFunctions.put(
			"deliverySubscriptionStatus",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getDeliverySubscriptionStatus();
				}

			});
		attributeGetterFunctions.put(
			"deliveryLastIterationDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getDeliveryLastIterationDate();
				}

			});
		attributeGetterFunctions.put(
			"deliveryNextIterationDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.
						getDeliveryNextIterationDate();
				}

			});
		attributeGetterFunctions.put(
			"deliveryStartDate",
			new Function<CommerceSubscriptionEntry, Object>() {

				@Override
				public Object apply(
					CommerceSubscriptionEntry commerceSubscriptionEntry) {

					return commerceSubscriptionEntry.getDeliveryStartDate();
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map
		<String, BiConsumer<CommerceSubscriptionEntry, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<CommerceSubscriptionEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceSubscriptionEntry, ?>>();

		attributeSetterBiConsumers.put(
			"uuid",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object uuidObject) {

					commerceSubscriptionEntry.setUuid((String)uuidObject);
				}

			});
		attributeSetterBiConsumers.put(
			"commerceSubscriptionEntryId",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object commerceSubscriptionEntryIdObject) {

					commerceSubscriptionEntry.setCommerceSubscriptionEntryId(
						(Long)commerceSubscriptionEntryIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object groupIdObject) {

					commerceSubscriptionEntry.setGroupId((Long)groupIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object companyIdObject) {

					commerceSubscriptionEntry.setCompanyId(
						(Long)companyIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object userIdObject) {

					commerceSubscriptionEntry.setUserId((Long)userIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object userNameObject) {

					commerceSubscriptionEntry.setUserName(
						(String)userNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object createDateObject) {

					commerceSubscriptionEntry.setCreateDate(
						(Date)createDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object modifiedDateObject) {

					commerceSubscriptionEntry.setModifiedDate(
						(Date)modifiedDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"CPInstanceUuid",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object CPInstanceUuidObject) {

					commerceSubscriptionEntry.setCPInstanceUuid(
						(String)CPInstanceUuidObject);
				}

			});
		attributeSetterBiConsumers.put(
			"CProductId",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object CProductIdObject) {

					commerceSubscriptionEntry.setCProductId(
						(Long)CProductIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"commerceOrderItemId",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object commerceOrderItemIdObject) {

					commerceSubscriptionEntry.setCommerceOrderItemId(
						(Long)commerceOrderItemIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"subscriptionLength",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object subscriptionLengthObject) {

					commerceSubscriptionEntry.setSubscriptionLength(
						(Integer)subscriptionLengthObject);
				}

			});
		attributeSetterBiConsumers.put(
			"subscriptionType",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object subscriptionTypeObject) {

					commerceSubscriptionEntry.setSubscriptionType(
						(String)subscriptionTypeObject);
				}

			});
		attributeSetterBiConsumers.put(
			"subscriptionTypeSettings",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object subscriptionTypeSettingsObject) {

					commerceSubscriptionEntry.setSubscriptionTypeSettings(
						(String)subscriptionTypeSettingsObject);
				}

			});
		attributeSetterBiConsumers.put(
			"currentCycle",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object currentCycleObject) {

					commerceSubscriptionEntry.setCurrentCycle(
						(Long)currentCycleObject);
				}

			});
		attributeSetterBiConsumers.put(
			"maxSubscriptionCycles",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object maxSubscriptionCyclesObject) {

					commerceSubscriptionEntry.setMaxSubscriptionCycles(
						(Long)maxSubscriptionCyclesObject);
				}

			});
		attributeSetterBiConsumers.put(
			"subscriptionStatus",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object subscriptionStatusObject) {

					commerceSubscriptionEntry.setSubscriptionStatus(
						(Integer)subscriptionStatusObject);
				}

			});
		attributeSetterBiConsumers.put(
			"lastIterationDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object lastIterationDateObject) {

					commerceSubscriptionEntry.setLastIterationDate(
						(Date)lastIterationDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"nextIterationDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object nextIterationDateObject) {

					commerceSubscriptionEntry.setNextIterationDate(
						(Date)nextIterationDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"startDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object startDateObject) {

					commerceSubscriptionEntry.setStartDate(
						(Date)startDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliverySubscriptionLength",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliverySubscriptionLengthObject) {

					commerceSubscriptionEntry.setDeliverySubscriptionLength(
						(Integer)deliverySubscriptionLengthObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliverySubscriptionType",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliverySubscriptionTypeObject) {

					commerceSubscriptionEntry.setDeliverySubscriptionType(
						(String)deliverySubscriptionTypeObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliverySubscriptionTypeSettings",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliverySubscriptionTypeSettingsObject) {

					commerceSubscriptionEntry.
						setDeliverySubscriptionTypeSettings(
							(String)deliverySubscriptionTypeSettingsObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliveryCurrentCycle",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliveryCurrentCycleObject) {

					commerceSubscriptionEntry.setDeliveryCurrentCycle(
						(Long)deliveryCurrentCycleObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliveryMaxSubscriptionCycles",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliveryMaxSubscriptionCyclesObject) {

					commerceSubscriptionEntry.setDeliveryMaxSubscriptionCycles(
						(Long)deliveryMaxSubscriptionCyclesObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliverySubscriptionStatus",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliverySubscriptionStatusObject) {

					commerceSubscriptionEntry.setDeliverySubscriptionStatus(
						(Integer)deliverySubscriptionStatusObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliveryLastIterationDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliveryLastIterationDateObject) {

					commerceSubscriptionEntry.setDeliveryLastIterationDate(
						(Date)deliveryLastIterationDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliveryNextIterationDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliveryNextIterationDateObject) {

					commerceSubscriptionEntry.setDeliveryNextIterationDate(
						(Date)deliveryNextIterationDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"deliveryStartDate",
			new BiConsumer<CommerceSubscriptionEntry, Object>() {

				@Override
				public void accept(
					CommerceSubscriptionEntry commerceSubscriptionEntry,
					Object deliveryStartDateObject) {

					commerceSubscriptionEntry.setDeliveryStartDate(
						(Date)deliveryStartDateObject);
				}

			});

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getCommerceSubscriptionEntryId() {
		return _commerceSubscriptionEntryId;
	}

	@Override
	public void setCommerceSubscriptionEntryId(
		long commerceSubscriptionEntryId) {

		_commerceSubscriptionEntryId = commerceSubscriptionEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getCPInstanceUuid() {
		if (_CPInstanceUuid == null) {
			return "";
		}
		else {
			return _CPInstanceUuid;
		}
	}

	@Override
	public void setCPInstanceUuid(String CPInstanceUuid) {
		_columnBitmask |= CPINSTANCEUUID_COLUMN_BITMASK;

		if (_originalCPInstanceUuid == null) {
			_originalCPInstanceUuid = _CPInstanceUuid;
		}

		_CPInstanceUuid = CPInstanceUuid;
	}

	public String getOriginalCPInstanceUuid() {
		return GetterUtil.getString(_originalCPInstanceUuid);
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		_columnBitmask |= CPRODUCTID_COLUMN_BITMASK;

		if (!_setOriginalCProductId) {
			_setOriginalCProductId = true;

			_originalCProductId = _CProductId;
		}

		_CProductId = CProductId;
	}

	public long getOriginalCProductId() {
		return _originalCProductId;
	}

	@JSON
	@Override
	public long getCommerceOrderItemId() {
		return _commerceOrderItemId;
	}

	@Override
	public void setCommerceOrderItemId(long commerceOrderItemId) {
		_columnBitmask |= COMMERCEORDERITEMID_COLUMN_BITMASK;

		if (!_setOriginalCommerceOrderItemId) {
			_setOriginalCommerceOrderItemId = true;

			_originalCommerceOrderItemId = _commerceOrderItemId;
		}

		_commerceOrderItemId = commerceOrderItemId;
	}

	public long getOriginalCommerceOrderItemId() {
		return _originalCommerceOrderItemId;
	}

	@JSON
	@Override
	public int getSubscriptionLength() {
		return _subscriptionLength;
	}

	@Override
	public void setSubscriptionLength(int subscriptionLength) {
		_subscriptionLength = subscriptionLength;
	}

	@JSON
	@Override
	public String getSubscriptionType() {
		if (_subscriptionType == null) {
			return "";
		}
		else {
			return _subscriptionType;
		}
	}

	@Override
	public void setSubscriptionType(String subscriptionType) {
		_subscriptionType = subscriptionType;
	}

	@JSON
	@Override
	public String getSubscriptionTypeSettings() {
		if (_subscriptionTypeSettings == null) {
			return "";
		}
		else {
			return _subscriptionTypeSettings;
		}
	}

	@Override
	public void setSubscriptionTypeSettings(String subscriptionTypeSettings) {
		_subscriptionTypeSettings = subscriptionTypeSettings;
	}

	@JSON
	@Override
	public long getCurrentCycle() {
		return _currentCycle;
	}

	@Override
	public void setCurrentCycle(long currentCycle) {
		_currentCycle = currentCycle;
	}

	@JSON
	@Override
	public long getMaxSubscriptionCycles() {
		return _maxSubscriptionCycles;
	}

	@Override
	public void setMaxSubscriptionCycles(long maxSubscriptionCycles) {
		_maxSubscriptionCycles = maxSubscriptionCycles;
	}

	@JSON
	@Override
	public int getSubscriptionStatus() {
		return _subscriptionStatus;
	}

	@Override
	public void setSubscriptionStatus(int subscriptionStatus) {
		_columnBitmask |= SUBSCRIPTIONSTATUS_COLUMN_BITMASK;

		if (!_setOriginalSubscriptionStatus) {
			_setOriginalSubscriptionStatus = true;

			_originalSubscriptionStatus = _subscriptionStatus;
		}

		_subscriptionStatus = subscriptionStatus;
	}

	public int getOriginalSubscriptionStatus() {
		return _originalSubscriptionStatus;
	}

	@JSON
	@Override
	public Date getLastIterationDate() {
		return _lastIterationDate;
	}

	@Override
	public void setLastIterationDate(Date lastIterationDate) {
		_lastIterationDate = lastIterationDate;
	}

	@JSON
	@Override
	public Date getNextIterationDate() {
		return _nextIterationDate;
	}

	@Override
	public void setNextIterationDate(Date nextIterationDate) {
		_nextIterationDate = nextIterationDate;
	}

	@JSON
	@Override
	public Date getStartDate() {
		return _startDate;
	}

	@Override
	public void setStartDate(Date startDate) {
		_startDate = startDate;
	}

	@JSON
	@Override
	public int getDeliverySubscriptionLength() {
		return _deliverySubscriptionLength;
	}

	@Override
	public void setDeliverySubscriptionLength(int deliverySubscriptionLength) {
		_deliverySubscriptionLength = deliverySubscriptionLength;
	}

	@JSON
	@Override
	public String getDeliverySubscriptionType() {
		if (_deliverySubscriptionType == null) {
			return "";
		}
		else {
			return _deliverySubscriptionType;
		}
	}

	@Override
	public void setDeliverySubscriptionType(String deliverySubscriptionType) {
		_deliverySubscriptionType = deliverySubscriptionType;
	}

	@JSON
	@Override
	public String getDeliverySubscriptionTypeSettings() {
		if (_deliverySubscriptionTypeSettings == null) {
			return "";
		}
		else {
			return _deliverySubscriptionTypeSettings;
		}
	}

	@Override
	public void setDeliverySubscriptionTypeSettings(
		String deliverySubscriptionTypeSettings) {

		_deliverySubscriptionTypeSettings = deliverySubscriptionTypeSettings;
	}

	@JSON
	@Override
	public long getDeliveryCurrentCycle() {
		return _deliveryCurrentCycle;
	}

	@Override
	public void setDeliveryCurrentCycle(long deliveryCurrentCycle) {
		_deliveryCurrentCycle = deliveryCurrentCycle;
	}

	@JSON
	@Override
	public long getDeliveryMaxSubscriptionCycles() {
		return _deliveryMaxSubscriptionCycles;
	}

	@Override
	public void setDeliveryMaxSubscriptionCycles(
		long deliveryMaxSubscriptionCycles) {

		_deliveryMaxSubscriptionCycles = deliveryMaxSubscriptionCycles;
	}

	@JSON
	@Override
	public int getDeliverySubscriptionStatus() {
		return _deliverySubscriptionStatus;
	}

	@Override
	public void setDeliverySubscriptionStatus(int deliverySubscriptionStatus) {
		_deliverySubscriptionStatus = deliverySubscriptionStatus;
	}

	@JSON
	@Override
	public Date getDeliveryLastIterationDate() {
		return _deliveryLastIterationDate;
	}

	@Override
	public void setDeliveryLastIterationDate(Date deliveryLastIterationDate) {
		_deliveryLastIterationDate = deliveryLastIterationDate;
	}

	@JSON
	@Override
	public Date getDeliveryNextIterationDate() {
		return _deliveryNextIterationDate;
	}

	@Override
	public void setDeliveryNextIterationDate(Date deliveryNextIterationDate) {
		_deliveryNextIterationDate = deliveryNextIterationDate;
	}

	@JSON
	@Override
	public Date getDeliveryStartDate() {
		return _deliveryStartDate;
	}

	@Override
	public void setDeliveryStartDate(Date deliveryStartDate) {
		_deliveryStartDate = deliveryStartDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				CommerceSubscriptionEntry.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceSubscriptionEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceSubscriptionEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceSubscriptionEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceSubscriptionEntryImpl commerceSubscriptionEntryImpl =
			new CommerceSubscriptionEntryImpl();

		commerceSubscriptionEntryImpl.setUuid(getUuid());
		commerceSubscriptionEntryImpl.setCommerceSubscriptionEntryId(
			getCommerceSubscriptionEntryId());
		commerceSubscriptionEntryImpl.setGroupId(getGroupId());
		commerceSubscriptionEntryImpl.setCompanyId(getCompanyId());
		commerceSubscriptionEntryImpl.setUserId(getUserId());
		commerceSubscriptionEntryImpl.setUserName(getUserName());
		commerceSubscriptionEntryImpl.setCreateDate(getCreateDate());
		commerceSubscriptionEntryImpl.setModifiedDate(getModifiedDate());
		commerceSubscriptionEntryImpl.setCPInstanceUuid(getCPInstanceUuid());
		commerceSubscriptionEntryImpl.setCProductId(getCProductId());
		commerceSubscriptionEntryImpl.setCommerceOrderItemId(
			getCommerceOrderItemId());
		commerceSubscriptionEntryImpl.setSubscriptionLength(
			getSubscriptionLength());
		commerceSubscriptionEntryImpl.setSubscriptionType(
			getSubscriptionType());
		commerceSubscriptionEntryImpl.setSubscriptionTypeSettings(
			getSubscriptionTypeSettings());
		commerceSubscriptionEntryImpl.setCurrentCycle(getCurrentCycle());
		commerceSubscriptionEntryImpl.setMaxSubscriptionCycles(
			getMaxSubscriptionCycles());
		commerceSubscriptionEntryImpl.setSubscriptionStatus(
			getSubscriptionStatus());
		commerceSubscriptionEntryImpl.setLastIterationDate(
			getLastIterationDate());
		commerceSubscriptionEntryImpl.setNextIterationDate(
			getNextIterationDate());
		commerceSubscriptionEntryImpl.setStartDate(getStartDate());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionLength(
			getDeliverySubscriptionLength());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionType(
			getDeliverySubscriptionType());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionTypeSettings(
			getDeliverySubscriptionTypeSettings());
		commerceSubscriptionEntryImpl.setDeliveryCurrentCycle(
			getDeliveryCurrentCycle());
		commerceSubscriptionEntryImpl.setDeliveryMaxSubscriptionCycles(
			getDeliveryMaxSubscriptionCycles());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionStatus(
			getDeliverySubscriptionStatus());
		commerceSubscriptionEntryImpl.setDeliveryLastIterationDate(
			getDeliveryLastIterationDate());
		commerceSubscriptionEntryImpl.setDeliveryNextIterationDate(
			getDeliveryNextIterationDate());
		commerceSubscriptionEntryImpl.setDeliveryStartDate(
			getDeliveryStartDate());

		commerceSubscriptionEntryImpl.resetOriginalValues();

		return commerceSubscriptionEntryImpl;
	}

	@Override
	public int compareTo(CommerceSubscriptionEntry commerceSubscriptionEntry) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceSubscriptionEntry.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceSubscriptionEntry)) {
			return false;
		}

		CommerceSubscriptionEntry commerceSubscriptionEntry =
			(CommerceSubscriptionEntry)object;

		long primaryKey = commerceSubscriptionEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_originalUserId = _userId;

		_setOriginalUserId = false;

		_setModifiedDate = false;
		_originalCPInstanceUuid = _CPInstanceUuid;

		_originalCProductId = _CProductId;

		_setOriginalCProductId = false;

		_originalCommerceOrderItemId = _commerceOrderItemId;

		_setOriginalCommerceOrderItemId = false;

		_originalSubscriptionStatus = _subscriptionStatus;

		_setOriginalSubscriptionStatus = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceSubscriptionEntry> toCacheModel() {
		CommerceSubscriptionEntryCacheModel
			commerceSubscriptionEntryCacheModel =
				new CommerceSubscriptionEntryCacheModel();

		commerceSubscriptionEntryCacheModel.uuid = getUuid();

		String uuid = commerceSubscriptionEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceSubscriptionEntryCacheModel.uuid = null;
		}

		commerceSubscriptionEntryCacheModel.commerceSubscriptionEntryId =
			getCommerceSubscriptionEntryId();

		commerceSubscriptionEntryCacheModel.groupId = getGroupId();

		commerceSubscriptionEntryCacheModel.companyId = getCompanyId();

		commerceSubscriptionEntryCacheModel.userId = getUserId();

		commerceSubscriptionEntryCacheModel.userName = getUserName();

		String userName = commerceSubscriptionEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceSubscriptionEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceSubscriptionEntryCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceSubscriptionEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceSubscriptionEntryCacheModel.CPInstanceUuid =
			getCPInstanceUuid();

		String CPInstanceUuid =
			commerceSubscriptionEntryCacheModel.CPInstanceUuid;

		if ((CPInstanceUuid != null) && (CPInstanceUuid.length() == 0)) {
			commerceSubscriptionEntryCacheModel.CPInstanceUuid = null;
		}

		commerceSubscriptionEntryCacheModel.CProductId = getCProductId();

		commerceSubscriptionEntryCacheModel.commerceOrderItemId =
			getCommerceOrderItemId();

		commerceSubscriptionEntryCacheModel.subscriptionLength =
			getSubscriptionLength();

		commerceSubscriptionEntryCacheModel.subscriptionType =
			getSubscriptionType();

		String subscriptionType =
			commerceSubscriptionEntryCacheModel.subscriptionType;

		if ((subscriptionType != null) && (subscriptionType.length() == 0)) {
			commerceSubscriptionEntryCacheModel.subscriptionType = null;
		}

		commerceSubscriptionEntryCacheModel.subscriptionTypeSettings =
			getSubscriptionTypeSettings();

		String subscriptionTypeSettings =
			commerceSubscriptionEntryCacheModel.subscriptionTypeSettings;

		if ((subscriptionTypeSettings != null) &&
			(subscriptionTypeSettings.length() == 0)) {

			commerceSubscriptionEntryCacheModel.subscriptionTypeSettings = null;
		}

		commerceSubscriptionEntryCacheModel.currentCycle = getCurrentCycle();

		commerceSubscriptionEntryCacheModel.maxSubscriptionCycles =
			getMaxSubscriptionCycles();

		commerceSubscriptionEntryCacheModel.subscriptionStatus =
			getSubscriptionStatus();

		Date lastIterationDate = getLastIterationDate();

		if (lastIterationDate != null) {
			commerceSubscriptionEntryCacheModel.lastIterationDate =
				lastIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.lastIterationDate =
				Long.MIN_VALUE;
		}

		Date nextIterationDate = getNextIterationDate();

		if (nextIterationDate != null) {
			commerceSubscriptionEntryCacheModel.nextIterationDate =
				nextIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.nextIterationDate =
				Long.MIN_VALUE;
		}

		Date startDate = getStartDate();

		if (startDate != null) {
			commerceSubscriptionEntryCacheModel.startDate = startDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.startDate = Long.MIN_VALUE;
		}

		commerceSubscriptionEntryCacheModel.deliverySubscriptionLength =
			getDeliverySubscriptionLength();

		commerceSubscriptionEntryCacheModel.deliverySubscriptionType =
			getDeliverySubscriptionType();

		String deliverySubscriptionType =
			commerceSubscriptionEntryCacheModel.deliverySubscriptionType;

		if ((deliverySubscriptionType != null) &&
			(deliverySubscriptionType.length() == 0)) {

			commerceSubscriptionEntryCacheModel.deliverySubscriptionType = null;
		}

		commerceSubscriptionEntryCacheModel.deliverySubscriptionTypeSettings =
			getDeliverySubscriptionTypeSettings();

		String deliverySubscriptionTypeSettings =
			commerceSubscriptionEntryCacheModel.
				deliverySubscriptionTypeSettings;

		if ((deliverySubscriptionTypeSettings != null) &&
			(deliverySubscriptionTypeSettings.length() == 0)) {

			commerceSubscriptionEntryCacheModel.
				deliverySubscriptionTypeSettings = null;
		}

		commerceSubscriptionEntryCacheModel.deliveryCurrentCycle =
			getDeliveryCurrentCycle();

		commerceSubscriptionEntryCacheModel.deliveryMaxSubscriptionCycles =
			getDeliveryMaxSubscriptionCycles();

		commerceSubscriptionEntryCacheModel.deliverySubscriptionStatus =
			getDeliverySubscriptionStatus();

		Date deliveryLastIterationDate = getDeliveryLastIterationDate();

		if (deliveryLastIterationDate != null) {
			commerceSubscriptionEntryCacheModel.deliveryLastIterationDate =
				deliveryLastIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.deliveryLastIterationDate =
				Long.MIN_VALUE;
		}

		Date deliveryNextIterationDate = getDeliveryNextIterationDate();

		if (deliveryNextIterationDate != null) {
			commerceSubscriptionEntryCacheModel.deliveryNextIterationDate =
				deliveryNextIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.deliveryNextIterationDate =
				Long.MIN_VALUE;
		}

		Date deliveryStartDate = getDeliveryStartDate();

		if (deliveryStartDate != null) {
			commerceSubscriptionEntryCacheModel.deliveryStartDate =
				deliveryStartDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.deliveryStartDate =
				Long.MIN_VALUE;
		}

		return commerceSubscriptionEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceSubscriptionEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceSubscriptionEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceSubscriptionEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceSubscriptionEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceSubscriptionEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((CommerceSubscriptionEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceSubscriptionEntry>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private String _uuid;
	private String _originalUuid;
	private long _commerceSubscriptionEntryId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _CPInstanceUuid;
	private String _originalCPInstanceUuid;
	private long _CProductId;
	private long _originalCProductId;
	private boolean _setOriginalCProductId;
	private long _commerceOrderItemId;
	private long _originalCommerceOrderItemId;
	private boolean _setOriginalCommerceOrderItemId;
	private int _subscriptionLength;
	private String _subscriptionType;
	private String _subscriptionTypeSettings;
	private long _currentCycle;
	private long _maxSubscriptionCycles;
	private int _subscriptionStatus;
	private int _originalSubscriptionStatus;
	private boolean _setOriginalSubscriptionStatus;
	private Date _lastIterationDate;
	private Date _nextIterationDate;
	private Date _startDate;
	private int _deliverySubscriptionLength;
	private String _deliverySubscriptionType;
	private String _deliverySubscriptionTypeSettings;
	private long _deliveryCurrentCycle;
	private long _deliveryMaxSubscriptionCycles;
	private int _deliverySubscriptionStatus;
	private Date _deliveryLastIterationDate;
	private Date _deliveryNextIterationDate;
	private Date _deliveryStartDate;
	private long _columnBitmask;
	private CommerceSubscriptionEntry _escapedModel;

}