/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Luca Pellizzon
 * @author Alessio Antonio Rendina
 */
@ExtendedObjectClassDefinition(
	category = "catalog", scope = ExtendedObjectClassDefinition.Scope.SYSTEM
)
@Meta.OCD(
	id = "com.liferay.commerce.configuration.CommerceSubscriptionConfiguration",
	localization = "content/Language",
	name = "commerce-subscription-configuration-name"
)
public interface CommerceSubscriptionConfiguration {

	@Meta.AD(
		deflt = "10", name = "renewal-check-interval-minutes", required = false
	)
	public int renewalCheckIntervalMinutes();

	@Meta.AD(
		deflt = "false", name = "subscription-cancellation-allowed",
		required = false
	)
	public boolean subscriptionCancellationAllowed();

	@Meta.AD(
		deflt = "false", name = "subscription-suspension-allowed",
		required = false
	)
	public boolean subscriptionSuspensionAllowed();

}