/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.model.impl;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.util.Arrays;

/**
 * @author Alessio Antonio Rendina
 */
public class CPDefinitionInventoryImpl extends CPDefinitionInventoryBaseImpl {

	public CPDefinitionInventoryImpl() {
	}

	public int[] getAllowedOrderQuantitiesArray() {
		String allowedOrderQuantitiesString = getAllowedOrderQuantities();

		if (Validator.isNull(allowedOrderQuantitiesString)) {
			return new int[0];
		}

		allowedOrderQuantitiesString = allowedOrderQuantitiesString.replaceAll(
			" *(, *)|(\\. *)|( +)", StringPool.COMMA);

		int[] allowedOrderQuantities = StringUtil.split(
			allowedOrderQuantitiesString, 0);

		Arrays.sort(allowedOrderQuantities);

		return allowedOrderQuantities;
	}

}