/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v1_1_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class BaseCommerceOrderUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceOrderUpgradeProcess.class);
    private final String _columnName;
    private final String _columnType;
    private final Class _entityClass;
    private final String _tableName;

    public BaseCommerceOrderUpgradeProcess(Class entityClass, String tableName, String columnName, String columnType) {
        this._entityClass = entityClass;
        this._tableName = tableName;
        this._columnName = columnName;
        this._columnType = columnType;
    }

    protected void doUpgrade() throws Exception {
        this._addColumn();
    }

    private void _addColumn() throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", this._columnName, this._tableName));
        }
        if (!this.hasColumn(this._tableName, this._columnName)) {
            this.alter(this._entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, this._columnName + " " + this._columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", this._columnName, this._tableName));
        }
    }
}

