/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.starter;

import com.liferay.commerce.starter.CommerceRegionsStarter;
import com.liferay.portal.kernel.language.LanguageUtil;

import java.util.Locale;

import org.osgi.service.component.annotations.Component;

/**
 * @author Riccardo Alberti
 */
@Component(
	immediate = true,
	property = "commerce.region.starter.key=" + SwitzerlandCommerceRegionsStarter.SWITZERLAND_NUMERIC_ISO_CODE,
	service = CommerceRegionsStarter.class
)
public class SwitzerlandCommerceRegionsStarter
	extends BaseCommerceRegionsStarter {

	public static final int SWITZERLAND_NUMERIC_ISO_CODE = 756;

	@Override
	public String getLabel(Locale locale) {
		return LanguageUtil.get(locale, "country.switzerland");
	}

	@Override
	protected int getCountryIsoCode() {
		return SWITZERLAND_NUMERIC_ISO_CODE;
	}

	@Override
	protected String getFilePath() {
		return _FILEPATH;
	}

	private static final String _FILEPATH =
		"com/liferay/commerce/internal/switzerland.json";

}