/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.security.permission.resource;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.ActionKeys;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;

import java.util.Objects;
import java.util.function.ToLongFunction;

/**
 * @author Marco Leo
 */
public class CommerceOrderWorkflowedModelPermissionLogic
	implements ModelResourcePermissionLogic<CommerceOrder> {

	public CommerceOrderWorkflowedModelPermissionLogic(
		WorkflowPermission workflowPermission,
		ModelResourcePermission<CommerceOrder> modelResourcePermission,
		ToLongFunction<CommerceOrder> primKeyToLongFunction) {

		_workflowPermission = Objects.requireNonNull(workflowPermission);
		_modelResourcePermission = Objects.requireNonNull(
			modelResourcePermission);
		_primKeyToLongFunction = Objects.requireNonNull(primKeyToLongFunction);
	}

	@Override
	public Boolean contains(
			PermissionChecker permissionChecker, String name,
			CommerceOrder commerceOrder, String actionId)
		throws PortalException {

		if (commerceOrder.isDraft() || commerceOrder.isScheduled()) {
			if (!actionId.equals(ActionKeys.VIEW) ||
				_modelResourcePermission.contains(
					permissionChecker, commerceOrder, ActionKeys.UPDATE)) {

				return null;
			}

			return false;
		}
		else if (commerceOrder.isPending()) {
			return _workflowPermission.hasPermission(
				permissionChecker, commerceOrder.getGroupId(), name,
				_primKeyToLongFunction.applyAsLong(commerceOrder), actionId);
		}

		return null;
	}

	private final ModelResourcePermission<CommerceOrder>
		_modelResourcePermission;
	private final ToLongFunction<CommerceOrder> _primKeyToLongFunction;
	private final WorkflowPermission _workflowPermission;

}