/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.DuplicateCommerceOrderNoteExternalReferenceCodeException;
import com.liferay.commerce.exception.NoSuchOrderNoteException;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.model.impl.CommerceOrderNoteImpl;
import com.liferay.commerce.model.impl.CommerceOrderNoteModelImpl;
import com.liferay.commerce.service.persistence.CommerceOrderNotePersistence;
import com.liferay.commerce.service.persistence.CommerceOrderNoteUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CommerceOrderNotePersistenceImpl
extends BasePersistenceImpl<CommerceOrderNote>
implements CommerceOrderNotePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceOrderNoteImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCommerceOrderId;
    private FinderPath _finderPathWithoutPaginationFindByCommerceOrderId;
    private FinderPath _finderPathCountByCommerceOrderId;
    private static final String _FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2 = "commerceOrderNote.commerceOrderId = ?";
    private FinderPath _finderPathWithPaginationFindByC_R;
    private FinderPath _finderPathWithoutPaginationFindByC_R;
    private FinderPath _finderPathCountByC_R;
    private static final String _FINDER_COLUMN_C_R_COMMERCEORDERID_2 = "commerceOrderNote.commerceOrderId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_RESTRICTED_2 = "commerceOrderNote.restricted = ?";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "commerceOrderNote.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "commerceOrderNote.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(commerceOrderNote.externalReferenceCode IS NULL OR commerceOrderNote.externalReferenceCode = '')";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEORDERNOTE = "SELECT commerceOrderNote FROM CommerceOrderNote commerceOrderNote";
    private static final String _SQL_SELECT_COMMERCEORDERNOTE_WHERE_PKS_IN = "SELECT commerceOrderNote FROM CommerceOrderNote commerceOrderNote WHERE commerceOrderNoteId IN (";
    private static final String _SQL_SELECT_COMMERCEORDERNOTE_WHERE = "SELECT commerceOrderNote FROM CommerceOrderNote commerceOrderNote WHERE ";
    private static final String _SQL_COUNT_COMMERCEORDERNOTE = "SELECT COUNT(commerceOrderNote) FROM CommerceOrderNote commerceOrderNote";
    private static final String _SQL_COUNT_COMMERCEORDERNOTE_WHERE = "SELECT COUNT(commerceOrderNote) FROM CommerceOrderNote commerceOrderNote WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceOrderNote.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceOrderNote exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceOrderNote exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderNotePersistenceImpl.class);

    public List<CommerceOrderNote> findByCommerceOrderId(long commerceOrderId) {
        return this.findByCommerceOrderId(commerceOrderId, -1, -1, null);
    }

    public List<CommerceOrderNote> findByCommerceOrderId(long commerceOrderId, int start, int end) {
        return this.findByCommerceOrderId(commerceOrderId, start, end, null);
    }

    public List<CommerceOrderNote> findByCommerceOrderId(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderNote> orderByComparator) {
        return this.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderNote> findByCommerceOrderId(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderNote> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCommerceOrderId;
                finderArgs = new Object[]{commerceOrderId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCommerceOrderId;
            finderArgs = new Object[]{commerceOrderId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderNote commerceOrderNote : list) {
                if (commerceOrderId == commerceOrderNote.getCommerceOrderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEORDERNOTE_WHERE);
            sb.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderNote.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderNote findByCommerceOrderId_First(long commerceOrderId, OrderByComparator<CommerceOrderNote> orderByComparator) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.fetchByCommerceOrderId_First(commerceOrderId, orderByComparator);
        if (commerceOrderNote != null) {
            return commerceOrderNote;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append("}");
        throw new NoSuchOrderNoteException(sb.toString());
    }

    public CommerceOrderNote fetchByCommerceOrderId_First(long commerceOrderId, OrderByComparator<CommerceOrderNote> orderByComparator) {
        List<CommerceOrderNote> list = this.findByCommerceOrderId(commerceOrderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderNote findByCommerceOrderId_Last(long commerceOrderId, OrderByComparator<CommerceOrderNote> orderByComparator) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.fetchByCommerceOrderId_Last(commerceOrderId, orderByComparator);
        if (commerceOrderNote != null) {
            return commerceOrderNote;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append("}");
        throw new NoSuchOrderNoteException(sb.toString());
    }

    public CommerceOrderNote fetchByCommerceOrderId_Last(long commerceOrderId, OrderByComparator<CommerceOrderNote> orderByComparator) {
        int count = this.countByCommerceOrderId(commerceOrderId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderNote> list = this.findByCommerceOrderId(commerceOrderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderNote[] findByCommerceOrderId_PrevAndNext(long commerceOrderNoteId, long commerceOrderId, OrderByComparator<CommerceOrderNote> orderByComparator) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.findByPrimaryKey(commerceOrderNoteId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderNote[] array = new CommerceOrderNoteImpl[]{this.getByCommerceOrderId_PrevAndNext(session, commerceOrderNote, commerceOrderId, orderByComparator, true), commerceOrderNote, this.getByCommerceOrderId_PrevAndNext(session, commerceOrderNote, commerceOrderId, orderByComparator, false)};
            CommerceOrderNote[] commerceOrderNoteArray = array;
            return commerceOrderNoteArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderNote getByCommerceOrderId_PrevAndNext(Session session, CommerceOrderNote commerceOrderNote, long commerceOrderId, OrderByComparator<CommerceOrderNote> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEORDERNOTE_WHERE);
        sb.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderNote.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceOrderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderNote)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderNote)list.get(1);
        }
        return null;
    }

    public void removeByCommerceOrderId(long commerceOrderId) {
        for (CommerceOrderNote commerceOrderNote : this.findByCommerceOrderId(commerceOrderId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderNote);
        }
    }

    public int countByCommerceOrderId(long commerceOrderId) {
        FinderPath finderPath = this._finderPathCountByCommerceOrderId;
        Object[] finderArgs = new Object[]{commerceOrderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEORDERNOTE_WHERE);
            sb.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderNote> findByC_R(long commerceOrderId, boolean restricted) {
        return this.findByC_R(commerceOrderId, restricted, -1, -1, null);
    }

    public List<CommerceOrderNote> findByC_R(long commerceOrderId, boolean restricted, int start, int end) {
        return this.findByC_R(commerceOrderId, restricted, start, end, null);
    }

    public List<CommerceOrderNote> findByC_R(long commerceOrderId, boolean restricted, int start, int end, OrderByComparator<CommerceOrderNote> orderByComparator) {
        return this.findByC_R(commerceOrderId, restricted, start, end, orderByComparator, true);
    }

    public List<CommerceOrderNote> findByC_R(long commerceOrderId, boolean restricted, int start, int end, OrderByComparator<CommerceOrderNote> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_R;
                finderArgs = new Object[]{commerceOrderId, restricted};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_R;
            finderArgs = new Object[]{commerceOrderId, restricted, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderNote commerceOrderNote : list) {
                if (commerceOrderId == commerceOrderNote.getCommerceOrderId() && restricted == commerceOrderNote.isRestricted()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERNOTE_WHERE);
            sb.append(_FINDER_COLUMN_C_R_COMMERCEORDERID_2);
            sb.append(_FINDER_COLUMN_C_R_RESTRICTED_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderNote.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                queryPos.add(restricted);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderNote findByC_R_First(long commerceOrderId, boolean restricted, OrderByComparator<CommerceOrderNote> orderByComparator) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.fetchByC_R_First(commerceOrderId, restricted, orderByComparator);
        if (commerceOrderNote != null) {
            return commerceOrderNote;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append(", restricted=");
        sb.append(restricted);
        sb.append("}");
        throw new NoSuchOrderNoteException(sb.toString());
    }

    public CommerceOrderNote fetchByC_R_First(long commerceOrderId, boolean restricted, OrderByComparator<CommerceOrderNote> orderByComparator) {
        List<CommerceOrderNote> list = this.findByC_R(commerceOrderId, restricted, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderNote findByC_R_Last(long commerceOrderId, boolean restricted, OrderByComparator<CommerceOrderNote> orderByComparator) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.fetchByC_R_Last(commerceOrderId, restricted, orderByComparator);
        if (commerceOrderNote != null) {
            return commerceOrderNote;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append(", restricted=");
        sb.append(restricted);
        sb.append("}");
        throw new NoSuchOrderNoteException(sb.toString());
    }

    public CommerceOrderNote fetchByC_R_Last(long commerceOrderId, boolean restricted, OrderByComparator<CommerceOrderNote> orderByComparator) {
        int count = this.countByC_R(commerceOrderId, restricted);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderNote> list = this.findByC_R(commerceOrderId, restricted, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderNote[] findByC_R_PrevAndNext(long commerceOrderNoteId, long commerceOrderId, boolean restricted, OrderByComparator<CommerceOrderNote> orderByComparator) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.findByPrimaryKey(commerceOrderNoteId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderNote[] array = new CommerceOrderNoteImpl[]{this.getByC_R_PrevAndNext(session, commerceOrderNote, commerceOrderId, restricted, orderByComparator, true), commerceOrderNote, this.getByC_R_PrevAndNext(session, commerceOrderNote, commerceOrderId, restricted, orderByComparator, false)};
            CommerceOrderNote[] commerceOrderNoteArray = array;
            return commerceOrderNoteArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderNote getByC_R_PrevAndNext(Session session, CommerceOrderNote commerceOrderNote, long commerceOrderId, boolean restricted, OrderByComparator<CommerceOrderNote> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEORDERNOTE_WHERE);
        sb.append(_FINDER_COLUMN_C_R_COMMERCEORDERID_2);
        sb.append(_FINDER_COLUMN_C_R_RESTRICTED_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderNote.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceOrderId);
        queryPos.add(restricted);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderNote)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderNote)list.get(1);
        }
        return null;
    }

    public void removeByC_R(long commerceOrderId, boolean restricted) {
        for (CommerceOrderNote commerceOrderNote : this.findByC_R(commerceOrderId, restricted, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderNote);
        }
    }

    public int countByC_R(long commerceOrderId, boolean restricted) {
        FinderPath finderPath = this._finderPathCountByC_R;
        Object[] finderArgs = new Object[]{commerceOrderId, restricted};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERNOTE_WHERE);
            sb.append(_FINDER_COLUMN_C_R_COMMERCEORDERID_2);
            sb.append(_FINDER_COLUMN_C_R_RESTRICTED_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                queryPos.add(restricted);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderNote findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceOrderNote == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOrderNoteException(sb.toString());
        }
        return commerceOrderNote;
    }

    public CommerceOrderNote fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public CommerceOrderNote fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        CommerceOrderNote commerceOrderNote;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceOrderNote && (companyId != (commerceOrderNote = (CommerceOrderNote)result).getCompanyId() || !Objects.equals(externalReferenceCode, commerceOrderNote.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERNOTE_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("CommerceOrderNotePersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceOrderNote commerceOrderNote2 = (CommerceOrderNote)list.get(0);
                    result = commerceOrderNote2;
                    this.cacheResult(commerceOrderNote2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByC_ERC, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceOrderNote)result;
    }

    public CommerceOrderNote removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.findByC_ERC(companyId, externalReferenceCode);
        return (CommerceOrderNote)this.remove((BaseModel)commerceOrderNote);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERNOTE_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderNotePersistenceImpl() {
        this.setModelClass(CommerceOrderNote.class);
    }

    public void cacheResult(CommerceOrderNote commerceOrderNote) {
        this.entityCache.putResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, (Serializable)Long.valueOf(commerceOrderNote.getPrimaryKey()), (Serializable)commerceOrderNote);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{commerceOrderNote.getCompanyId(), commerceOrderNote.getExternalReferenceCode()}, (Object)commerceOrderNote);
        commerceOrderNote.resetOriginalValues();
    }

    public void cacheResult(List<CommerceOrderNote> commerceOrderNotes) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && commerceOrderNotes.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CommerceOrderNote commerceOrderNote : commerceOrderNotes) {
            if (this.entityCache.getResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, (Serializable)Long.valueOf(commerceOrderNote.getPrimaryKey())) == null) {
                this.cacheResult(commerceOrderNote);
                continue;
            }
            commerceOrderNote.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceOrderNoteImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceOrderNote commerceOrderNote) {
        this.entityCache.removeResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, (Serializable)Long.valueOf(commerceOrderNote.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CommerceOrderNoteModelImpl)commerceOrderNote, true);
    }

    public void clearCache(List<CommerceOrderNote> commerceOrderNotes) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommerceOrderNote commerceOrderNote : commerceOrderNotes) {
            this.entityCache.removeResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, (Serializable)Long.valueOf(commerceOrderNote.getPrimaryKey()));
            this.clearUniqueFindersCache((CommerceOrderNoteModelImpl)commerceOrderNote, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceOrderNoteModelImpl commerceOrderNoteModelImpl) {
        Object[] args = new Object[]{commerceOrderNoteModelImpl.getCompanyId(), commerceOrderNoteModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)commerceOrderNoteModelImpl, false);
    }

    protected void clearUniqueFindersCache(CommerceOrderNoteModelImpl commerceOrderNoteModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{commerceOrderNoteModelImpl.getCompanyId(), commerceOrderNoteModelImpl.getExternalReferenceCode()};
            this.finderCache.removeResult(this._finderPathCountByC_ERC, args);
            this.finderCache.removeResult(this._finderPathFetchByC_ERC, args);
        }
        if ((commerceOrderNoteModelImpl.getColumnBitmask() & this._finderPathFetchByC_ERC.getColumnBitmask()) != 0L) {
            args = new Object[]{commerceOrderNoteModelImpl.getOriginalCompanyId(), commerceOrderNoteModelImpl.getOriginalExternalReferenceCode()};
            this.finderCache.removeResult(this._finderPathCountByC_ERC, args);
            this.finderCache.removeResult(this._finderPathFetchByC_ERC, args);
        }
    }

    public CommerceOrderNote create(long commerceOrderNoteId) {
        CommerceOrderNoteImpl commerceOrderNote = new CommerceOrderNoteImpl();
        commerceOrderNote.setNew(true);
        commerceOrderNote.setPrimaryKey(commerceOrderNoteId);
        commerceOrderNote.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceOrderNote;
    }

    public CommerceOrderNote remove(long commerceOrderNoteId) throws NoSuchOrderNoteException {
        return this.remove(Long.valueOf(commerceOrderNoteId));
    }

    public CommerceOrderNote remove(Serializable primaryKey) throws NoSuchOrderNoteException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderNote commerceOrderNote = (CommerceOrderNote)session.get(CommerceOrderNoteImpl.class, primaryKey);
            if (commerceOrderNote == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOrderNoteException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceOrderNote commerceOrderNote2 = (CommerceOrderNote)this.remove((BaseModel)commerceOrderNote);
            return commerceOrderNote2;
        }
        catch (NoSuchOrderNoteException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderNote removeImpl(CommerceOrderNote commerceOrderNote) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceOrderNote)) {
                commerceOrderNote = (CommerceOrderNote)session.get(CommerceOrderNoteImpl.class, commerceOrderNote.getPrimaryKeyObj());
            }
            if (commerceOrderNote != null) {
                session.delete((Object)commerceOrderNote);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceOrderNote != null) {
            this.clearCache(commerceOrderNote);
        }
        return commerceOrderNote;
    }

    public CommerceOrderNote updateImpl(CommerceOrderNote commerceOrderNote) {
        boolean isNew = commerceOrderNote.isNew();
        if (!(commerceOrderNote instanceof CommerceOrderNoteModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceOrderNote.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceOrderNote);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceOrderNote proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceOrderNote implementation " + commerceOrderNote.getClass());
        }
        CommerceOrderNoteModelImpl commerceOrderNoteModelImpl = (CommerceOrderNoteModelImpl)commerceOrderNote;
        if (Validator.isNull((String)commerceOrderNote.getExternalReferenceCode())) {
            commerceOrderNote.setExternalReferenceCode(String.valueOf(commerceOrderNote.getPrimaryKey()));
        } else {
            long userId;
            if (!Objects.equals(commerceOrderNoteModelImpl.getOriginalExternalReferenceCode(), commerceOrderNote.getExternalReferenceCode()) && (userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName())) > 0L) {
                long companyId = commerceOrderNote.getCompanyId();
                long groupId = commerceOrderNote.getGroupId();
                long classPK = 0L;
                if (!isNew) {
                    classPK = commerceOrderNote.getPrimaryKey();
                }
                try {
                    commerceOrderNote.setExternalReferenceCode(SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)CommerceOrderNote.class.getName(), (long)classPK, (String)"text/html", (String)"ALL", (String)commerceOrderNote.getExternalReferenceCode(), null));
                }
                catch (SanitizerException sanitizerException) {
                    throw new SystemException((Throwable)sanitizerException);
                }
            }
            CommerceOrderNote ercCommerceOrderNote = this.fetchByC_ERC(commerceOrderNote.getCompanyId(), commerceOrderNote.getExternalReferenceCode());
            if (isNew ? ercCommerceOrderNote != null : ercCommerceOrderNote != null && commerceOrderNote.getCommerceOrderNoteId() != ercCommerceOrderNote.getCommerceOrderNoteId()) {
                throw new DuplicateCommerceOrderNoteExternalReferenceCodeException("Duplicate commerce order note with external reference code " + commerceOrderNote.getExternalReferenceCode() + " and company " + commerceOrderNote.getCompanyId());
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceOrderNote.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceOrderNote.setCreateDate(date);
            } else {
                commerceOrderNote.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceOrderNoteModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceOrderNote.setModifiedDate(date);
            } else {
                commerceOrderNote.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceOrderNote);
                commerceOrderNote.setNew(false);
            } else {
                commerceOrderNote = (CommerceOrderNote)session.merge((Object)commerceOrderNote);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommerceOrderNoteModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commerceOrderNoteModelImpl.getCommerceOrderId()};
            this.finderCache.removeResult(this._finderPathCountByCommerceOrderId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderId, args);
            args = new Object[]{commerceOrderNoteModelImpl.getCommerceOrderId(), commerceOrderNoteModelImpl.isRestricted()};
            this.finderCache.removeResult(this._finderPathCountByC_R, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commerceOrderNoteModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCommerceOrderId.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceOrderNoteModelImpl.getOriginalCommerceOrderId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceOrderId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderId, args);
                args = new Object[]{commerceOrderNoteModelImpl.getCommerceOrderId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceOrderId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderId, args);
            }
            if ((commerceOrderNoteModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_R.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceOrderNoteModelImpl.getOriginalCommerceOrderId(), commerceOrderNoteModelImpl.getOriginalRestricted()};
                this.finderCache.removeResult(this._finderPathCountByC_R, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R, args);
                args = new Object[]{commerceOrderNoteModelImpl.getCommerceOrderId(), commerceOrderNoteModelImpl.isRestricted()};
                this.finderCache.removeResult(this._finderPathCountByC_R, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R, args);
            }
        }
        this.entityCache.putResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, (Serializable)Long.valueOf(commerceOrderNote.getPrimaryKey()), (Serializable)commerceOrderNote, false);
        this.clearUniqueFindersCache(commerceOrderNoteModelImpl, false);
        this.cacheUniqueFindersCache(commerceOrderNoteModelImpl);
        commerceOrderNote.resetOriginalValues();
        return commerceOrderNote;
    }

    public CommerceOrderNote findByPrimaryKey(Serializable primaryKey) throws NoSuchOrderNoteException {
        CommerceOrderNote commerceOrderNote = this.fetchByPrimaryKey(primaryKey);
        if (commerceOrderNote == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOrderNoteException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceOrderNote;
    }

    public CommerceOrderNote findByPrimaryKey(long commerceOrderNoteId) throws NoSuchOrderNoteException {
        return this.findByPrimaryKey(Long.valueOf(commerceOrderNoteId));
    }

    public CommerceOrderNote fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommerceOrderNote commerceOrderNote = (CommerceOrderNote)serializable;
        if (commerceOrderNote == null) {
            Session session = null;
            try {
                session = this.openSession();
                commerceOrderNote = (CommerceOrderNote)session.get(CommerceOrderNoteImpl.class, primaryKey);
                if (commerceOrderNote != null) {
                    this.cacheResult(commerceOrderNote);
                } else {
                    this.entityCache.putResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commerceOrderNote;
    }

    public CommerceOrderNote fetchByPrimaryKey(long commerceOrderNoteId) {
        return this.fetchByPrimaryKey(Long.valueOf(commerceOrderNoteId));
    }

    public Map<Serializable, CommerceOrderNote> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommerceOrderNote> map = new HashMap<Serializable, CommerceOrderNote>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommerceOrderNote commerceOrderNote = this.fetchByPrimaryKey(primaryKey);
            if (commerceOrderNote != null) {
                map.put(primaryKey, commerceOrderNote);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommerceOrderNote)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_COMMERCEORDERNOTE_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (CommerceOrderNote commerceOrderNote : query.list()) {
                map.put(commerceOrderNote.getPrimaryKeyObj(), commerceOrderNote);
                this.cacheResult(commerceOrderNote);
                uncachedPrimaryKeys.remove(commerceOrderNote.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommerceOrderNote> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceOrderNote> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceOrderNote> findAll(int start, int end, OrderByComparator<CommerceOrderNote> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceOrderNote> findAll(int start, int end, OrderByComparator<CommerceOrderNote> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCEORDERNOTE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEORDERNOTE;
                sql = sql.concat(" ORDER BY commerceOrderNote.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceOrderNote commerceOrderNote : this.findAll()) {
            this.remove((BaseModel)commerceOrderNote);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCEORDERNOTE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceOrderNoteModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, CommerceOrderNoteImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, CommerceOrderNoteImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCommerceOrderId = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, CommerceOrderNoteImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCommerceOrderId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCommerceOrderId = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, CommerceOrderNoteImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCommerceOrderId", new String[]{Long.class.getName()}, 17L);
        this._finderPathCountByCommerceOrderId = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCommerceOrderId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByC_R = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, CommerceOrderNoteImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_R", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_R = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, CommerceOrderNoteImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_R", new String[]{Long.class.getName(), Boolean.class.getName()}, 25L);
        this._finderPathCountByC_R = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R", new String[]{Long.class.getName(), Boolean.class.getName()});
        this._finderPathFetchByC_ERC = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, CommerceOrderNoteImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, 6L);
        this._finderPathCountByC_ERC = new FinderPath(CommerceOrderNoteModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderNoteModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()});
        CommerceOrderNoteUtil.setPersistence((CommerceOrderNotePersistence)this);
    }

    public void destroy() {
        CommerceOrderNoteUtil.setPersistence(null);
        this.entityCache.removeCache(CommerceOrderNoteImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

