/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.address.CommerceAddressFormatter;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceShipmentItemLocalService;
import com.liferay.commerce.service.CommerceShipmentLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceShipmentIndexer
extends BaseIndexer<CommerceShipment> {
    public static final String CLASS_NAME = CommerceShipment.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentIndexer.class);
    @Reference
    private CommerceAddressFormatter _commerceAddressFormatter;
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceShipmentItemLocalService _commerceShipmentItemLocalService;
    @Reference
    private CommerceShipmentLocalService _commerceShipmentLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceShipmentIndexer() {
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        int[] shipmentStatuses;
        long[] commerceAccountIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountIds"), null);
        if (commerceAccountIds != null) {
            BooleanFilter commerceAccountIdBooleanFilter = new BooleanFilter();
            for (long commerceAccountId : commerceAccountIds) {
                TermFilter termFilter = new TermFilter("commerceAccountId", String.valueOf(commerceAccountId));
                commerceAccountIdBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            }
            commerceAccountIdBooleanFilter.add((Filter)new MissingFilter("commerceAccountId"), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)commerceAccountIdBooleanFilter, BooleanClauseOccur.MUST);
        }
        if ((shipmentStatuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("shipmentStatuses"), null)) != null) {
            BooleanFilter shipmentStatusesBooleanFilter = new BooleanFilter();
            int[] nArray = shipmentStatuses;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long shipmentStatus = nArray[i];
                TermFilter termFilter = new TermFilter("status", String.valueOf(shipmentStatus));
                shipmentStatusesBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            }
            shipmentStatusesBooleanFilter.add((Filter)new MissingFilter("status"), BooleanClauseOccur.SHOULD);
            if (GetterUtil.getBoolean((Object)searchContext.getAttribute("negateShipmentStatuses"))) {
                contextBooleanFilter.add((Filter)shipmentStatusesBooleanFilter, BooleanClauseOccur.MUST_NOT);
            } else {
                contextBooleanFilter.add((Filter)shipmentStatusesBooleanFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        super.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "commerceAccountName", false);
        this.addSearchTerm(searchQuery, searchContext, "commerceChannelName", false);
        this.addSearchTerm(searchQuery, searchContext, "oneLineAddress", false);
        this.addSearchTerm(searchQuery, searchContext, "trackingNumber", false);
    }

    protected void doDelete(CommerceShipment commerceShipment) throws Exception {
        this.deleteDocument(commerceShipment.getCompanyId(), commerceShipment.getCommerceShipmentId());
    }

    protected Document doGetDocument(CommerceShipment commerceShipment) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing shipment " + commerceShipment));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceShipment);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceShipment.getGroupId());
        document.addNumberSortable("entryClassPK", Long.valueOf(commerceShipment.getCommerceShipmentId()));
        document.addKeyword("status", commerceShipment.getStatus());
        document.addKeyword("commerceAccountId", commerceShipment.getCommerceAccountId());
        document.addKeyword("commerceAccountName", commerceShipment.getCommerceAccountName());
        document.addKeyword("commerceChannelId", commerceChannel.getCommerceChannelId());
        document.addKeyword("commerceChannelName", commerceChannel.getName());
        document.addNumber("itemsCount", this._commerceShipmentItemLocalService.getCommerceShipmentItemsCount(commerceShipment.getCommerceShipmentId()));
        CommerceAddress commerceAddress = this._commerceAddressLocalService.fetchCommerceAddress(commerceShipment.getCommerceAddressId());
        if (commerceAddress != null) {
            document.addKeyword("oneLineAddress", this._commerceAddressFormatter.getOneLineAddress(commerceAddress));
        }
        document.addKeyword("trackingNumber", commerceShipment.getTrackingNumber());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceShipment + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(CommerceShipment commerceShipment) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceShipment.getCompanyId(), this.getDocument(commerceShipment), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceShipmentLocalService.getCommerceShipment(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceShipments(companyId);
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        Boolean useSearchResultPermissionFilter = (Boolean)searchContext.getAttribute("useSearchResultPermissionFilter");
        if (useSearchResultPermissionFilter != null) {
            return useSearchResultPermissionFilter;
        }
        return super.isUseSearchResultPermissionFilter(searchContext);
    }

    protected void reindexCommerceShipments(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceShipmentLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceShipment -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceShipment)});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce shipment " + commerceShipment.getCommerceShipmentId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

