/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.util;

import java.math.BigDecimal;

/**
 * @author Igor Beslic
 */
public class CommerceBigDecimalUtil {

	public static boolean gt(BigDecimal value1, BigDecimal value2) {
		if (value1.compareTo(value2) > 0) {
			return true;
		}

		return false;
	}

	public static boolean gte(BigDecimal value1, BigDecimal value2) {
		if (value1.compareTo(value2) >= 0) {
			return true;
		}

		return false;
	}

	public static boolean lt(BigDecimal value1, BigDecimal value2) {
		if (value1.compareTo(value2) < 0) {
			return true;
		}

		return false;
	}

	public static boolean lte(BigDecimal value1, BigDecimal value2) {
		if (value1.compareTo(value2) <= 0) {
			return true;
		}

		return false;
	}

}