/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.inventory;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CommerceInventoryChecker;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import org.osgi.service.component.annotations.Reference;

/**
 * @author Igor Beslic
 */
public abstract class BaseCommerceInventoryChecker<T>
	implements CommerceInventoryChecker<T> {

	protected boolean isAvailable(CPInstance cpInstance, int quantity) {
		if (cpInstance == null) {
			return false;
		}

		if (isBackOrderAllowed(cpInstance)) {
			return true;
		}

		if (commerceInventoryEngine.hasStockQuantity(
				cpInstance.getCompanyId(), cpInstance.getSku(), quantity)) {

			return true;
		}

		return false;
	}

	protected boolean isBackOrderAllowed(CPInstance cpInstance) {
		try {
			if (cpDefinitionInventoryEngine.isBackOrderAllowed(cpInstance)) {
				return true;
			}
		}
		catch (PortalException pe) {
			_log.error("Unable to check is back order allowed", pe);
		}

		return false;
	}

	@Reference
	protected CommerceInventoryEngine commerceInventoryEngine;

	@Reference
	protected CPDefinitionInventoryEngine cpDefinitionInventoryEngine;

	private static final Log _log = LogFactoryUtil.getLog(
		BaseCommerceInventoryChecker.class);

}