/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.price.BaseCommerceOrderPriceCalculation;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceImpl;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;

public class CommerceOrderPriceCalculationImpl
extends BaseCommerceOrderPriceCalculation {
    private final CommerceDiscountCalculation _commerceDiscountCalculation;
    private final CommerceTaxCalculation _commerceTaxCalculation;

    public CommerceOrderPriceCalculationImpl(CommerceChannelLocalService commerceChannelLocalService, CommerceDiscountCalculation commerceDiscountCalculation, CommerceMoneyFactory commerceMoneyFactory, CommerceTaxCalculation commerceTaxCalculation) {
        super(commerceChannelLocalService, commerceMoneyFactory);
        this._commerceDiscountCalculation = commerceDiscountCalculation;
        this._commerceTaxCalculation = commerceTaxCalculation;
    }

    public CommerceOrderPrice getCommerceOrderPrice(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceDiscountValue orderTotalCommerceDiscountValue;
        CommerceMoney discountAmount;
        CommerceDiscountValue orderSubtotalCommerceDiscountValue;
        CommerceDiscountValue orderShippingCommerceDiscountValue;
        BigDecimal subtotalWithTaxAmount;
        BigDecimal subtotalAmount;
        if (commerceOrder == null) {
            return this.getEmptyCommerceOrderPrice(commerceContext.getCommerceCurrency());
        }
        if (!commerceOrder.isOpen()) {
            return this.getCommerceOrderPriceFromOrder(commerceOrder);
        }
        BigDecimal shippingAmount = commerceOrder.getShippingAmount();
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        CommerceMoney shippingTaxAmount = this._commerceTaxCalculation.getShippingTaxValue(commerceOrder, commerceCurrency);
        BigDecimal shippingWithTaxAmount = shippingAmount.add(shippingTaxAmount.getPrice());
        CommerceMoney subtotalMoney = this.getSubtotal(commerceOrder, secure, commerceContext);
        BigDecimal totalAmount = subtotalAmount = subtotalMoney.getPrice();
        CommerceMoney taxValue = this.getTaxValue(commerceOrder, secure, commerceContext);
        BigDecimal totalWithTaxAmount = subtotalWithTaxAmount = subtotalAmount.add(taxValue.getPrice());
        BigDecimal shippingDiscounted = shippingAmount;
        BigDecimal shippingDiscountedWithTaxAmount = shippingWithTaxAmount;
        BigDecimal subtotalDiscounted = subtotalAmount;
        BigDecimal subtotalDiscountedWithTaxAmount = subtotalWithTaxAmount;
        BigDecimal totalDiscounted = totalAmount;
        BigDecimal totalDiscountedWithTaxAmount = totalWithTaxAmount;
        boolean discountsTargetNetPrice = true;
        CommerceChannel commerceChannel = this.commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel != null) {
            discountsTargetNetPrice = commerceChannel.isDiscountsTargetNetPrice();
        }
        if (discountsTargetNetPrice) {
            orderShippingCommerceDiscountValue = this._commerceDiscountCalculation.getOrderShippingCommerceDiscountValue(commerceOrder, shippingAmount, commerceContext);
            orderSubtotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderSubtotalCommerceDiscountValue(commerceOrder, subtotalAmount, commerceContext);
            if (orderSubtotalCommerceDiscountValue != null) {
                discountAmount = orderSubtotalCommerceDiscountValue.getDiscountAmount();
                totalAmount = totalAmount.subtract(discountAmount.getPrice());
                subtotalDiscounted = subtotalDiscounted.subtract(discountAmount.getPrice());
            }
            totalAmount = totalAmount.add(shippingAmount);
            if (orderShippingCommerceDiscountValue != null) {
                discountAmount = orderShippingCommerceDiscountValue.getDiscountAmount();
                totalAmount = totalAmount.subtract(discountAmount.getPrice());
                shippingDiscounted = shippingDiscounted.subtract(discountAmount.getPrice());
            }
            if ((orderTotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderTotalCommerceDiscountValue(commerceOrder, totalAmount, commerceContext)) != null) {
                discountAmount = orderTotalCommerceDiscountValue.getDiscountAmount();
                totalAmount = totalAmount.subtract(discountAmount.getPrice());
                totalDiscounted = totalDiscounted.subtract(discountAmount.getPrice());
            }
            subtotalDiscountedWithTaxAmount = subtotalDiscounted.add(taxValue.getPrice());
            shippingDiscountedWithTaxAmount = shippingDiscounted.add(shippingTaxAmount.getPrice());
            totalDiscountedWithTaxAmount = totalDiscounted.add(taxValue.getPrice());
            totalWithTaxAmount = totalAmount.add(taxValue.getPrice());
        } else {
            orderShippingCommerceDiscountValue = this._commerceDiscountCalculation.getOrderShippingCommerceDiscountValue(commerceOrder, shippingWithTaxAmount, commerceContext);
            orderSubtotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderSubtotalCommerceDiscountValue(commerceOrder, subtotalWithTaxAmount, commerceContext);
            if (orderSubtotalCommerceDiscountValue != null) {
                discountAmount = orderSubtotalCommerceDiscountValue.getDiscountAmount();
                totalWithTaxAmount = totalWithTaxAmount.subtract(discountAmount.getPrice());
                subtotalDiscountedWithTaxAmount = subtotalDiscountedWithTaxAmount.subtract(discountAmount.getPrice());
            }
            totalWithTaxAmount = totalWithTaxAmount.add(shippingWithTaxAmount);
            if (orderShippingCommerceDiscountValue != null) {
                discountAmount = orderShippingCommerceDiscountValue.getDiscountAmount();
                totalWithTaxAmount = totalWithTaxAmount.subtract(discountAmount.getPrice());
                shippingDiscountedWithTaxAmount = shippingDiscountedWithTaxAmount.subtract(discountAmount.getPrice());
            }
            if ((orderTotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderTotalCommerceDiscountValue(commerceOrder, totalWithTaxAmount, commerceContext)) != null) {
                discountAmount = orderTotalCommerceDiscountValue.getDiscountAmount();
                totalWithTaxAmount = totalWithTaxAmount.subtract(discountAmount.getPrice());
                totalDiscountedWithTaxAmount = totalDiscountedWithTaxAmount.subtract(discountAmount.getPrice());
            }
            subtotalDiscounted = subtotalDiscountedWithTaxAmount.subtract(taxValue.getPrice());
            shippingDiscounted = shippingDiscountedWithTaxAmount.subtract(shippingTaxAmount.getPrice());
            totalDiscounted = totalDiscountedWithTaxAmount.subtract(taxValue.getPrice());
            totalAmount = totalWithTaxAmount.subtract(taxValue.getPrice());
        }
        CommerceOrderPriceImpl commerceOrderPriceImpl = new CommerceOrderPriceImpl();
        this.setDiscountValues(discountsTargetNetPrice, shippingAmount, shippingDiscounted, orderShippingCommerceDiscountValue, subtotalAmount, subtotalDiscounted, orderSubtotalCommerceDiscountValue, totalAmount, totalDiscounted, orderTotalCommerceDiscountValue, commerceOrderPriceImpl, commerceOrder);
        commerceOrderPriceImpl.setShippingValue(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), shippingAmount));
        commerceOrderPriceImpl.setShippingValueWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), shippingWithTaxAmount));
        commerceOrderPriceImpl.setSubtotal(subtotalMoney);
        commerceOrderPriceImpl.setSubtotalWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), subtotalWithTaxAmount));
        commerceOrderPriceImpl.setTaxValue(taxValue);
        commerceOrderPriceImpl.setTotal(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), totalAmount.add(taxValue.getPrice())));
        commerceOrderPriceImpl.setTotalWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), totalWithTaxAmount));
        this.setDiscountValuesWithTaxAmount(discountsTargetNetPrice, shippingWithTaxAmount, shippingDiscountedWithTaxAmount, orderShippingCommerceDiscountValue, subtotalWithTaxAmount, subtotalDiscountedWithTaxAmount, orderSubtotalCommerceDiscountValue, totalWithTaxAmount, totalDiscountedWithTaxAmount, orderTotalCommerceDiscountValue, commerceOrderPriceImpl, commerceOrder);
        return commerceOrderPriceImpl;
    }

    public CommerceOrderPrice getCommerceOrderPrice(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceOrderPrice(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getSubtotal(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        BigDecimal subtotal = BigDecimal.ZERO;
        if (commerceOrder == null) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), subtotal);
        }
        if (!commerceOrder.isOpen()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getSubtotal());
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            subtotal = subtotal.add(commerceOrderItem.getFinalPrice());
        }
        return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), subtotal);
    }

    public CommerceMoney getSubtotal(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getSubtotal(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getTaxValue(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (commerceOrder == null) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
        }
        if (!commerceOrder.isOpen()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getTaxAmount());
        }
        return this._commerceTaxCalculation.getTaxAmount(commerceOrder, commerceContext.getCommerceCurrency());
    }

    public CommerceMoney getTaxValue(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getTaxValue(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getTotal(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (!commerceOrder.isOpen()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getTotal());
        }
        CommerceOrderPrice commerceOrderPrice = this.getCommerceOrderPrice(commerceOrder, commerceContext);
        return commerceOrderPrice.getTotal();
    }

    public CommerceMoney getTotal(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getTotal(commerceOrder, true, commerceContext);
    }
}

