/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.application.strategy.CommerceDiscountApplicationStrategy;
import com.liferay.commerce.internal.price.CommerceProductPriceCalculationImpl;
import com.liferay.commerce.internal.price.CommerceProductPriceCalculationV2Impl;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceCalculationFactory;
import com.liferay.commerce.price.list.discovery.CommercePriceListDiscovery;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.commerce.pricing.modifier.CommercePriceModifierHelper;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.commerce.pricing.configuration.CommercePricingConfiguration"}, immediate=true, service={CommerceProductPriceCalculationFactory.class})
public class CommerceProductPriceCalculationFactoryImpl
implements CommerceProductPriceCalculationFactory {
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private final Map<String, CommerceDiscountApplicationStrategy> _commerceDiscountApplicationStrategyMap = new ConcurrentHashMap<String, CommerceDiscountApplicationStrategy>();
    @Reference(target="(commerce.discount.calculation.key=v1.0)")
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference(target="(commerce.discount.calculation.key=v2.0)")
    private CommerceDiscountCalculation _commerceDiscountCalculationV2;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference(target="(commerce.price.list.discovery.key=hierarchy)")
    private CommercePriceListDiscovery _commercePriceListDiscoveryByHierarchy;
    private final Map<String, CommercePriceListDiscovery> _commercePriceListDiscoveryMap = new ConcurrentHashMap<String, CommercePriceListDiscovery>();
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommercePriceModifierHelper _commercePriceModifierHelper;
    private String _commercePricingCalculationKey;
    @Reference
    private CommerceTaxCalculation _commerceTaxCalculation;
    @Reference
    private CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        this._commercePricingCalculationKey = (String)properties.get("commercePricingCalculationKey");
    }

    public CommerceProductPriceCalculation getCommerceProductPriceCalculation() {
        if (Objects.equals(this._commercePricingCalculationKey, "v2.0")) {
            return new CommerceProductPriceCalculationV2Impl(this._commerceChannelLocalService, this._commerceCurrencyLocalService, this._commerceDiscountCalculationV2, this._commerceMoneyFactory, this._commercePriceEntryLocalService, this._commercePriceListLocalService, this._commercePriceModifierHelper, this._commerceTierPriceEntryLocalService, this._commerceTaxCalculation, this._configurationProvider, this._cpDefinitionOptionRelLocalService, this._cpInstanceLocalService, this._commerceDiscountApplicationStrategyMap, this._commercePriceListDiscoveryMap);
        }
        return new CommerceProductPriceCalculationImpl(this._commerceCatalogLocalService, this._commerceChannelLocalService, this._commerceCurrencyLocalService, this._commerceDiscountCalculation, this._commerceMoneyFactory, this._commercePriceEntryLocalService, this._commercePriceListDiscoveryByHierarchy, this._commercePriceListLocalService, this._commerceTierPriceEntryLocalService, this._commerceTaxCalculation, this._cpDefinitionOptionRelLocalService, this._cpInstanceLocalService);
    }

    public void unsetCommerceDiscountApplicationStrategy(CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy, Map<String, Object> properties) {
        String commerceDiscountApplicationStrategyKey = GetterUtil.getString((Object)properties.get("commerce.discount.application.strategy.key"));
        this._commerceDiscountApplicationStrategyMap.remove(commerceDiscountApplicationStrategyKey);
    }

    public void unsetCommercePriceListDiscovery(CommercePriceListDiscovery commercePriceListDiscovery, Map<String, Object> properties) {
        String commercePriceListDiscoveryKey = GetterUtil.getString((Object)properties.get("commerce.price.list.discovery.key"));
        this._commercePriceListDiscoveryMap.remove(commercePriceListDiscoveryKey);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCommerceDiscountApplicationStrategy(CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy, Map<String, Object> properties) {
        String commerceDiscountApplicationStrategyKey = GetterUtil.getString((Object)properties.get("commerce.discount.application.strategy.key"));
        this._commerceDiscountApplicationStrategyMap.put(commerceDiscountApplicationStrategyKey, commerceDiscountApplicationStrategy);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCommercePriceListDiscovery(CommercePriceListDiscovery commercePriceListDiscovery, Map<String, Object> properties) {
        String commercePriceListDiscoveryKey = GetterUtil.getString((Object)properties.get("commerce.price.list.discovery.key"));
        this._commercePriceListDiscoveryMap.put(commercePriceListDiscoveryKey, commercePriceListDiscovery);
    }
}

