/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.configuration.CommerceOrderFieldsConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.discount.exception.CommerceDiscountCouponCodeException;
import com.liferay.commerce.discount.exception.CommerceDiscountLimitationTimesException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountUsageEntryLocalService;
import com.liferay.commerce.exception.CommerceOrderAccountLimitException;
import com.liferay.commerce.exception.CommerceOrderBillingAddressException;
import com.liferay.commerce.exception.CommerceOrderDateException;
import com.liferay.commerce.exception.CommerceOrderPurchaseOrderNumberException;
import com.liferay.commerce.exception.CommerceOrderRequestedDeliveryDateException;
import com.liferay.commerce.exception.CommerceOrderShippingAddressException;
import com.liferay.commerce.exception.CommerceOrderShippingMethodException;
import com.liferay.commerce.exception.CommerceOrderStatusException;
import com.liferay.commerce.exception.CommercePaymentEngineException;
import com.liferay.commerce.exception.GuestCartMaxAllowedException;
import com.liferay.commerce.internal.order.comparator.CommerceOrderModifiedDateComparator;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.price.CommerceOrderPriceCalculationFactory;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.commerce.search.facet.NegatableMultiValueFacet;
import com.liferay.commerce.service.base.CommerceOrderLocalServiceBaseImpl;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CommerceOrderLocalServiceImpl
extends CommerceOrderLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderLocalServiceImpl.class);
    @ServiceReference(type=CommerceCurrencyLocalService.class)
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @ServiceReference(type=CommerceDiscountLocalService.class)
    private CommerceDiscountLocalService _commerceDiscountLocalService;
    @ServiceReference(type=CommerceDiscountUsageEntryLocalService.class)
    private CommerceDiscountUsageEntryLocalService _commerceDiscountUsageEntryLocalService;
    @ServiceReference(type=CommerceOrderConfiguration.class)
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @ServiceReference(type=CommerceOrderPriceCalculationFactory.class)
    private CommerceOrderPriceCalculationFactory _commerceOrderPriceCalculationFactory;
    @ServiceReference(type=CommerceShippingHelper.class)
    private CommerceShippingHelper _commerceShippingHelper;
    @ServiceReference(type=ConfigurationProvider.class)
    private ConfigurationProvider _configurationProvider;
    @ServiceReference(type=JsonHelper.class)
    private JsonHelper _jsonHelper;
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @ServiceReference(type=WorkflowTaskManager.class)
    private WorkflowTaskManager _workflowTaskManager;

    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        if (this.hasWorkflowDefinition(groupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, 0L, 0L, 0L, null, 0L, null, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1, 2, serviceContext);
    }

    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        if (this.hasWorkflowDefinition(groupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, 0L, 0L, null, 0L, null, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1, 2, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, BigDecimal subtotalWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal totalWithTaxAmount, int paymentStatus, int orderStatus, ServiceContext serviceContext) throws PortalException {
        CommerceCurrency commerceCurrency;
        User user = this.userLocalService.getUser(userId);
        this.validateAccountOrdersLimit(groupId, commerceAccountId);
        this.validateGuestOrders();
        if (commerceCurrencyId <= 0L && (commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(serviceContext.getCompanyId())) != null) {
            commerceCurrencyId = commerceCurrency.getCommerceCurrencyId();
        }
        long commerceOrderId = this.counterLocalService.increment();
        CommerceOrder commerceOrder = this.commerceOrderPersistence.create(commerceOrderId);
        commerceOrder.setGroupId(groupId);
        commerceOrder.setCompanyId(user.getCompanyId());
        commerceOrder.setUserId(userId);
        commerceOrder.setUserName(user.getFullName());
        commerceOrder.setCommerceAccountId(commerceAccountId);
        commerceOrder.setCommerceCurrencyId(commerceCurrencyId);
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder.setOrderStatus(orderStatus);
        commerceOrder.setManuallyAdjusted(false);
        commerceOrder.setStatus(2);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(serviceContext.getModifiedDate(null));
        commerceOrder.setExpandoBridgeAttributes(serviceContext);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return (CommerceOrder)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrder.getCompanyId(), (long)commerceOrder.getScopeGroupId(), (long)userId, (String)CommerceOrder.class.getName(), (long)commerceOrder.getCommerceOrderId(), (Object)commerceOrder, (ServiceContext)serviceContext, new HashMap());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, paymentStatus, orderStatus, serviceContext);
    }

    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        if (this.hasWorkflowDefinition(groupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, 0L, shippingAddressId, null, 0L, null, purchaseOrderNumber, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1, 2, serviceContext);
    }

    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        if (this.hasWorkflowDefinition(groupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, 0L, 0L, shippingAddressId, null, 0L, null, purchaseOrderNumber, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1, 2, serviceContext);
    }

    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        boolean hasDiscounts = false;
        if (this._commerceDiscountLocalService.getActiveCommerceDiscountsCount(commerceOrder.getCompanyId(), couponCode, true) == 0) {
            hasDiscounts = true;
        }
        if (hasDiscounts && Validator.isNotNull((String)couponCode)) {
            throw new CommerceDiscountCouponCodeException();
        }
        if (Validator.isNotNull((String)couponCode)) {
            CommerceDiscount commerceDiscount = this._commerceDiscountLocalService.getActiveCommerceDiscount(commerceOrder.getCompanyId(), couponCode, true);
            long commerceAccountId = 0L;
            CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
            if (commerceAccount != null) {
                commerceAccountId = commerceAccount.getCommerceAccountId();
            }
            if (!this._commerceDiscountUsageEntryLocalService.validateDiscountLimitationUsage(commerceAccountId, commerceDiscount.getCommerceDiscountId())) {
                throw new CommerceDiscountLimitationTimesException();
            }
        }
        commerceOrder.setCouponCode(couponCode);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return this.commerceOrderLocalService.recalculatePrice(commerceOrderId, commerceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceOrder deleteCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        this.commerceOrderItemLocalService.deleteCommerceOrderItems(commerceOrder.getCommerceOrderId());
        this.commerceOrderNoteLocalService.deleteCommerceOrderNotes(commerceOrder.getCommerceOrderId());
        this.commerceOrderPaymentLocalService.deleteCommerceOrderPayments(commerceOrder.getCommerceOrderId());
        this.commerceAddressLocalService.deleteCommerceAddresses(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId());
        this.commerceOrderPersistence.remove((BaseModel)commerceOrder);
        this.expandoRowLocalService.deleteRows(commerceOrder.getCommerceOrderId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId());
        return commerceOrder;
    }

    @Override
    public CommerceOrder deleteCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
    }

    public void deleteCommerceOrders(long groupId) throws PortalException {
        List commerceOrders = this.commerceOrderPersistence.findByGroupId(groupId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
        }
    }

    @Deprecated
    public void deleteCommerceOrders(long userId, Date date, int status) {
        this.commerceOrderPersistence.removeByU_LtC_O(userId, date, status);
    }

    public void deleteCommerceOrdersByAccountId(long commerceAccountId, Date date, int status) {
        this.commerceOrderPersistence.removeByC_LtC_O(date, commerceAccountId, status);
    }

    public CommerceOrder executeWorkflowTransition(long userId, long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        long companyId = commerceOrder.getCompanyId();
        WorkflowTask workflowTask = this._workflowTaskManager.getWorkflowTask(companyId, workflowTaskId);
        if (!workflowTask.isAssignedToSingleUser()) {
            workflowTask = this._workflowTaskManager.assignWorkflowTaskToUser(companyId, userId, workflowTask.getWorkflowTaskId(), userId, comment, null, null);
        }
        this._workflowTaskManager.completeWorkflowTask(companyId, userId, workflowTask.getWorkflowTaskId(), transitionName, comment, null);
        return commerceOrder;
    }

    public CommerceOrder fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceOrderPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    @Deprecated
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) {
        return this.commerceOrderPersistence.fetchByG_C_O_First(groupId, commerceAccountId, orderStatus, (OrderByComparator)new CommerceOrderModifiedDateComparator());
    }

    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) {
        return this.commerceOrderFinder.fetchByG_U_C_O_S_First(groupId, userId, commerceAccountId, orderStatus);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) {
        return this.commerceOrderFinder.findByG_O(groupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) {
        return this.commerceOrderFinder.findByG_O(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByG_C(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, commerceAccountIds, keywords, excludeOrderStatus, orderStatuses, start, end);
        BaseModelSearchResult baseModelSearchResult = this.commerceOrderLocalService.searchCommerceOrders(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, String commercePaymentMethodKey) {
        return this.commerceOrderPersistence.findByG_CP(groupId, commercePaymentMethodKey);
    }

    public List<CommerceOrder> getCommerceOrdersByBillingAddress(long billingAddressId) {
        return this.commerceOrderPersistence.findByBillingAddressId(billingAddressId);
    }

    public List<CommerceOrder> getCommerceOrdersByCommerceAccountId(long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByCommerceAccountId(commerceAccountId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrdersByShippingAddress(long shippingAddressId) {
        return this.commerceOrderPersistence.findByShippingAddressId(shippingAddressId);
    }

    public int getCommerceOrdersCount(long groupId) {
        return this.commerceOrderPersistence.countByGroupId(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long commerceAccountId) {
        return this.commerceOrderPersistence.countByG_C(groupId, commerceAccountId);
    }

    public long getCommerceOrdersCount(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, commerceAccountIds, keywords, excludeOrderStatus, orderStatuses, -1, -1);
        return this.commerceOrderLocalService.searchCommerceOrdersCount(searchContext);
    }

    public int getCommerceOrdersCountByCommerceAccountId(long commerceAccountId) {
        return this.commerceOrderPersistence.countByCommerceAccountId(commerceAccountId);
    }

    public List<CommerceOrder> getShippedCommerceOrdersByCommerceShipmentId(long commerceShipmentId, int start, int end) {
        return this.commerceOrderFinder.getShippedCommerceOrdersByCommerceShipmentId(commerceShipmentId, start, end);
    }

    @Deprecated
    public List<CommerceOrder> getUserCommerceOrders(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords, int start, int end) {
        try {
            Group group = this.groupLocalService.getGroup(groupId);
            return this.commerceOrderLocalService.getCommerceOrders(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false, start, end);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return Collections.emptyList();
        }
    }

    @Deprecated
    public int getUserCommerceOrdersCount(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords) {
        try {
            Group group = this.groupLocalService.getGroup(groupId);
            return (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return 0;
        }
    }

    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List guestCommerceOrderItems = this.commerceOrderItemPersistence.findByCommerceOrderId(guestCommerceOrderId);
        for (CommerceOrderItem guestCommerceOrderItem : guestCommerceOrderItems) {
            List userCommerceOrderItems = this.commerceOrderItemPersistence.findByC_I(userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId());
            if (!userCommerceOrderItems.isEmpty()) {
                boolean found = false;
                for (CommerceOrderItem userCommerceOrderItem : userCommerceOrderItems) {
                    if (!this._jsonHelper.equals(guestCommerceOrderItem.getJson(), userCommerceOrderItem.getJson())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            this.commerceOrderItemLocalService.addCommerceOrderItem(userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId(), guestCommerceOrderItem.getQuantity(), guestCommerceOrderItem.getShippedQuantity(), guestCommerceOrderItem.getJson(), commerceContext, serviceContext);
        }
        this.commerceOrderLocalService.deleteCommerceOrder(guestCommerceOrderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (commerceOrder.getOrderStatus() != 2) {
            return commerceOrder;
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            this.commerceOrderItemLocalService.updateCommerceOrderItemPrice(commerceOrderItem.getCommerceOrderItemId(), commerceContext);
        }
        CommerceOrderPriceCalculation commerceOrderPriceCalculation = this._commerceOrderPriceCalculationFactory.getCommerceOrderPriceCalculation();
        CommerceOrderPrice commerceOrderPrice = commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, false, commerceContext);
        CommerceMoney subtotal = commerceOrderPrice.getSubtotal();
        CommerceMoney shippingValue = commerceOrderPrice.getShippingValue();
        CommerceMoney taxValue = commerceOrderPrice.getTaxValue();
        CommerceMoney total = commerceOrderPrice.getTotal();
        CommerceMoney subtotalWithTaxAmount = commerceOrderPrice.getSubtotalWithTaxAmount();
        CommerceMoney shippingValueWithTaxAmount = commerceOrderPrice.getShippingValueWithTaxAmount();
        CommerceMoney totalWithTaxAmount = commerceOrderPrice.getTotalWithTaxAmount();
        commerceOrder.setSubtotal(subtotal.getPrice());
        commerceOrder.setShippingAmount(shippingValue.getPrice());
        commerceOrder.setTaxAmount(taxValue.getPrice());
        commerceOrder.setTotal(total.getPrice());
        if (subtotalWithTaxAmount != null) {
            commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount.getPrice());
        }
        if (shippingValueWithTaxAmount != null) {
            commerceOrder.setShippingWithTaxAmount(shippingValueWithTaxAmount.getPrice());
        }
        if (totalWithTaxAmount != null) {
            commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount.getPrice());
        }
        if (!commerceOrder.isManuallyAdjusted()) {
            this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValue(), false);
            this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValue(), false);
            this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValue(), false);
            this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValueWithTaxAmount(), true);
            this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValueWithTaxAmount(), true);
            this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValueWithTaxAmount(), true);
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder reorderCommerceOrder(long userId, long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceAddress billingAddress;
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        serviceContext.setUserId(userId);
        long billingAddressId = 0L;
        long shippingAddressId = 0L;
        CommerceAddress shippingAddress = billingAddress = this.getNewCommerceAddress(commerceOrder, commerceOrder.getBillingAddress(), serviceContext);
        if (commerceOrder.getBillingAddressId() != commerceOrder.getShippingAddressId()) {
            shippingAddress = this.getNewCommerceAddress(commerceOrder, commerceOrder.getShippingAddress(), serviceContext);
        }
        if (billingAddress != null) {
            billingAddressId = billingAddress.getCommerceAddressId();
        }
        if (shippingAddress != null) {
            shippingAddressId = shippingAddress.getCommerceAddressId();
        }
        CommerceOrder newCommerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, commerceOrder.getGroupId(), commerceOrder.getCommerceAccountId(), commerceOrder.getCommerceCurrencyId(), billingAddressId, shippingAddressId, commerceOrder.getCommercePaymentMethodKey(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), "", commerceOrder.getSubtotal(), commerceOrder.getShippingAmount(), commerceOrder.getTotal(), commerceOrder.getSubtotalWithTaxAmount(), commerceOrder.getShippingWithTaxAmount(), commerceOrder.getTotalWithTaxAmount(), 1, 2, serviceContext);
        List commerceOrderItems = this.commerceOrderItemLocalService.getCommerceOrderItems(commerceOrder.getCommerceOrderId(), -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.commerceOrderItemLocalService.addCommerceOrderItem(newCommerceOrder.getCommerceOrderId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getQuantity(), 0, commerceOrderItem.getJson(), commerceContext, serviceContext);
        }
        return newCommerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder resetCommerceOrderShipping(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(0L);
        commerceOrder.setShippingOptionName(null);
        commerceOrder.setShippingAmount(BigDecimal.ZERO);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public BaseModelSearchResult<CommerceOrder> searchCommerceOrders(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceOrder.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceOrder> commerceOrders = this.getCommerceOrders(hits);
            if (commerceOrders == null) continue;
            return new BaseModelSearchResult(commerceOrders, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public long searchCommerceOrdersCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceOrder.class.getName());
        return indexer.searchCount(searchContext);
    }

    public CommerceOrder updateAccount(long commerceOrderId, long userId, long commerceAccountId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        User user = this.userLocalService.getUser(userId);
        commerceOrder.setUserId(user.getUserId());
        commerceOrder.setUserName(user.getFullName());
        commerceOrder.setCommerceAccountId(commerceAccountId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setBillingAddressId(billingAddressId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this.updateAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, CommerceOrderModel::getBillingAddressId, CommerceOrderModel::setBillingAddressId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, BigDecimal subtotalWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal totalWithTaxAmount, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext) throws PortalException {
        if (subtotal == null) {
            subtotal = BigDecimal.ZERO;
        }
        if (shippingAmount == null) {
            shippingAmount = BigDecimal.ZERO;
        }
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        if (subtotalWithTaxAmount == null) {
            subtotalWithTaxAmount = BigDecimal.ZERO;
        }
        if (shippingWithTaxAmount == null) {
            shippingWithTaxAmount = BigDecimal.ZERO;
        }
        if (totalWithTaxAmount == null) {
            totalWithTaxAmount = BigDecimal.ZERO;
        }
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        if (commerceContext != null) {
            CommerceDiscountValue shippingDiscountValueWithTaxAmount;
            CommerceOrderPriceCalculation commerceOrderPriceCalculation = this._commerceOrderPriceCalculationFactory.getCommerceOrderPriceCalculation();
            CommerceOrderPrice commerceOrderPrice = commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, false, commerceContext);
            CommerceDiscountValue shippingDiscountValue = commerceOrderPrice.getShippingDiscountValue();
            if (shippingDiscountValue != null) {
                CommerceMoney shippingDiscountAmount = shippingDiscountValue.getDiscountAmount();
                shippingAmount = shippingAmount.subtract(shippingDiscountAmount.getPrice());
            }
            if ((shippingDiscountValueWithTaxAmount = commerceOrderPrice.getShippingDiscountValueWithTaxAmount()) != null) {
                CommerceMoney shippingDiscountWithTaxAmount = shippingDiscountValueWithTaxAmount.getDiscountAmount();
                shippingWithTaxAmount = shippingWithTaxAmount.subtract(shippingDiscountWithTaxAmount.getPrice());
            }
        }
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
        commerceOrder.setAdvanceStatus(advanceStatus);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        return this.commerceOrderLocalService.updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, null, commerceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext) throws PortalException {
        CommerceOrderPriceCalculation commerceOrderPriceCalculation;
        CommerceOrderPrice commerceOrderPrice;
        CommerceDiscountValue shippingDiscountValue;
        if (subtotal == null) {
            subtotal = BigDecimal.ZERO;
        }
        if (shippingAmount == null) {
            shippingAmount = BigDecimal.ZERO;
        }
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setSubtotal(subtotal);
        if (commerceContext != null && (shippingDiscountValue = (commerceOrderPrice = (commerceOrderPriceCalculation = this._commerceOrderPriceCalculationFactory.getCommerceOrderPriceCalculation()).getCommerceOrderPrice(commerceOrder, false, commerceContext)).getShippingDiscountValue()) != null) {
            CommerceMoney shippingDiscountAmount = shippingDiscountValue.getDiscountAmount();
            shippingAmount = shippingAmount.subtract(shippingDiscountAmount.getPrice());
        }
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setAdvanceStatus(advanceStatus);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderExternalReferenceCode(long commerceOrderId, String externalReferenceCode) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setLastPriceUpdateDate(new Date());
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setSubtotalDiscountAmount(subtotalDiscountAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
        commerceOrder.setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
        commerceOrder.setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
        commerceOrder.setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingDiscountAmount(shippingDiscountAmount);
        commerceOrder.setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
        commerceOrder.setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
        commerceOrder.setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
        commerceOrder.setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
        commerceOrder.setTaxAmount(taxAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setTotalDiscountAmount(totalDiscountAmount);
        commerceOrder.setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
        commerceOrder.setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
        commerceOrder.setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
        commerceOrder.setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal subtotalWithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal totalWithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setLastPriceUpdateDate(new Date());
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setSubtotalDiscountAmount(subtotalDiscountAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
        commerceOrder.setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
        commerceOrder.setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
        commerceOrder.setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingDiscountAmount(shippingDiscountAmount);
        commerceOrder.setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
        commerceOrder.setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
        commerceOrder.setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
        commerceOrder.setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
        commerceOrder.setTaxAmount(taxAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setTotalDiscountAmount(totalDiscountAmount);
        commerceOrder.setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
        commerceOrder.setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
        commerceOrder.setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
        commerceOrder.setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        commerceOrder.setSubtotalDiscountWithTaxAmount(subtotalDiscountWithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel1WithTaxAmount(subtotalDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel2WithTaxAmount(subtotalDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel3WithTaxAmount(subtotalDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel4WithTaxAmount(subtotalDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        commerceOrder.setShippingDiscountWithTaxAmount(shippingDiscountWithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel1WithTaxAmount(shippingDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel2WithTaxAmount(shippingDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel3WithTaxAmount(shippingDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel4WithTaxAmount(shippingDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
        commerceOrder.setTotalDiscountWithTaxAmount(totalDiscountWithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel1WithTaxAmount(totalDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel2WithTaxAmount(totalDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel3WithTaxAmount(totalDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel4WithTaxAmount(totalDiscountPercentageLevel4WithTaxAmount);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCustomFields(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setExpandoBridgeAttributes(serviceContext);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        Date requestedDeliveryDate = PortalUtil.getDate((int)requestedDeliveryDateMonth, (int)requestedDeliveryDateDay, (int)requestedDeliveryDateYear, (int)requestedDeliveryDateHour, (int)requestedDeliveryDateMinute, (TimeZone)user.getTimeZone(), CommerceOrderRequestedDeliveryDateException.class);
        if (requestedDeliveryDate.before(new Date())) {
            throw new CommerceOrderRequestedDeliveryDateException();
        }
        commerceOrder.setPrintedNote(printedNote);
        commerceOrder.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        Date orderDate = PortalUtil.getDate((int)orderDateMonth, (int)orderDateDay, (int)orderDateYear, (int)orderDateHour, (int)orderDateMinute, (TimeZone)user.getTimeZone(), CommerceOrderDateException.class);
        commerceOrder.setOrderDate(orderDate);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setOrderStatus(orderStatus);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePaymentStatus(long userId, long commerceOrderId, int paymentStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        int previousPaymentStatus = commerceOrder.getPaymentStatus();
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        this.sendPaymentStatusMessage(commerceOrder.getCommerceOrderId(), commerceOrder.getPaymentStatus(), previousPaymentStatus);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePaymentStatusAndTransactionId(long userId, long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        int previousPaymentStatus = commerceOrder.getPaymentStatus();
        commerceOrder.setTransactionId(transactionId);
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        this.sendPaymentStatusMessage(commerceOrder.getCommerceOrderId(), commerceOrder.getPaymentStatus(), previousPaymentStatus);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setPrintedNote(printedNote);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        this.validatePurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this.updateAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, CommerceOrderModel::getShippingAddressId, CommerceOrderModel::setShippingAddressId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingMethod(long commerceOrderId, long commerceShippingMethodId, String shippingOptionName, BigDecimal shippingAmount, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return this.commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateStatus(long userId, long commerceOrderId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (userId == 0L) {
            userId = serviceContext.getUserId();
        }
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setStatus(status);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(serviceContext.getModifiedDate(now));
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateTransactionId(long commerceOrderId, String transactionId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setTransactionId(transactionId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder updateUser(long commerceOrderId, long userId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        User user = this.userLocalService.getUser(userId);
        commerceOrder.setUserId(user.getUserId());
        commerceOrder.setUserName(user.getFullName());
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder upsertCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, BigDecimal subtotalWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal totalWithTaxAmount, int paymentStatus, int orderStatus, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceOrder commerceOrder = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commerceOrder = this.commerceOrderPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        if (commerceOrder != null) {
            this.commerceOrderLocalService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, subtotalWithTaxAmount, shippingWithTaxAmount, totalWithTaxAmount, advanceStatus, externalReferenceCode, commerceContext);
            this.commerceOrderLocalService.updatePaymentStatus(userId, commerceOrder.getCommerceOrderId(), paymentStatus);
            return this.commerceOrderLocalService.updateOrderStatus(commerceOrder.getCommerceOrderId(), paymentStatus);
        }
        commerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, subtotalWithTaxAmount, shippingWithTaxAmount, totalWithTaxAmount, paymentStatus, orderStatus, serviceContext);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder upsertCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceOrder commerceOrder = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commerceOrder = this.commerceOrderPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        if (commerceOrder != null) {
            this.commerceOrderLocalService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, externalReferenceCode, commerceContext);
            this.commerceOrderLocalService.updatePaymentStatus(userId, commerceOrder.getCommerceOrderId(), paymentStatus);
            return this.commerceOrderLocalService.updateOrderStatus(commerceOrder.getCommerceOrderId(), paymentStatus);
        }
        commerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, paymentStatus, orderStatus, serviceContext);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    protected SearchContext addFacetOrderStatus(boolean negated, int[] orderStatuses, SearchContext searchContext) {
        NegatableMultiValueFacet negatableMultiValueFacet = new NegatableMultiValueFacet(searchContext);
        negatableMultiValueFacet.setFieldName("orderStatus");
        searchContext.addFacet((Facet)negatableMultiValueFacet);
        negatableMultiValueFacet.setNegated(negated);
        searchContext.setAttribute(negatableMultiValueFacet.getFieldId(), (Serializable)((Object)StringUtil.merge((int[])orderStatuses)));
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long commerceChannelGroupId, long[] commerceAccountIds, String keywords, boolean negated, int[] orderStatuses, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        if (orderStatuses != null) {
            searchContext.setAttribute("negateOrderStatuses", (Serializable)Boolean.valueOf(negated));
            searchContext.setAttribute("orderStatuses", (Serializable)orderStatuses);
        }
        if (commerceAccountIds != null) {
            searchContext.setAttribute("commerceAccountIds", (Serializable)commerceAccountIds);
        }
        searchContext.setCompanyId(companyId);
        searchContext.setGroupIds(new long[]{commerceChannelGroupId});
        searchContext.setKeywords(keywords);
        searchContext.setStart(start);
        searchContext.setEnd(end);
        Sort sort = SortFactoryUtil.getSort(CommerceOrder.class, (int)6, (String)"createDate", (String)"DESC");
        searchContext.setSorts(new Sort[]{sort});
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected String getCommerceOrderPaymentContent(CommercePaymentEngineException cpee) {
        return StackTraceUtil.getStackTrace((Throwable)cpee);
    }

    protected List<CommerceOrder> getCommerceOrders(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrder> commerceOrders = new ArrayList<CommerceOrder>(documents.size());
        for (Document document : documents) {
            long commerceOrderId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrder commerceOrder = this.fetchCommerceOrder(commerceOrderId);
            if (commerceOrder == null) {
                commerceOrders = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceOrder.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceOrders == null) continue;
            commerceOrders.add(commerceOrder);
        }
        return commerceOrders;
    }

    protected CommerceAddress getNewCommerceAddress(CommerceOrder commerceOrder, CommerceAddress commerceAddress, ServiceContext serviceContext) throws PortalException {
        if (commerceAddress == null) {
            return commerceAddress;
        }
        List commerceAddresses = this.commerceAddressLocalService.getCommerceAddressesByCompanyId(serviceContext.getCompanyId(), CommerceAccount.class.getName(), commerceOrder.getCommerceAccountId());
        for (CommerceAddress newCommerceAddress : commerceAddresses) {
            if (!commerceAddress.isSameAddress(newCommerceAddress)) continue;
            return newCommerceAddress;
        }
        return this.commerceAddressLocalService.copyCommerceAddress(commerceAddress.getCommerceAddressId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId(), serviceContext);
    }

    protected boolean hasWorkflowDefinition(long groupId, long typePK) throws PortalException {
        Group group = this.groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return false;
        }
        return this.workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(group.getCompanyId(), group.getGroupId(), CommerceOrder.class.getName(), 0L, typePK);
    }

    protected void sendPaymentStatusMessage(final long commerceOrderId, final int paymentStatus, final int previousPaymentStatus) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("commerceOrderId", (Object)commerceOrderId);
                message.put("paymentStatus", (Object)paymentStatus);
                message.put("previousPaymentStatus", (Object)previousPaymentStatus);
                MessageBusUtil.sendMessage((String)"liferay/payment_status", (Message)message);
                return null;
            }
        });
    }

    protected CommerceOrder updateAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, Function<CommerceOrder, Long> commerceAddressIdGetter, BiConsumer<CommerceOrder, Long> commerceAddressIdSetter, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceAddress commerceAddress = null;
        long commerceAddressId = commerceAddressIdGetter.apply(commerceOrder);
        commerceAddress = commerceAddressId > 0L ? this.commerceAddressLocalService.updateCommerceAddress(commerceAddressId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, false, false, serviceContext) : this.commerceAddressLocalService.addCommerceAddress(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, false, false, serviceContext);
        commerceAddressIdSetter.accept(commerceOrder, commerceAddress.getCommerceAddressId());
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    protected void validateAccountOrdersLimit(long channelGroupId, long commerceAccountId) throws PortalException {
        Group group = this.groupLocalService.getGroup(channelGroupId);
        int pendingCommerceOrdersCount = (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), channelGroupId, new long[]{commerceAccountId}, "", new int[]{2}, false);
        CommerceOrderFieldsConfiguration commerceOrderFieldsConfiguration = (CommerceOrderFieldsConfiguration)this._configurationProvider.getConfiguration(CommerceOrderFieldsConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(channelGroupId, "com.liferay.commerce.order.fields"));
        if (commerceOrderFieldsConfiguration.accountCartMaxAllowed() > 0 && pendingCommerceOrdersCount >= commerceOrderFieldsConfiguration.accountCartMaxAllowed()) {
            throw new CommerceOrderAccountLimitException("The account carts limit was reached");
        }
    }

    protected void validateCheckout(CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.isDraft() || !commerceOrder.isOpen() && !commerceOrder.isSubscription()) {
            throw new CommerceOrderStatusException();
        }
        if (commerceOrder.isB2B() && commerceOrder.getBillingAddressId() <= 0L) {
            throw new CommerceOrderBillingAddressException();
        }
        CommerceShippingMethod commerceShippingMethod = null;
        long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
        if (commerceShippingMethodId > 0L) {
            commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
            if (!commerceShippingMethod.isActive()) {
                commerceShippingMethod = null;
            } else if (commerceOrder.getShippingAddressId() <= 0L) {
                throw new CommerceOrderShippingAddressException();
            }
        }
        if (commerceShippingMethod == null && this.commerceShippingMethodLocalService.getCommerceShippingMethodsCount(commerceOrder.getGroupId(), true) > 0 && this._commerceShippingHelper.isShippable(commerceOrder)) {
            throw new CommerceOrderShippingMethodException();
        }
    }

    protected void validateGuestOrders() throws PortalException {
        int count = this.commerceOrderPersistence.countByUserId(0L);
        if (count >= this._commerceOrderConfiguration.guestCartMaxAllowed()) {
            throw new GuestCartMaxAllowedException();
        }
    }

    protected void validatePurchaseOrderNumber(String purchaseOrderNumber) throws PortalException {
        if (Validator.isNull((String)purchaseOrderNumber)) {
            throw new CommerceOrderPurchaseOrderNumberException();
        }
    }

    private void _setCommerceOrderShippingDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean isWithTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel1 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel1 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel1 = percentages[3];
            }
        }
        if (isWithTaxAmount) {
            commerceOrder.setShippingDiscountWithTaxAmount(discountAmount);
            commerceOrder.setShippingDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setShippingDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setShippingDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setShippingDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
        } else {
            commerceOrder.setShippingDiscountAmount(discountAmount);
            commerceOrder.setShippingDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setShippingDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setShippingDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setShippingDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderSubtotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean isWithTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1 && percentages[0] != null) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2 && percentages[1] != null) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3 && percentages[2] != null) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4 && percentages[3] != null) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (isWithTaxAmount) {
            commerceOrder.setSubtotalDiscountWithTaxAmount(discountAmount);
            commerceOrder.setSubtotalDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setSubtotalDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setSubtotalDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setSubtotalDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
        } else {
            commerceOrder.setSubtotalDiscountAmount(discountAmount);
            commerceOrder.setSubtotalDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setSubtotalDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setSubtotalDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setSubtotalDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderTotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean isWithTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel1 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel1 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel1 = percentages[3];
            }
        }
        if (isWithTaxAmount) {
            commerceOrder.setTotalDiscountWithTaxAmount(discountAmount);
            commerceOrder.setTotalDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setTotalDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setTotalDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setTotalDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
        } else {
            commerceOrder.setTotalDiscountAmount(discountAmount);
            commerceOrder.setTotalDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setTotalDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setTotalDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setTotalDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }
}

