/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.base.CommerceShippingMethodServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceShippingMethodServiceImpl
extends CommerceShippingMethodServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceShippingMethodServiceImpl.class, (String)"_commerceChannelModelResourcePermission", CommerceChannel.class);
    @ServiceReference(type=CommerceChannelLocalService.class)
    private CommerceChannelLocalService _commerceChannelLocalService;

    public CommerceAddressRestriction addCommerceAddressRestriction(long userId, long groupId, long commerceShippingMethodId, long commerceCountryId) throws PortalException {
        this._checkCommerceChannelPermissionByGroupId(groupId);
        return this.commerceShippingMethodLocalService.addCommerceAddressRestriction(userId, groupId, commerceShippingMethodId, commerceCountryId);
    }

    @Deprecated
    public CommerceAddressRestriction addCommerceAddressRestriction(long commerceShippingMethodId, long commerceCountryId, ServiceContext serviceContext) throws PortalException {
        return this.commerceShippingMethodService.addCommerceAddressRestriction(serviceContext.getUserId(), serviceContext.getScopeGroupId(), commerceShippingMethodId, commerceCountryId);
    }

    public CommerceShippingMethod addCommerceShippingMethod(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, String engineKey, double priority, boolean active) throws PortalException {
        this._checkCommerceChannelPermissionByGroupId(groupId);
        return this.commerceShippingMethodLocalService.addCommerceShippingMethod(userId, groupId, nameMap, descriptionMap, imageFile, engineKey, priority, active);
    }

    public CommerceShippingMethod createCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceShippingMethodId);
        if (commerceShippingMethod != null) {
            this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        }
        return this.commerceShippingMethodLocalService.createCommerceShippingMethod(commerceShippingMethodId);
    }

    public void deleteCommerceAddressRestriction(long commerceAddressRestrictionId) throws PortalException {
        CommerceAddressRestriction commerceAddressRestriction = this.commerceAddressRestrictionLocalService.getCommerceAddressRestriction(commerceAddressRestrictionId);
        this._checkCommerceChannelPermissionByGroupId(commerceAddressRestriction.getGroupId());
        this.commerceShippingMethodLocalService.deleteCommerceAddressRestriction(commerceAddressRestrictionId);
    }

    public void deleteCommerceAddressRestrictions(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        this.commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(CommerceShippingMethod.class.getName(), commerceShippingMethodId);
    }

    public void deleteCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        this.commerceShippingMethodLocalService.deleteCommerceShippingMethod(commerceShippingMethod);
    }

    public CommerceShippingMethod fetchCommerceShippingMethod(long groupId, String engineKey) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.fetchCommerceShippingMethod(groupId, engineKey);
        if (commerceShippingMethod != null) {
            this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        }
        return commerceShippingMethod;
    }

    public List<CommerceAddressRestriction> getCommerceAddressRestrictions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        return this.commerceShippingMethodLocalService.getCommerceAddressRestrictions(commerceShippingMethodId, start, end, orderByComparator);
    }

    public int getCommerceAddressRestrictionsCount(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        return this.commerceShippingMethodLocalService.getCommerceAddressRestrictionsCount(commerceShippingMethodId);
    }

    public CommerceShippingMethod getCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        return commerceShippingMethod;
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId) throws PortalException {
        this._checkCommerceChannelPermissionByGroupId(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethods(groupId);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, boolean active) throws PortalException {
        this._checkCommerceChannelPermissionByGroupId(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethods(groupId, active);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, long commerceCountryId, boolean active) throws PortalException {
        this._checkCommerceChannelPermissionByGroupId(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethods(groupId, commerceCountryId, active);
    }

    public int getCommerceShippingMethodsCount(long groupId, boolean active) throws PortalException {
        this._checkCommerceChannelPermissionByGroupId(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethodsCount(groupId, active);
    }

    public CommerceShippingMethod setActive(long commerceShippingMethodId, boolean active) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceShippingMethodId);
        if (commerceShippingMethod != null) {
            this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        }
        return this.commerceShippingMethodLocalService.setActive(commerceShippingMethodId, active);
    }

    public CommerceShippingMethod updateCommerceShippingMethod(long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, double priority, boolean active) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannelPermissionByGroupId(commerceShippingMethod.getGroupId());
        return this.commerceShippingMethodLocalService.updateCommerceShippingMethod(commerceShippingMethod.getCommerceShippingMethodId(), nameMap, descriptionMap, imageFile, priority, active);
    }

    private void _checkCommerceChannelPermissionByGroupId(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

