/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.inventory;

import com.liferay.commerce.inventory.CommerceInventoryChecker;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.inventory.checker.target=CPDefinitionOptionValueRel"}, service={CommerceInventoryChecker.class})
public class CPDefinitionOptionValueRelCommerceInventoryCheckerImpl
implements CommerceInventoryChecker<CPDefinitionOptionValueRel> {
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;

    public List<CPDefinitionOptionValueRel> filterByAvailability(List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels) {
        ArrayList<CPDefinitionOptionValueRel> filtered = new ArrayList<CPDefinitionOptionValueRel>();
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            if (!this.isAvailable((BaseModel<CPDefinitionOptionValueRel>)cpDefinitionOptionValueRel)) continue;
            filtered.add(cpDefinitionOptionValueRel);
        }
        return filtered;
    }

    public boolean isAvailable(BaseModel<CPDefinitionOptionValueRel> baseModel) {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)baseModel;
        if (Validator.isNull((String)cpDefinitionOptionValueRel.getCPInstanceUuid())) {
            return false;
        }
        CPInstance cpInstance = cpDefinitionOptionValueRel.fetchCPInstance();
        if (cpInstance == null) {
            return false;
        }
        return this._commerceInventoryEngine.hasStockQuantity(cpInstance.getCompanyId(), cpInstance.getSku(), cpDefinitionOptionValueRel.getQuantity());
    }
}

