/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.security.permission.resource;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;

public class CommerceOrderModelResourcePermissionLogic
implements ModelResourcePermissionLogic<CommerceOrder> {
    private final GroupLocalService _groupLocalService;
    private final PortletResourcePermission _portletResourcePermission;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public CommerceOrderModelResourcePermissionLogic(GroupLocalService groupLocalService, PortletResourcePermission portletResourcePermission, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this._groupLocalService = groupLocalService;
        this._portletResourcePermission = portletResourcePermission;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }

    public Boolean contains(PermissionChecker permissionChecker, String name, CommerceOrder commerceOrder, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commerceOrder.getCompanyId()) || permissionChecker.isGroupAdmin(commerceOrder.getGroupId())) {
            return true;
        }
        if (actionId.equals("APPROVE_COMMERCE_ORDER")) {
            CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
            return this._hasAncestorPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS");
        }
        if (actionId.equals("CHECKOUT_COMMERCE_ORDER")) {
            return this._containsCheckoutPermission(permissionChecker, commerceOrder);
        }
        if (actionId.equals("MANAGE_COMMERCE_ORDER_NOTES")) {
            return this._containsManageNotes(permissionChecker, commerceOrder, false);
        }
        if (actionId.equals("MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES")) {
            return this._containsManageNotes(permissionChecker, commerceOrder, true);
        }
        if (actionId.equals("DELETE")) {
            return this._containsDeletePermission(permissionChecker, commerceOrder);
        }
        if (actionId.equals("UPDATE")) {
            return this._containsUpdatePermission(permissionChecker, commerceOrder);
        }
        if (actionId.equals("VIEW")) {
            return this._containsViewPermission(permissionChecker, commerceOrder);
        }
        return false;
    }

    private boolean _containsCheckoutPermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (!commerceOrder.isOpen() && commerceOrder.getOrderStatus() != 6) {
            return false;
        }
        User user = permissionChecker.getUser();
        if (user.isDefaultUser() && commerceOrder.isGuestOrder()) {
            return false;
        }
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        if (commerceOrder.isPending() && !this._hasPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS")) {
            return false;
        }
        if (commerceOrder.isApproved() && this._hasOwnerPermission(permissionChecker, commerceOrder)) {
            return true;
        }
        return this._portletResourcePermission.contains(permissionChecker, commerceAccount.getCommerceAccountGroup(), "CHECKOUT_OPEN_COMMERCE_ORDERS");
    }

    private boolean _containsDeletePermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.isOpen()) {
            if (commerceOrder.isDraft()) {
                return this._hasOwnerPermission(permissionChecker, commerceOrder);
            }
            if (this._hasOwnerPermission(permissionChecker, commerceOrder)) {
                return true;
            }
        }
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        return this._portletResourcePermission.contains(permissionChecker, commerceAccount.getCommerceAccountGroup(), "DELETE_COMMERCE_ORDERS");
    }

    private boolean _containsManageNotes(PermissionChecker permissionChecker, CommerceOrder commerceOrder, boolean restricted) throws PortalException {
        if (!restricted && this._hasOwnerPermission(permissionChecker, commerceOrder)) {
            return true;
        }
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        return this._hasAncestorPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "MANAGE_COMMERCE_ORDERS");
    }

    private boolean _containsUpdatePermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        User user = permissionChecker.getUser();
        if (user.isDefaultUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        if (commerceOrder.isOpen()) {
            if (this._hasOwnerPermission(permissionChecker, commerceOrder)) {
                return true;
            }
            if (commerceOrder.isDraft()) {
                return false;
            }
            if (this._hasAncestorPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "ADD_COMMERCE_ORDER")) {
                return true;
            }
            if (this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 0L)) {
                return this._hasPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS");
            }
        }
        return this._hasAncestorPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "MANAGE_COMMERCE_ORDERS");
    }

    private boolean _containsViewPermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (this._hasOwnerPermission(permissionChecker, commerceOrder)) {
            return true;
        }
        User user = permissionChecker.getUser();
        if (user.isDefaultUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        if (commerceOrder.isOpen()) {
            if (commerceOrder.isDraft()) {
                return false;
            }
            return this._hasPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS");
        }
        return this._hasAncestorPermission(permissionChecker, commerceAccount.getCommerceAccountGroupId(), "MANAGE_COMMERCE_ORDERS", "VIEW_COMMERCE_ORDERS");
    }

    private boolean _hasAncestorPermission(PermissionChecker permissionChecker, long groupId, String ... actionIds) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        List groups = ListUtil.copy((List)group.getAncestors());
        groups.add(group);
        for (Group curGroup : groups) {
            if (!this._hasPermission(permissionChecker, curGroup.getGroupId(), actionIds)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasOwnerPermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) {
        long userId = permissionChecker.getUserId();
        return userId == commerceOrder.getUserId();
    }

    private boolean _hasPermission(PermissionChecker permissionChecker, long groupId, String ... actionIds) {
        for (String actionId : actionIds) {
            if (!this._portletResourcePermission.contains(permissionChecker, groupId, actionId)) continue;
            return true;
        }
        return false;
    }
}

