/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.impl.CommerceOrderImpl;
import com.liferay.commerce.service.persistence.CommerceOrderFinder;
import com.liferay.commerce.service.persistence.impl.CommerceOrderFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Iterator;
import java.util.List;

public class CommerceOrderFinderImpl
extends CommerceOrderFinderBaseImpl
implements CommerceOrderFinder {
    public static final String COUNT_BY_G_U_C_O = CommerceOrderFinder.class.getName() + ".countByG_U_C_O";
    public static final String FIND_BY_G_O = CommerceOrderFinder.class.getName() + ".findByG_O";
    public static final String FIND_BY_G_U_C_O = CommerceOrderFinder.class.getName() + ".findByG_U_C_O";
    public static final String FIND_BY_G_U_C_O_S = CommerceOrderFinder.class.getName() + ".findByG_U_C_O_S";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByG_U_C_O(long userId, QueryDefinition<CommerceOrder> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_C_O);
            sql = StringUtil.replace((String)sql, (String)"[$USER_ID$]", (String)String.valueOf(userId));
            long commerceAccountId = (Long)queryDefinition.getAttribute("commerceAccountId");
            sql = commerceAccountId > 0L ? StringUtil.replace((String)sql, (String)"[$ACCOUNT_ID$]", (String)this._getAccountIdClause(commerceAccountId)) : StringUtil.replace((String)sql, (String)"[$ACCOUNT_ID$]", (String)"");
            Integer orderStatus = (Integer)queryDefinition.getAttribute("orderStatus");
            if (orderStatus != null) {
                boolean excludeOrderStatus = (Boolean)queryDefinition.getAttribute("excludeOrderStatus");
                sql = StringUtil.replace((String)sql, (String)"[$ORDER_STATUS$]", (String)this._getOrderStatusClause(orderStatus, excludeOrderStatus));
            } else {
                sql = StringUtil.replace((String)sql, (String)"[$ORDER_STATUS$]", (String)"");
            }
            Object[] names = new String[]{};
            String keywords = (String)((Object)queryDefinition.getAttribute("keywords"));
            if (Validator.isNotNull((String)keywords)) {
                keywords = StringUtil.quote((String)StringUtil.lowerCase((String)keywords), (String)"%");
                names = (String[])ArrayUtil.append((Object[])names, (Object)keywords);
                sql = this._customSQL.replaceKeywords(sql, "lower(CommerceAccount.name)", "LIKE", false, (String[])names);
                sql = this._customSQL.replaceAndOperator(sql, true);
            } else {
                sql = StringUtil.replace((String)sql, (String)"AND (LOWER(CommerceAccount.name) LIKE ? [$AND_OR_NULL_CHECK$])", (String)"");
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            long groupId = (Long)queryDefinition.getAttribute("groupId");
            qPos.add(groupId);
            if (Validator.isNotNull((String)keywords)) {
                qPos.add((String[])names, 2);
            }
            q.addScalar("COUNT_VALUE", Type.LONG);
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceOrder fetchByG_U_C_O_S_First(long groupId, long userId, long commerceAccountId, int orderStatus) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_O_S);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceOrder", CommerceOrderImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(commerceAccountId);
            qPos.add(orderStatus);
            qPos.add(userId);
            List commerceOrders = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)0, (int)1);
            if (!commerceOrders.isEmpty()) {
                CommerceOrder commerceOrder = (CommerceOrder)commerceOrders.get(0);
                return commerceOrder;
            }
            CommerceOrder commerceOrder = null;
            return commerceOrder;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceOrder> findByG_O(long groupId, int[] orderStatuses) {
        return this.doFindByG_O(groupId, orderStatuses, -1, -1);
    }

    public List<CommerceOrder> findByG_O(long groupId, int[] orderStatuses, int start, int end) {
        return this.doFindByG_O(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> findByG_U_C_O(long userId, QueryDefinition<CommerceOrder> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_O);
            sql = StringUtil.replace((String)sql, (String)"[$USER_ID$]", (String)String.valueOf(userId));
            long commerceAccountId = (Long)queryDefinition.getAttribute("commerceAccountId");
            sql = commerceAccountId > 0L ? StringUtil.replace((String)sql, (String)"[$ACCOUNT_ID$]", (String)this._getAccountIdClause(commerceAccountId)) : StringUtil.replace((String)sql, (String)"[$ACCOUNT_ID$]", (String)"");
            Integer orderStatus = (Integer)queryDefinition.getAttribute("orderStatus");
            if (orderStatus != null) {
                boolean excludeOrderStatus = (Boolean)queryDefinition.getAttribute("excludeOrderStatus");
                sql = StringUtil.replace((String)sql, (String)"[$ORDER_STATUS$]", (String)this._getOrderStatusClause(orderStatus, excludeOrderStatus));
            } else {
                sql = StringUtil.replace((String)sql, (String)"[$ORDER_STATUS$]", (String)"");
            }
            Object[] names = new String[]{};
            String keywords = (String)((Object)queryDefinition.getAttribute("keywords"));
            if (Validator.isNotNull((String)keywords)) {
                keywords = StringUtil.quote((String)StringUtil.lowerCase((String)keywords), (String)"%");
                names = (String[])ArrayUtil.append((Object[])names, (Object)keywords);
                sql = this._customSQL.replaceKeywords(sql, "lower(CommerceAccount.name)", "LIKE", true, (String[])names);
                sql = this._customSQL.replaceAndOperator(sql, true);
            } else {
                sql = StringUtil.replace((String)sql, (String)"AND (LOWER(CommerceAccount.name) LIKE ? [$AND_OR_NULL_CHECK$])", (String)"");
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceOrder", CommerceOrderImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            long groupId = (Long)queryDefinition.getAttribute("groupId");
            qPos.add(groupId);
            if (Validator.isNotNull((String)keywords)) {
                qPos.add((String[])names, 2);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<CommerceOrder> doFindByG_O(long groupId, int[] orderStatuses, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_O);
            sql = this.replaceOrderStatus(sql, orderStatuses);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceOrder", CommerceOrderImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceOrderStatus(String sql, int[] orderStatuses) {
        StringBundler sb = new StringBundler(orderStatuses.length);
        for (int i = 0; i < orderStatuses.length; ++i) {
            sb.append(orderStatuses[i]);
            if (i == orderStatuses.length - 1) continue;
            sb.append(", ");
        }
        return StringUtil.replace((String)sql, (String)"[$ORDER_STATUS$]", (String)sb.toString());
    }

    private String _getAccountIdClause(long commerceAccountId) {
        return "(CommerceAccount.commerceAccountId = " + commerceAccountId + " ) AND";
    }

    private String _getOrderStatusClause(int orderStatus, boolean exclude) {
        if (orderStatus < 0) {
            return "";
        }
        if (exclude) {
            return "(CommerceOrder.orderStatus != " + orderStatus + ") AND";
        }
        return "(CommerceOrder.orderStatus = " + orderStatus + ") AND";
    }
}

