/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.exception.CommerceOrderItemRequestedDeliveryDateException;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.exception.GuestCartItemMaxAllowedException;
import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceCalculationFactory;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.util.DDMFormValuesUtil;
import com.liferay.commerce.service.base.CommerceOrderItemLocalServiceBaseImpl;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public class CommerceOrderItemLocalServiceImpl
extends CommerceOrderItemLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};
    @ServiceReference(type=CommerceInventoryBookedQuantityLocalService.class)
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @ServiceReference(type=CommerceInventoryWarehouseItemLocalService.class)
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @ServiceReference(type=CommerceOrderConfiguration.class)
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @ServiceReference(type=CommerceOrderValidatorRegistry.class)
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @ServiceReference(type=CommerceProductPriceCalculationFactory.class)
    private CommerceProductPriceCalculationFactory _commerceProductPriceCalculationFactory;
    @ServiceReference(type=CommerceShippingHelper.class)
    private CommerceShippingHelper _commerceShippingHelper;
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CPDefinitionOptionRelLocalService.class)
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @ServiceReference(type=CPInstanceLocalService.class)
    private CPInstanceLocalService _cpInstanceLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        this.validate(serviceContext.getLocale(), commerceOrder, cpDefinition, cpInstance, quantity);
        this.updateWorkflow(commerceOrder, serviceContext);
        CommerceProductPriceCalculation commerceProductPriceCalculation = this._commerceProductPriceCalculationFactory.getCommerceProductPriceCalculation();
        CommerceProductPrice commerceProductPrice = commerceProductPriceCalculation.getCommerceProductPrice(cpInstanceId, quantity, false, commerceContext);
        CommerceMoney unitPriceMoney = commerceProductPrice.getUnitPrice();
        CommerceMoney finalPriceMoney = commerceProductPrice.getFinalPrice();
        CommerceMoney unitPromoPriceMoney = commerceProductPrice.getUnitPromoPrice();
        long commerceOrderItemId = this.counterLocalService.increment();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.create(commerceOrderItemId);
        commerceOrderItem.setGroupId(commerceOrder.getGroupId());
        commerceOrderItem.setCompanyId(user.getCompanyId());
        commerceOrderItem.setUserId(user.getUserId());
        commerceOrderItem.setUserName(user.getFullName());
        commerceOrderItem.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderItem.setCProductId(cpDefinition.getCProductId());
        commerceOrderItem.setCPInstanceId(cpInstanceId);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        commerceOrderItem.setJson("[]");
        commerceOrderItem.setUnitPrice(unitPriceMoney.getPrice());
        BigDecimal promoPrice = BigDecimal.ZERO;
        if (unitPromoPriceMoney != null) {
            promoPrice = unitPromoPriceMoney.getPrice();
        }
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setFinalPrice(finalPriceMoney.getPrice());
        commerceOrderItem.setNameMap(cpDefinition.getNameMap());
        commerceOrderItem.setSku(cpInstance.getSku());
        commerceOrderItem.setManuallyAdjusted(false);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue());
        boolean subscription = false;
        if (cpDefinition.isSubscriptionEnabled() || cpDefinition.isDeliverySubscriptionEnabled()) {
            subscription = true;
        }
        if (cpInstance.isOverrideSubscriptionInfo() && (cpInstance.isSubscriptionEnabled() || cpInstance.isDeliverySubscriptionEnabled())) {
            subscription = true;
        }
        commerceOrderItem.setSubscription(subscription);
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        this.commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, shippedQuantity, commerceContext, serviceContext);
    }

    public int countSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByC_S(commerceOrderId, true);
    }

    @Override
    @Deprecated
    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem) throws PortalException {
        this.commerceOrderItemPersistence.remove((BaseModel)commerceOrderItem);
        this.expandoRowLocalService.deleteRows(commerceOrderItem.getCommerceOrderItemId());
        return commerceOrderItem;
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem, CommerceContext commerceContext) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity;
        this.commerceOrderItemPersistence.remove((BaseModel)commerceOrderItem);
        this.expandoRowLocalService.deleteRows(commerceOrderItem.getCommerceOrderItemId());
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        if (this._commerceShippingHelper.isFreeShipping(commerceOrder)) {
            this.commerceOrderLocalService.updateShippingMethod(commerceOrder.getCommerceOrderId(), 0L, null, BigDecimal.ZERO, commerceContext);
        }
        this.commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
        if (commerceOrderItem.getBookedQuantityId() > 0L && (commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(commerceOrderItem.getBookedQuantityId())) != null) {
            this._commerceInventoryBookedQuantityLocalService.deleteCommerceInventoryBookedQuantity(commerceInventoryBookedQuantity);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        this.updateWorkflow(commerceOrder, serviceContext);
        return commerceOrderItem;
    }

    @Override
    public CommerceOrderItem deleteCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
    }

    public void deleteCommerceOrderItems(long commerceOrderId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public void deleteCommerceOrderItemsByCPInstanceId(long cpInstanceId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCPInstanceId(cpInstanceId);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public CommerceOrderItem fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceOrderItemPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceOrderItem fetchCommerceOrderItemByBookedQuantityId(long bookedQuantityId) {
        return this.commerceOrderItemPersistence.fetchByBookedQuantityId(bookedQuantityId);
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemFinder.findByAvailableQuantity(commerceOrderId);
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, commerceOrderItem.getSku());
        if (commerceInventoryWarehouseItem == null) {
            return 0;
        }
        return commerceInventoryWarehouseItem.getQuantity();
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end) {
        return this.commerceOrderItemPersistence.findByC_I(commerceOrderId, cpInstanceId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByC_I(commerceOrderId, cpInstanceId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long groupId, long commerceAccountId, int[] orderStatuses, int start, int end) {
        return this.commerceOrderItemFinder.findByG_A_O(groupId, commerceAccountId, orderStatuses, start, end);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) {
        return this.commerceOrderItemPersistence.countByC_I(commerceOrderId, cpInstanceId);
    }

    public int getCommerceOrderItemsCount(long groupId, long commerceAccountId, int[] orderStatuses) {
        return this.commerceOrderItemFinder.countByG_A_O(groupId, commerceAccountId, orderStatuses);
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) {
        return this.commerceOrderItemFinder.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.findByC_S(commerceOrderId, true);
    }

    public CommerceOrderItem incrementShippedQuantity(long commerceOrderItemId, int shippedQuantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        shippedQuantity = commerceOrderItem.getShippedQuantity() + shippedQuantity;
        if (shippedQuantity < 0) {
            shippedQuantity = 0;
        }
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String sku, String name, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, start, end, sort);
        searchContext.setAndSearch(andOperator);
        searchContext.setAttribute("sku", (Serializable)((Object)sku));
        searchContext.setAttribute("name", (Serializable)((Object)name));
        return this.searchCommerceOrderItems(searchContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, quantity, commerceOrderItem.getJson(), commerceContext, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceProductPriceCalculation commerceProductPriceCalculation = this._commerceProductPriceCalculationFactory.getCommerceProductPriceCalculation();
        CommerceProductPrice commerceProductPrice = commerceProductPriceCalculation.getCommerceProductPrice(commerceOrderItem.getCPInstanceId(), quantity, false, commerceContext);
        CommerceMoney unitPriceMoney = commerceProductPrice.getUnitPrice();
        CommerceMoney unitPromoPriceMoney = commerceProductPrice.getUnitPromoPrice();
        CommerceMoney finalPriceMoney = commerceProductPrice.getFinalPrice();
        this.validate(serviceContext.getLocale(), commerceOrderItem.getCommerceOrder(), commerceOrderItem.getCPDefinition(), commerceOrderItem.fetchCPInstance(), quantity);
        this.updateWorkflow(commerceOrderItem.getCommerceOrder(), serviceContext);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setUnitPrice(unitPriceMoney.getPrice());
        BigDecimal promoPrice = BigDecimal.ZERO;
        if (unitPromoPriceMoney != null) {
            promoPrice = unitPromoPriceMoney.getPrice();
        }
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setFinalPrice(finalPriceMoney.getPrice());
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue());
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        this.commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long bookedQuantityId) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setBookedQuantityId(bookedQuantityId);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        Date requestedDeliveryDate = PortalUtil.getDate((int)requestedDeliveryDateMonth, (int)requestedDeliveryDateDay, (int)requestedDeliveryDateYear, (int)requestedDeliveryDateHour, (int)requestedDeliveryDateMinute, (TimeZone)user.getTimeZone(), CommerceOrderItemRequestedDeliveryDateException.class);
        if (requestedDeliveryDate.before(new Date())) {
            throw new CommerceOrderItemRequestedDeliveryDateException();
        }
        commerceOrderItem.setDeliveryGroup(deliveryGroup);
        commerceOrderItem.setShippingAddressId(shippingAddressId);
        commerceOrderItem.setPrintedNote(printedNote);
        commerceOrderItem.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrice(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null || commerceOrderItem.isManuallyAdjusted()) {
            return commerceOrderItem;
        }
        CommerceProductPriceCalculation commerceProductPriceCalculation = this._commerceProductPriceCalculationFactory.getCommerceProductPriceCalculation();
        CommerceProductPrice commerceProductPrice = commerceProductPriceCalculation.getCommerceProductPrice(commerceOrderItem.getCPInstanceId(), commerceOrderItem.getQuantity(), false, commerceContext);
        CommerceMoney unitPriceMoney = commerceProductPrice.getUnitPrice();
        CommerceMoney unitPromoPriceMoney = commerceProductPrice.getUnitPromoPrice();
        CommerceMoney finalPriceMoney = commerceProductPrice.getFinalPrice();
        commerceOrderItem.setUnitPrice(unitPriceMoney.getPrice());
        BigDecimal promoPrice = BigDecimal.ZERO;
        if (unitPromoPriceMoney != null) {
            promoPrice = unitPromoPriceMoney.getPrice();
        }
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setFinalPrice(finalPriceMoney.getPrice());
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue());
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal unitPrice, BigDecimal promoPrice, BigDecimal discountAmount, BigDecimal finalPrice, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setUnitPrice(unitPrice);
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setDiscountAmount(discountAmount);
        commerceOrderItem.setFinalPrice(finalPrice);
        commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
        commerceOrderItem.setManuallyAdjusted(true);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setUnitPrice(unitPrice);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice, int quantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setUnitPrice(unitPrice);
        commerceOrderItem.setManuallyAdjusted(true);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem upsertCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(commerceOrderId, cpInstanceId, -1, -1);
        String cpInstanceOptionValueRelJSONString = this._getCPInstanceOptionValueRelsJSONString(cpInstanceId);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (!Objects.equals(cpInstanceOptionValueRelJSONString, commerceOrderItem.getJson()) && (!Objects.equals(cpInstanceOptionValueRelJSONString, "[]") || !Validator.isBlank((String)commerceOrderItem.getJson()))) continue;
            return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceOrderItem.getQuantity() + quantity, commerceOrderItem.getJson(), commerceContext, serviceContext);
        }
        return this.commerceOrderItemLocalService.addCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, 0, commerceContext, serviceContext);
    }

    @Deprecated
    public CommerceOrderItem upsertCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this.upsertCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, shippedQuantity, commerceContext, serviceContext);
    }

    protected SearchContext buildSearchContext(long commerceOrderId, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = new SearchContext();
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        searchContext.setAttribute("commerceOrderId", (Serializable)Long.valueOf(commerceOrderId));
        searchContext.setCompanyId(commerceOrder.getCompanyId());
        searchContext.setEnd(end);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected List<CommerceOrderItem> getCommerceOrderItems(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrderItem> commerceOrderItems = new ArrayList<CommerceOrderItem>(documents.size());
        for (Document document : documents) {
            long commerceOrderItemId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrderItem commerceOrderItem = this.fetchCommerceOrderItem(commerceOrderItemId);
            if (commerceOrderItem == null) {
                commerceOrderItems = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceOrderItem.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceOrderItems == null) continue;
            commerceOrderItems.add(commerceOrderItem);
        }
        return commerceOrderItems;
    }

    protected BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceOrderItem.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(hits);
            if (commerceOrderItems == null) continue;
            return new BaseModelSearchResult(commerceOrderItems, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void updateWorkflow(CommerceOrder commerceOrder, ServiceContext serviceContext) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 0L, true);
        if (workflowDefinitionLink != null && commerceOrder.isApproved()) {
            this.commerceOrderLocalService.updateStatus(serviceContext.getUserId(), commerceOrder.getCommerceOrderId(), 2, serviceContext, Collections.emptyMap());
        }
    }

    protected void validate(Locale locale, CommerceOrder commerceOrder, CPDefinition cpDefinition, CPInstance cpInstance, int quantity) throws PortalException {
        List commerceCartValidatorResults;
        int count;
        if (commerceOrder.getUserId() == 0L && (count = this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrder.getCommerceOrderId())) >= this._commerceOrderConfiguration.guestCartItemMaxAllowed()) {
            throw new GuestCartItemMaxAllowedException();
        }
        if (cpDefinition != null && cpInstance != null && cpDefinition.getCPDefinitionId() != cpInstance.getCPDefinitionId()) {
            throw new NoSuchCPInstanceException(StringBundler.concat((Object[])new Object[]{"CPInstance ", cpInstance.getCPInstanceId(), " belongs to a different CPDefinition than ", cpDefinition.getCPDefinitionId()}));
        }
        if (!ExportImportThreadLocal.isImportInProcess() && !(commerceCartValidatorResults = this._commerceOrderValidatorRegistry.validate(locale, commerceOrder, cpInstance, quantity)).isEmpty()) {
            throw new CommerceOrderValidatorException(commerceCartValidatorResults);
        }
    }

    private String _getCPInstanceOptionValueRelsJSONString(long cpInstanceId) throws PortalException {
        JSONArray jsonArray = DDMFormValuesUtil.toJSONArray((Map)this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstanceId));
        return jsonArray.toString();
    }

    private void _setCommerceOrderItemDiscountValue(CommerceOrderItem commerceOrderItem, CommerceDiscountValue commerceDiscountValue) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel1 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel1 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel1 = percentages[3];
            }
        }
        commerceOrderItem.setDiscountAmount(discountAmount);
        commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
    }
}

