/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v4_5_1;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommerceShippingMethodUpgradeProcess
extends BaseCommerceServiceUpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;

    public CommerceShippingMethodUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
    }

    @Override
    protected void doUpgrade() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery("select commerceShippingMethodId, groupId from CommerceShippingMethod");){
            PreparedStatement ps = null;
            while (rs.next()) {
                long commerceShippingMethodId = rs.getLong("commerceShippingMethodId");
                long groupId = rs.getLong("groupId");
                long channelGroupId = this._getCommerceChannelGroupIdBySiteGroupId(groupId);
                if (channelGroupId == 0L) continue;
                ps = this.connection.prepareStatement("update CommerceShippingMethod set groupId = ? where commerceShippingMethodId = ?");
                ps.setLong(1, channelGroupId);
                ps.setLong(2, commerceShippingMethodId);
                ps.executeQuery();
            }
        }
    }

    private long _getCommerceChannelGroupIdBySiteGroupId(long groupId) throws SQLException {
        long companyId = 0L;
        long commerceChannelId = 0L;
        String sql = "select * from CommerceChannel where siteGroupId = " + groupId;
        try (Statement s = this.connection.createStatement();){
            s.setMaxRows(1);
            try (ResultSet rs = s.executeQuery(sql);){
                if (rs.next()) {
                    companyId = rs.getLong("companyId");
                    commerceChannelId = rs.getLong("commerceChannelId");
                }
            }
        }
        long classNameId = this._classNameLocalService.getClassNameId(CommerceChannel.class.getName());
        Group group = this._groupLocalService.fetchGroup(companyId, classNameId, commerceChannelId);
        if (group != null) {
            return group.getGroupId();
        }
        return 0L;
    }
}

