/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v4_1_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.model.impl.CommerceAddressImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class CommerceAddressUpgradeProcess
extends BaseCommerceServiceUpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;

    public CommerceAddressUpgradeProcess(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    @Override
    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("CommerceAccount", "defaultBillingAddressId") || !this.hasColumn("CommerceAccount", "defaultShippingAddressId")) {
            throw new UpgradeException("Upgrade fails as CommerceAccount does not have both columns: 'defaultBillingAddressId' and'defaultShippingAddressId'");
        }
        this.addColumn(CommerceAddressImpl.class, "CommerceAddress", "type_", "INTEGER");
        PreparedStatement ps = null;
        if (this.hasColumn("CommerceAddress", "defaultBilling")) {
            ps = this.connection.prepareStatement("update CommerceAccount set defaultBillingAddressId = ? where commerceAccountId = ?");
            this.updateCommerceAccountAndSetType(ps, this.getCommerceAddressResultSet("defaultBilling"));
        }
        if (this.hasColumn("CommerceAddress", "defaultShipping")) {
            ps = this.connection.prepareStatement("update CommerceAccount set defaultShippingAddressId = ? where commerceAccountId = ?");
            this.updateCommerceAccountAndSetType(ps, this.getCommerceAddressResultSet("defaultShipping"));
        }
    }

    protected ResultSet getCommerceAddressResultSet(String type) throws Exception {
        long commerceAccountClassNameId = this._classNameLocalService.getClassNameId(CommerceAccount.class);
        PreparedStatement ps = null;
        ps = type.equals("defaultBilling") ? this.connection.prepareStatement("select commerceAddressId, classPK, defaultBilling, defaultShipping from CommerceAddress where classNameId =? and defaultBilling = 1") : this.connection.prepareStatement("select commerceAddressId, classPK, defaultBilling, defaultShipping from CommerceAddress where classNameId =? and defaultShipping = 1");
        ps.setLong(1, commerceAccountClassNameId);
        return ps.executeQuery();
    }

    protected void setType(boolean defaultBilling, boolean defaultShipping, long commerceAddressId) throws Exception {
        PreparedStatement ps = this.connection.prepareStatement("update CommerceAddress set type_ = ? where commerceAddressId = ?");
        int type = 3;
        if (defaultBilling && !defaultShipping) {
            type = 1;
        } else if (!defaultBilling && defaultShipping) {
            type = 3;
        }
        ps.setInt(1, type);
        ps.setLong(2, commerceAddressId);
        ps.addBatch();
    }

    protected void updateCommerceAccountAndSetType(PreparedStatement ps, ResultSet rs) throws Exception {
        while (rs.next()) {
            long commerceAddressId = rs.getLong("commerceAddressId");
            ps.setLong(1, commerceAddressId);
            ps.setLong(2, rs.getLong("classPK"));
            this.setType(rs.getBoolean("defaultBilling"), rs.getBoolean("defaultShipping"), commerceAddressId);
            ps.addBatch();
        }
    }
}

