/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentInactiveWarehouseException;
import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.base.CommerceShipmentItemLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.HashMap;
import java.util.List;

public class CommerceShipmentItemLocalServiceImpl
extends CommerceShipmentItemLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentItemLocalServiceImpl.class);
    @ServiceReference(type=CommerceInventoryBookedQuantityLocalService.class)
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @ServiceReference(type=CommerceInventoryEngine.class)
    private CommerceInventoryEngine _commerceInventoryEngine;
    @ServiceReference(type=CommerceInventoryWarehouseItemLocalService.class)
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @ServiceReference(type=CommerceInventoryWarehouseLocalService.class)
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem addCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, int quantity, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this.validate(commerceOrderItem, this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId), commerceInventoryWarehouseId, quantity, quantity);
        long commerceShipmentItemId = this.counterLocalService.increment();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.create(commerceShipmentItemId);
        commerceShipmentItem.setGroupId(groupId);
        commerceShipmentItem.setCompanyId(user.getCompanyId());
        commerceShipmentItem.setUserId(user.getUserId());
        commerceShipmentItem.setUserName(user.getFullName());
        commerceShipmentItem.setCommerceShipmentId(commerceShipmentId);
        commerceShipmentItem.setCommerceOrderItemId(commerceOrderItemId);
        commerceShipmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), commerceShipmentItem.getQuantity());
        this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), quantity);
        return commerceShipmentItem;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipmentItem deleteCommerceShipmentItem(CommerceShipmentItem commerceShipmentItem, boolean restoreStockQuantity) throws PortalException {
        this.commerceShipmentItemPersistence.remove((BaseModel)commerceShipmentItem);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        if (!restoreStockQuantity) {
            if (commerceOrderItem != null) {
                this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId(), 0L);
            }
            return commerceShipmentItem;
        }
        int shippedQuantity = Math.negateExact(commerceShipmentItem.getQuantity());
        try {
            commerceOrderItem = this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), shippedQuantity);
            if (commerceShipmentItem.getCommerceInventoryWarehouseId() > 0L && commerceShipmentItem.getQuantity() > 0) {
                this._restoreStockQuantity(commerceOrderItem, commerceShipmentItem, commerceShipmentItem.getQuantity());
            }
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return commerceShipmentItem;
    }

    public void deleteCommerceShipmentItem(long commerceShipmentItemId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem, restoreStockQuantity);
    }

    public void deleteCommerceShipmentItems(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        List commerceShipmentItems = this.commerceShipmentItemPersistence.findByCommerceShipment(commerceShipmentId);
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem, restoreStockQuantity);
        }
    }

    public CommerceShipmentItem fetchCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) {
        return this.commerceShipmentItemPersistence.fetchByC_C_C(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId);
    }

    @Deprecated
    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceOrderItemId) {
        return this.commerceShipmentItemLocalService.getCommerceShipmentItemsByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByCommerceShipment(commerceShipmentId, start, end, orderByComparator);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, long commerceOrderItemId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByC_C(commerceShipmentId, commerceOrderItemId, start, end, orderByComparator);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItemsByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceShipmentItemPersistence.findByCommerceOrderItemId(commerceOrderItemId);
    }

    public int getCommerceShipmentItemsCount(long commerceShipmentId) {
        return this.commerceShipmentItemPersistence.countByCommerceShipment(commerceShipmentId);
    }

    public int getCommerceShipmentItemsCountByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceShipmentItemPersistence.countByCommerceOrderItemId(commerceOrderItemId);
    }

    public int getCommerceShipmentOrderItemsQuantity(long commerceShipmentId, long commerceOrderItemId) {
        return this.commerceShipmentItemFinder.getCommerceShipmentOrderItemsQuantity(commerceShipmentId, commerceOrderItemId);
    }

    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, int quantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this.updateCommerceShipmentItem(commerceShipmentItemId, commerceShipmentItem.getCommerceInventoryWarehouseId(), quantity);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, long commerceInventoryWarehouseId, int quantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        int originalQuantity = commerceShipmentItem.getQuantity();
        this.validate(commerceOrderItem, commerceShipmentItem.getCommerceShipment(), commerceInventoryWarehouseId, originalQuantity, quantity);
        commerceShipmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        int quantityDelta = quantity - originalQuantity;
        if (commerceOrderItem.getQuantity() == commerceOrderItem.getShippedQuantity()) {
            this._restoreStockQuantity(commerceOrderItem, commerceShipmentItem, Math.abs(quantityDelta));
        } else {
            this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), quantityDelta);
        }
        this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), quantityDelta);
        return commerceShipmentItem;
    }

    protected void validate(CommerceOrderItem commerceOrderItem, CommerceShipment commerceShipment, long commerceInventoryWarehouseId, int quantity, int newQuantity) throws PortalException {
        if (commerceShipment != null && commerceShipment.getStatus() != 0) {
            throw new CommerceShipmentStatusException();
        }
        if (commerceInventoryWarehouseId <= 0L) {
            return;
        }
        int availableQuantity = commerceOrderItem.getQuantity() - commerceOrderItem.getShippedQuantity();
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouse(commerceInventoryWarehouseId);
        if (!commerceInventoryWarehouse.isActive()) {
            throw new CommerceShipmentInactiveWarehouseException();
        }
        CommerceShipmentItem commerceShipmentItem = this.fetchCommerceShipmentItem(commerceShipment.getCommerceShipmentId(), commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouseId);
        if (commerceShipmentItem != null) {
            availableQuantity += commerceShipmentItem.getQuantity();
        }
        int commerceInventoryWarehouseQuantity = this.commerceOrderItemLocalService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouseId);
        if (newQuantity > quantity && newQuantity > availableQuantity || newQuantity > commerceInventoryWarehouseQuantity) {
            throw new CommerceShipmentItemQuantityException();
        }
    }

    private CommerceInventoryWarehouseItem _fetchCommerceInventoryWarehouseItem(long commerceShipmentItemId, String sku) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceShipmentItem.getCommerceInventoryWarehouseId(), sku);
    }

    private void _restoreStockQuantity(CommerceOrderItem commerceOrderItem, CommerceShipmentItem commerceShipmentItem, int quantity) throws PortalException {
        this._commerceInventoryEngine.increaseStockQuantity(commerceShipmentItem.getUserId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), commerceOrderItem.getSku(), quantity);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("OrderId ", String.valueOf(commerceOrderItem.getCommerceOrderId()));
        context.put("OrderItemId ", String.valueOf(commerceOrderItem.getCommerceOrderItemId()));
        context.put("Quantity ", String.valueOf(quantity));
        this._commerceInventoryBookedQuantityLocalService.resetCommerceBookedQuantity(commerceOrderItem.getBookedQuantityId(), commerceOrderItem.getUserId(), commerceOrderItem.getSku(), quantity, null, context);
    }

    private void _updateStockQuantity(CommerceOrderItem commerceOrderItem, long commerceShipmentItemId, int quantity) throws PortalException {
        if (commerceOrderItem == null) {
            return;
        }
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._fetchCommerceInventoryWarehouseItem(commerceShipmentItemId, commerceOrderItem.getSku());
        if (commerceInventoryWarehouseItem == null) {
            return;
        }
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("commerceOrderId", String.valueOf(commerceOrderItem.getCommerceOrderId()));
        context.put("commerceOrderItemId", String.valueOf(commerceOrderItem.getCommerceOrderItemId()));
        context.put("commerceShipmentId", String.valueOf(commerceShipmentItem.getCommerceShipmentId()));
        context.put("commerceShipmentItemId", String.valueOf(commerceShipmentItemId));
        this._commerceInventoryEngine.consumeQuantity(commerceShipmentItem.getUserId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), commerceOrderItem.getSku(), quantity, commerceOrderItem.getBookedQuantityId(), context);
    }
}

