/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.discount.application.strategy.CommerceDiscountApplicationStrategy;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.list.discovery.CommercePriceListDiscovery;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.pricing.exception.CommerceUndefinedBasePriceListException;
import com.liferay.commerce.pricing.modifier.CommercePriceModifierHelper;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.price.calculation.key=v2.0"}, service={CommerceProductPriceCalculation.class})
public class CommerceProductPriceCalculationV2Impl
implements CommerceProductPriceCalculation {
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final int _SCALE = 10;
    private static final Log _log = LogFactoryUtil.getLog(CommerceProductPriceCalculationV2Impl.class);
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private final Map<String, CommerceDiscountApplicationStrategy> _commerceDiscountApplicationStrategyMap = new ConcurrentHashMap<String, CommerceDiscountApplicationStrategy>();
    @Reference(target="(commerce.discount.calculation.key=v2.0)")
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    private final Map<String, CommercePriceListDiscovery> _commercePriceListDiscoveryMap = new ConcurrentHashMap<String, CommercePriceListDiscovery>();
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommercePriceModifierHelper _commercePriceModifierHelper;
    @Reference
    private CommerceTaxCalculation _commerceTaxCalculation;
    @Reference
    private CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference(target="(resource.name=com.liferay.commerce.product)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        long commercePriceListId = this._getCommercePriceListId(cpInstanceId, commerceContext);
        CommerceMoney unitPriceMoney = this._getUnitPrice(commercePriceListId, cpInstanceId, quantity, commerceContext);
        long commercePromoPriceListId = this._getCommercePromoPriceListId(cpInstanceId, commerceContext);
        CommerceMoney promoPriceMoney = this._getPromoPrice(commercePromoPriceListId, cpInstanceId, quantity, commerceContext);
        CommerceProductPriceImpl commerceProductPriceImpl = new CommerceProductPriceImpl();
        commerceProductPriceImpl.setQuantity(quantity);
        commerceProductPriceImpl.setUnitPrice(unitPriceMoney);
        commerceProductPriceImpl.setUnitPromoPrice(promoPriceMoney);
        BigDecimal finalPrice = unitPriceMoney.getPrice();
        BigDecimal promoPrice = promoPriceMoney.getPrice();
        if (promoPrice != null && promoPrice.compareTo(BigDecimal.ZERO) > 0 && promoPrice.compareTo(unitPriceMoney.getPrice()) <= 0) {
            finalPrice = promoPriceMoney.getPrice();
            commercePriceListId = commercePromoPriceListId;
        }
        CommerceDiscountValue commerceDiscountValue = this._getCommerceDiscountValue(cpInstanceId, commercePriceListId, quantity, finalPrice, commerceContext);
        finalPrice = finalPrice.multiply(BigDecimal.valueOf(quantity));
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountMoney = commerceDiscountValue.getDiscountAmount();
            finalPrice = finalPrice.subtract(discountAmountMoney.getPrice());
        }
        commerceProductPriceImpl.setCommerceDiscountValue(commerceDiscountValue);
        commerceProductPriceImpl.setFinalPrice(this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPrice));
        return commerceProductPriceImpl;
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceProductPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceProductPrice commerceProductPrice = this.getCommerceProductPrice(cpInstanceId, quantity, commerceContext);
        if (commerceProductPrice == null) {
            return null;
        }
        return commerceProductPrice.getFinalPrice();
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getFinalPrice(cpInstanceId, quantity, true, commerceContext);
    }

    public CommerceMoney getPromoPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        long commercePromoPriceListId = this._getCommercePromoPriceListId(cpInstanceId, commerceContext);
        return this._getPromoPrice(commercePromoPriceListId, cpInstanceId, quantity, commerceContext);
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal maxPrice = BigDecimal.ZERO;
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (maxPrice.compareTo(cpInstanceCommerceMoney.getPrice()) >= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            maxPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMaxPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal minPrice = BigDecimal.ZERO;
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, commerceContext);
            if (commerceMoney != null && minPrice.compareTo(cpInstanceCommerceMoney.getPrice()) <= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            minPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMinPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitPrice(long cpInstanceId, int quantity, CommerceCurrency commerceCurrency, boolean secure, CommerceContext commerceContext) throws PortalException {
        long commercePriceListId = this._getCommercePriceListId(cpInstanceId, commerceContext);
        return this._getUnitPrice(commercePriceListId, cpInstanceId, quantity, commerceContext);
    }

    public void unsetCommerceDiscountApplicationStrategy(CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy, Map<String, Object> properties) {
        String commerceDiscountApplicationStrategyKey = GetterUtil.getString((Object)properties.get("commerce.discount.application.strategy.key"));
        this._commerceDiscountApplicationStrategyMap.remove(commerceDiscountApplicationStrategyKey);
    }

    public void unsetCommercePriceListDiscovery(CommercePriceListDiscovery commercePriceListDiscovery, Map<String, Object> properties) {
        String commercePriceListDiscoveryKey = GetterUtil.getString((Object)properties.get("commerce.price.list.discovery.key"));
        this._commercePriceListDiscoveryMap.remove(commercePriceListDiscoveryKey);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCommerceDiscountApplicationStrategy(CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy, Map<String, Object> properties) {
        String commerceDiscountApplicationStrategyKey = GetterUtil.getString((Object)properties.get("commerce.discount.application.strategy.key"));
        this._commerceDiscountApplicationStrategyMap.put(commerceDiscountApplicationStrategyKey, commerceDiscountApplicationStrategy);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCommercePriceListDiscovery(CommercePriceListDiscovery commercePriceListDiscovery, Map<String, Object> properties) {
        String commercePriceListDiscoveryKey = GetterUtil.getString((Object)properties.get("commerce.price.list.discovery.key"));
        this._commercePriceListDiscoveryMap.put(commercePriceListDiscoveryKey, commercePriceListDiscovery);
    }

    private CommerceDiscountValue _calculateCommerceDiscountValue(BigDecimal[] values, int quantity, BigDecimal finalPrice, CommerceContext commerceContext) throws PortalException {
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy = this._getCommerceDiscountApplicationStrategy();
        BigDecimal discountedAmount = commerceDiscountApplicationStrategy.applyCommerceDiscounts(finalPrice, values);
        BigDecimal currentDiscountAmount = finalPrice.subtract(discountedAmount);
        currentDiscountAmount = currentDiscountAmount.setScale(10, roundingMode);
        CommerceMoney discountAmount = this._commerceMoneyFactory.create(commerceCurrency, currentDiscountAmount.multiply(new BigDecimal(quantity)));
        return new CommerceDiscountValue(0L, discountAmount, this._getDiscountPercentage(discountedAmount, finalPrice, roundingMode), values);
    }

    private long _getBasePriceListId(CPInstance cpInstance) throws PortalException {
        CommerceCatalog commerceCatalog = cpInstance.getCommerceCatalog();
        CommercePriceList basePriceList = this._commercePriceListLocalService.getCommerceCatalogBasePriceList(commerceCatalog.getGroupId());
        if (basePriceList != null) {
            return basePriceList.getCommercePriceListId();
        }
        throw new CommerceUndefinedBasePriceListException();
    }

    private CommerceDiscountApplicationStrategy _getCommerceDiscountApplicationStrategy() throws ConfigurationException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getSystemConfiguration(CommercePricingConfiguration.class);
        String commerceDiscountApplicationStrategy = commercePricingConfiguration.commerceDiscountApplicationStrategy();
        if (!this._commerceDiscountApplicationStrategyMap.containsKey(commerceDiscountApplicationStrategy)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No commerce discount application strategy specified for " + commerceDiscountApplicationStrategy));
            }
            return null;
        }
        return this._commerceDiscountApplicationStrategyMap.get(commerceDiscountApplicationStrategy);
    }

    private CommerceDiscountValue _getCommerceDiscountValue(long cpInstanceId, long commercePriceListId, int quantity, BigDecimal finalPrice, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), false);
        BigDecimal[] values = new BigDecimal[4];
        if (commercePriceEntry != null && !commercePriceEntry.isDiscountDiscovery()) {
            CommerceTierPriceEntry commerceTierPriceEntry;
            if (!commercePriceEntry.isHasTierPrice()) {
                values[0] = commercePriceEntry.getDiscountLevel1();
                values[1] = commercePriceEntry.getDiscountLevel2();
                values[2] = commercePriceEntry.getDiscountLevel3();
                values[3] = commercePriceEntry.getDiscountLevel4();
                return this._calculateCommerceDiscountValue(values, quantity, finalPrice, commerceContext);
            }
            if (commercePriceEntry.isHasTierPrice() && commercePriceEntry.isBulkPricing() && (commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.findClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity)) != null) {
                values[0] = commerceTierPriceEntry.getDiscountLevel1();
                values[1] = commerceTierPriceEntry.getDiscountLevel2();
                values[2] = commerceTierPriceEntry.getDiscountLevel3();
                values[3] = commerceTierPriceEntry.getDiscountLevel4();
                return this._calculateCommerceDiscountValue(values, quantity, finalPrice, commerceContext);
            }
        }
        return this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPrice, commerceContext);
    }

    private CommerceMoney _getCommerceMoney(long commercePriceListId, CommerceCurrency commerceCurrency, BigDecimal price) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CommerceCurrency priceListCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId());
        if (priceListCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(priceListCurrency.getRate(), RoundingMode.valueOf(priceListCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        if (price != null) {
            return this._commerceMoneyFactory.create(commerceCurrency, price);
        }
        return null;
    }

    private BigDecimal _getCommercePrice(long commercePriceListId, CommercePriceEntry commercePriceEntry, int quantity) throws PortalException {
        if (commercePriceEntry == null) {
            return null;
        }
        CPInstance cpInstance = commercePriceEntry.getCPInstance();
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceEntry.getCommercePriceListId());
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId());
        BigDecimal commercePrice = commercePriceEntry.getPrice();
        if (!commercePriceEntry.isHasTierPrice()) {
            if (commercePriceEntry.getCommercePriceListId() != commercePriceListId) {
                commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), commercePriceEntry.getPriceMoney(commerceCurrency.getCommerceCurrencyId()));
            }
            return commercePrice;
        }
        if (commercePriceEntry.isBulkPricing()) {
            commercePrice = commercePriceEntry.getPrice();
            CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.findClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity);
            if (commerceTierPriceEntry != null) {
                commercePrice = commerceTierPriceEntry.getPrice();
            }
            if (commercePriceEntry.getCommercePriceListId() != commercePriceListId) {
                commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), commerceTierPriceEntry.getPriceMoney(commerceCurrency.getCommerceCurrencyId()));
            }
            return commercePrice;
        }
        int totalTierCounter = 0;
        List commerceTierPriceEntries = this._commerceTierPriceEntryLocalService.findCommerceTierPriceEntries(commercePriceEntry.getCommercePriceEntryId(), quantity);
        if (commerceTierPriceEntries != null && !commerceTierPriceEntries.isEmpty()) {
            commercePrice = BigDecimal.ZERO;
            CommerceTierPriceEntry commerceTierPriceEntry0 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(0);
            int tierCounter = commerceTierPriceEntry0.getMinQuantity() - totalTierCounter - 1;
            BigDecimal currentPrice = commercePriceEntry.getPrice();
            currentPrice = currentPrice.multiply(BigDecimal.valueOf(tierCounter));
            commercePrice = commercePrice.add(currentPrice);
            totalTierCounter += tierCounter;
            for (int i = 0; i < commerceTierPriceEntries.size() - 1; ++i) {
                CommerceTierPriceEntry commerceTierPriceEntry1 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(i);
                CommerceTierPriceEntry commerceTierPriceEntry2 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(i + 1);
                tierCounter = commerceTierPriceEntry2.getMinQuantity() - totalTierCounter - 1;
                currentPrice = commerceTierPriceEntry1.getPrice();
                currentPrice = currentPrice.multiply(BigDecimal.valueOf(tierCounter));
                commercePrice = commercePrice.add(currentPrice);
                totalTierCounter += tierCounter;
            }
            totalTierCounter = quantity - totalTierCounter;
            CommerceTierPriceEntry commerceTierPriceEntry = (CommerceTierPriceEntry)commerceTierPriceEntries.get(commerceTierPriceEntries.size() - 1);
            currentPrice = commerceTierPriceEntry.getPrice();
            currentPrice = currentPrice.multiply(BigDecimal.valueOf(totalTierCounter));
            commercePrice = commercePrice.add(currentPrice);
            commercePrice = commercePrice.divide(BigDecimal.valueOf(quantity));
        }
        if (commercePriceEntry.getCommercePriceListId() != commercePriceListId) {
            commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), this._commerceMoneyFactory.create(commerceCurrency, commercePrice));
        }
        return commercePrice;
    }

    private BigDecimal _getCommercePrice(long cpInstanceId, long commercePriceListId, CommerceMoney unitPriceMoney) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        BigDecimal commercePrice = null;
        if (commercePriceList != null) {
            CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
            commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), unitPriceMoney);
        }
        return commercePrice;
    }

    private CommercePriceList _getCommercePriceList(long cpInstanceId, CommerceContext commerceContext, String commercePriceListType) throws PortalException {
        CommercePriceListDiscovery commercePriceListDiscovery;
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        long commerceAccountId = 0L;
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
        }
        if ((commercePriceListDiscovery = this._getCommercePriceListDiscovery(commercePriceListType)) == null) {
            return null;
        }
        return commercePriceListDiscovery.getCommercePriceList(cpInstance.getGroupId(), commerceAccountId, commerceContext.getCommerceChannelId(), cpInstance.getCPInstanceUuid(), commercePriceListType);
    }

    private CommercePriceListDiscovery _getCommercePriceListDiscovery(String commercePriceListType) throws PortalException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getSystemConfiguration(CommercePricingConfiguration.class);
        String discoveryMethod = "hierarchy";
        if (commercePriceListType.equals("price-list")) {
            discoveryMethod = commercePricingConfiguration.commercePriceListDiscovery();
        } else if (commercePriceListType.equals("promotion")) {
            discoveryMethod = commercePricingConfiguration.commercePromotionDiscovery();
        }
        if (!this._commercePriceListDiscoveryMap.containsKey(discoveryMethod)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No commerce price list discovery specified for " + discoveryMethod));
            }
            return null;
        }
        return this._commercePriceListDiscoveryMap.get(discoveryMethod);
    }

    private long _getCommercePriceListId(long cpInstanceId, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance;
        CommercePriceEntry commercePriceEntry;
        CommercePriceList commercePriceList = this._getCommercePriceList(cpInstanceId, commerceContext, "price-list");
        long commercePriceListId = 0L;
        if (commercePriceList != null) {
            commercePriceListId = commercePriceList.getCommercePriceListId();
        }
        if ((commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, (cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId)).getCPInstanceUuid(), true)) != null) {
            return commercePriceEntry.getCommercePriceListId();
        }
        boolean hasCommercePriceModifiers = this._commercePriceModifierHelper.hasCommercePriceModifiers(commercePriceListId, cpInstance.getCPDefinitionId());
        if (hasCommercePriceModifiers) {
            return commercePriceListId;
        }
        return this._getBasePriceListId(cpInstance);
    }

    private long _getCommercePromoPriceListId(long cpInstanceId, CommerceContext commerceContext) throws PortalException {
        CommercePriceList commercePriceList = this._getCommercePriceList(cpInstanceId, commerceContext, "promotion");
        if (commercePriceList != null) {
            return commercePriceList.getCommercePriceListId();
        }
        return 0L;
    }

    private BigDecimal _getDiscountPercentage(BigDecimal discountedAmount, BigDecimal amount, RoundingMode roundingMode) {
        double actualPrice = discountedAmount.doubleValue();
        double originalPrice = amount.doubleValue();
        double percentage = actualPrice / originalPrice;
        BigDecimal discountPercentage = new BigDecimal(percentage);
        discountPercentage = discountPercentage.multiply(_ONE_HUNDRED);
        MathContext mathContext = new MathContext(discountPercentage.precision(), roundingMode);
        return _ONE_HUNDRED.subtract(discountPercentage, mathContext);
    }

    private CommerceMoney _getPromoPrice(long commercePriceListId, long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        if (commercePriceListId > 0L) {
            CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
            CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), true);
            if (commercePriceEntry != null) {
                BigDecimal promoPrice = this._getCommercePrice(commercePriceListId, commercePriceEntry, quantity);
                return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), promoPrice);
            }
            CommerceMoney unitPrice = this.getUnitPrice(cpInstanceId, quantity, commerceContext.getCommerceCurrency(), false, commerceContext);
            BigDecimal promoPrice = this._getCommercePrice(cpInstanceId, commercePriceListId, unitPrice);
            return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), promoPrice);
        }
        return this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
    }

    private CommerceMoney _getUnitPrice(long commercePriceListId, long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), false);
        if (commercePriceEntry == null) {
            CommercePriceEntry commerceBasePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(this._getBasePriceListId(cpInstance), cpInstance.getCPInstanceUuid(), false);
            BigDecimal unitPrice = this._getCommercePrice(commercePriceList.getCommercePriceListId(), commerceBasePriceEntry, quantity);
            return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), unitPrice);
        }
        BigDecimal unitPrice = this._getCommercePrice(commercePriceList.getCommercePriceListId(), commercePriceEntry, quantity);
        return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), unitPrice);
    }
}

