/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.impl.CommerceOrderItemImpl;
import com.liferay.commerce.model.impl.CommerceOrderItemModelImpl;
import com.liferay.commerce.service.persistence.CommerceOrderItemPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CommerceOrderItemPersistenceImpl
extends BasePersistenceImpl<CommerceOrderItem>
implements CommerceOrderItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceOrderItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCommerceOrderId;
    private FinderPath _finderPathWithoutPaginationFindByCommerceOrderId;
    private FinderPath _finderPathCountByCommerceOrderId;
    private static final String _FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2 = "commerceOrderItem.commerceOrderId = ?";
    private FinderPath _finderPathWithPaginationFindByCProductId;
    private FinderPath _finderPathWithoutPaginationFindByCProductId;
    private FinderPath _finderPathCountByCProductId;
    private static final String _FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2 = "commerceOrderItem.CProductId = ?";
    private FinderPath _finderPathWithPaginationFindByCPInstanceId;
    private FinderPath _finderPathWithoutPaginationFindByCPInstanceId;
    private FinderPath _finderPathCountByCPInstanceId;
    private static final String _FINDER_COLUMN_CPINSTANCEID_CPINSTANCEID_2 = "commerceOrderItem.CPInstanceId = ?";
    private FinderPath _finderPathWithPaginationFindByC_I;
    private FinderPath _finderPathWithoutPaginationFindByC_I;
    private FinderPath _finderPathCountByC_I;
    private static final String _FINDER_COLUMN_C_I_COMMERCEORDERID_2 = "commerceOrderItem.commerceOrderId = ? AND ";
    private static final String _FINDER_COLUMN_C_I_CPINSTANCEID_2 = "commerceOrderItem.CPInstanceId = ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMMERCEORDERID_2 = "commerceOrderItem.commerceOrderId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SUBSCRIPTION_2 = "commerceOrderItem.subscription = ?";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "commerceOrderItem.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "commerceOrderItem.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(commerceOrderItem.externalReferenceCode IS NULL OR commerceOrderItem.externalReferenceCode = '')";
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEORDERITEM = "SELECT commerceOrderItem FROM CommerceOrderItem commerceOrderItem";
    private static final String _SQL_SELECT_COMMERCEORDERITEM_WHERE_PKS_IN = "SELECT commerceOrderItem FROM CommerceOrderItem commerceOrderItem WHERE commerceOrderItemId IN (";
    private static final String _SQL_SELECT_COMMERCEORDERITEM_WHERE = "SELECT commerceOrderItem FROM CommerceOrderItem commerceOrderItem WHERE ";
    private static final String _SQL_COUNT_COMMERCEORDERITEM = "SELECT COUNT(commerceOrderItem) FROM CommerceOrderItem commerceOrderItem";
    private static final String _SQL_COUNT_COMMERCEORDERITEM_WHERE = "SELECT COUNT(commerceOrderItem) FROM CommerceOrderItem commerceOrderItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceOrderItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceOrderItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceOrderItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderItemPersistenceImpl.class);

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId) {
        return this.findByCommerceOrderId(commerceOrderId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId, int start, int end) {
        return this.findByCommerceOrderId(commerceOrderId, start, end, null);
    }

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCommerceOrderId;
                finderArgs = new Object[]{commerceOrderId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCommerceOrderId;
            finderArgs = new Object[]{commerceOrderId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (commerceOrderId == commerceOrderItem.getCommerceOrderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceOrderId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByCommerceOrderId_First(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCommerceOrderId_First(commerceOrderId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceOrderId=");
        msg.append(commerceOrderId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByCommerceOrderId_First(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByCommerceOrderId(commerceOrderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByCommerceOrderId_Last(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCommerceOrderId_Last(commerceOrderId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceOrderId=");
        msg.append(commerceOrderId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByCommerceOrderId_Last(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByCommerceOrderId(commerceOrderId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByCommerceOrderId(commerceOrderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByCommerceOrderId_PrevAndNext(long commerceOrderItemId, long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByCommerceOrderId_PrevAndNext(session, commerceOrderItem, commerceOrderId, orderByComparator, true), commerceOrderItem, this.getByCommerceOrderId_PrevAndNext(session, commerceOrderItem, commerceOrderId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByCommerceOrderId_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        query.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(commerceOrderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByCommerceOrderId(long commerceOrderId) {
        for (CommerceOrderItem commerceOrderItem : this.findByCommerceOrderId(commerceOrderId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByCommerceOrderId(long commerceOrderId) {
        FinderPath finderPath = this._finderPathCountByCommerceOrderId;
        Object[] finderArgs = new Object[]{commerceOrderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceOrderId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId) {
        return this.findByCProductId(CProductId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId, int start, int end) {
        return this.findByCProductId(CProductId, start, end, null);
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByCProductId(CProductId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCProductId;
                finderArgs = new Object[]{CProductId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCProductId;
            finderArgs = new Object[]{CProductId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (CProductId == commerceOrderItem.getCProductId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(CProductId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByCProductId_First(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCProductId_First(CProductId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("CProductId=");
        msg.append(CProductId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByCProductId_First(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByCProductId(CProductId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByCProductId_Last(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCProductId_Last(CProductId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("CProductId=");
        msg.append(CProductId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByCProductId_Last(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByCProductId(CProductId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByCProductId(CProductId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByCProductId_PrevAndNext(long commerceOrderItemId, long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByCProductId_PrevAndNext(session, commerceOrderItem, CProductId, orderByComparator, true), commerceOrderItem, this.getByCProductId_PrevAndNext(session, commerceOrderItem, CProductId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByCProductId_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        query.append(_FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(CProductId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByCProductId(long CProductId) {
        for (CommerceOrderItem commerceOrderItem : this.findByCProductId(CProductId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByCProductId(long CProductId) {
        FinderPath finderPath = this._finderPathCountByCProductId;
        Object[] finderArgs = new Object[]{CProductId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(CProductId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId) {
        return this.findByCPInstanceId(CPInstanceId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId, int start, int end) {
        return this.findByCPInstanceId(CPInstanceId, start, end, null);
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByCPInstanceId(CPInstanceId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCPInstanceId;
                finderArgs = new Object[]{CPInstanceId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCPInstanceId;
            finderArgs = new Object[]{CPInstanceId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (CPInstanceId == commerceOrderItem.getCPInstanceId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            query.append("commerceOrderItem.CPInstanceId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(CPInstanceId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByCPInstanceId_First(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCPInstanceId_First(CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("CPInstanceId=");
        msg.append(CPInstanceId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByCPInstanceId_First(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByCPInstanceId(CPInstanceId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByCPInstanceId_Last(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCPInstanceId_Last(CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("CPInstanceId=");
        msg.append(CPInstanceId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByCPInstanceId_Last(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByCPInstanceId(CPInstanceId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByCPInstanceId(CPInstanceId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByCPInstanceId_PrevAndNext(long commerceOrderItemId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByCPInstanceId_PrevAndNext(session, commerceOrderItem, CPInstanceId, orderByComparator, true), commerceOrderItem, this.getByCPInstanceId_PrevAndNext(session, commerceOrderItem, CPInstanceId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByCPInstanceId_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        query.append("commerceOrderItem.CPInstanceId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(CPInstanceId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByCPInstanceId(long CPInstanceId) {
        for (CommerceOrderItem commerceOrderItem : this.findByCPInstanceId(CPInstanceId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByCPInstanceId(long CPInstanceId) {
        FinderPath finderPath = this._finderPathCountByCPInstanceId;
        Object[] finderArgs = new Object[]{CPInstanceId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            query.append("commerceOrderItem.CPInstanceId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(CPInstanceId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId) {
        return this.findByC_I(commerceOrderId, CPInstanceId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId, int start, int end) {
        return this.findByC_I(commerceOrderId, CPInstanceId, start, end, null);
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByC_I(commerceOrderId, CPInstanceId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_I;
                finderArgs = new Object[]{commerceOrderId, CPInstanceId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_I;
            finderArgs = new Object[]{commerceOrderId, CPInstanceId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (commerceOrderId == commerceOrderItem.getCommerceOrderId() && CPInstanceId == commerceOrderItem.getCPInstanceId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            query.append("commerceOrderItem.commerceOrderId = ? AND ");
            query.append("commerceOrderItem.CPInstanceId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceOrderId);
                qPos.add(CPInstanceId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByC_I_First(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_I_First(commerceOrderId, CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceOrderId=");
        msg.append(commerceOrderId);
        msg.append(", CPInstanceId=");
        msg.append(CPInstanceId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByC_I_First(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByC_I(commerceOrderId, CPInstanceId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByC_I_Last(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_I_Last(commerceOrderId, CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceOrderId=");
        msg.append(commerceOrderId);
        msg.append(", CPInstanceId=");
        msg.append(CPInstanceId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByC_I_Last(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByC_I(commerceOrderId, CPInstanceId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByC_I(commerceOrderId, CPInstanceId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByC_I_PrevAndNext(long commerceOrderItemId, long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByC_I_PrevAndNext(session, commerceOrderItem, commerceOrderId, CPInstanceId, orderByComparator, true), commerceOrderItem, this.getByC_I_PrevAndNext(session, commerceOrderItem, commerceOrderId, CPInstanceId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByC_I_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        query.append("commerceOrderItem.commerceOrderId = ? AND ");
        query.append("commerceOrderItem.CPInstanceId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(commerceOrderId);
        qPos.add(CPInstanceId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByC_I(long commerceOrderId, long CPInstanceId) {
        for (CommerceOrderItem commerceOrderItem : this.findByC_I(commerceOrderId, CPInstanceId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByC_I(long commerceOrderId, long CPInstanceId) {
        FinderPath finderPath = this._finderPathCountByC_I;
        Object[] finderArgs = new Object[]{commerceOrderId, CPInstanceId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            query.append("commerceOrderItem.commerceOrderId = ? AND ");
            query.append("commerceOrderItem.CPInstanceId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceOrderId);
                qPos.add(CPInstanceId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription) {
        return this.findByC_S(commerceOrderId, subscription, -1, -1, null);
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription, int start, int end) {
        return this.findByC_S(commerceOrderId, subscription, start, end, null);
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByC_S(commerceOrderId, subscription, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{commerceOrderId, subscription};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{commerceOrderId, subscription, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (commerceOrderId == commerceOrderItem.getCommerceOrderId() && subscription == commerceOrderItem.isSubscription()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            query.append("commerceOrderItem.commerceOrderId = ? AND ");
            query.append(_FINDER_COLUMN_C_S_SUBSCRIPTION_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceOrderId);
                qPos.add(subscription);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByC_S_First(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_S_First(commerceOrderId, subscription, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceOrderId=");
        msg.append(commerceOrderId);
        msg.append(", subscription=");
        msg.append(subscription);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByC_S_First(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByC_S(commerceOrderId, subscription, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByC_S_Last(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_S_Last(commerceOrderId, subscription, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceOrderId=");
        msg.append(commerceOrderId);
        msg.append(", subscription=");
        msg.append(subscription);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public CommerceOrderItem fetchByC_S_Last(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByC_S(commerceOrderId, subscription);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByC_S(commerceOrderId, subscription, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByC_S_PrevAndNext(long commerceOrderItemId, long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByC_S_PrevAndNext(session, commerceOrderItem, commerceOrderId, subscription, orderByComparator, true), commerceOrderItem, this.getByC_S_PrevAndNext(session, commerceOrderItem, commerceOrderId, subscription, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByC_S_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        query.append("commerceOrderItem.commerceOrderId = ? AND ");
        query.append(_FINDER_COLUMN_C_S_SUBSCRIPTION_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(commerceOrderId);
        qPos.add(subscription);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long commerceOrderId, boolean subscription) {
        for (CommerceOrderItem commerceOrderItem : this.findByC_S(commerceOrderId, subscription, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByC_S(long commerceOrderId, boolean subscription) {
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{commerceOrderId, subscription};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            query.append("commerceOrderItem.commerceOrderId = ? AND ");
            query.append(_FINDER_COLUMN_C_S_SUBSCRIPTION_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceOrderId);
                qPos.add(subscription);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderItem findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceOrderItem == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", externalReferenceCode=");
            msg.append(externalReferenceCode);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchOrderItemException(msg.toString());
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public CommerceOrderItem fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        CommerceOrderItem commerceOrderItem;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceOrderItem && (companyId != (commerceOrderItem = (CommerceOrderItem)result).getCompanyId() || !Objects.equals(externalReferenceCode, commerceOrderItem.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (bindExternalReferenceCode) {
                    qPos.add(externalReferenceCode);
                }
                if ((list = q.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("CommerceOrderItemPersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceOrderItem commerceOrderItem2 = (CommerceOrderItem)list.get(0);
                    result = commerceOrderItem2;
                    this.cacheResult(commerceOrderItem2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByC_ERC, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceOrderItem)result;
    }

    public CommerceOrderItem removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByC_ERC(companyId, externalReferenceCode);
        return (CommerceOrderItem)this.remove((BaseModel)commerceOrderItem);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (bindExternalReferenceCode) {
                    qPos.add(externalReferenceCode);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderItemPersistenceImpl() {
        this.setModelClass(CommerceOrderItem.class);
    }

    public void cacheResult(CommerceOrderItem commerceOrderItem) {
        this.entityCache.putResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, (Serializable)Long.valueOf(commerceOrderItem.getPrimaryKey()), (Serializable)commerceOrderItem);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{commerceOrderItem.getCompanyId(), commerceOrderItem.getExternalReferenceCode()}, (Object)commerceOrderItem);
        commerceOrderItem.resetOriginalValues();
    }

    public void cacheResult(List<CommerceOrderItem> commerceOrderItems) {
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (this.entityCache.getResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, (Serializable)Long.valueOf(commerceOrderItem.getPrimaryKey())) == null) {
                this.cacheResult(commerceOrderItem);
                continue;
            }
            commerceOrderItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceOrderItemImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceOrderItem commerceOrderItem) {
        this.entityCache.removeResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, (Serializable)Long.valueOf(commerceOrderItem.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CommerceOrderItemModelImpl)commerceOrderItem, true);
    }

    public void clearCache(List<CommerceOrderItem> commerceOrderItems) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.entityCache.removeResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, (Serializable)Long.valueOf(commerceOrderItem.getPrimaryKey()));
            this.clearUniqueFindersCache((CommerceOrderItemModelImpl)commerceOrderItem, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceOrderItemModelImpl commerceOrderItemModelImpl) {
        Object[] args = new Object[]{commerceOrderItemModelImpl.getCompanyId(), commerceOrderItemModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)commerceOrderItemModelImpl, false);
    }

    protected void clearUniqueFindersCache(CommerceOrderItemModelImpl commerceOrderItemModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{commerceOrderItemModelImpl.getCompanyId(), commerceOrderItemModelImpl.getExternalReferenceCode()};
            this.finderCache.removeResult(this._finderPathCountByC_ERC, args);
            this.finderCache.removeResult(this._finderPathFetchByC_ERC, args);
        }
        if ((commerceOrderItemModelImpl.getColumnBitmask() & this._finderPathFetchByC_ERC.getColumnBitmask()) != 0L) {
            args = new Object[]{commerceOrderItemModelImpl.getOriginalCompanyId(), commerceOrderItemModelImpl.getOriginalExternalReferenceCode()};
            this.finderCache.removeResult(this._finderPathCountByC_ERC, args);
            this.finderCache.removeResult(this._finderPathFetchByC_ERC, args);
        }
    }

    public CommerceOrderItem create(long commerceOrderItemId) {
        CommerceOrderItemImpl commerceOrderItem = new CommerceOrderItemImpl();
        commerceOrderItem.setNew(true);
        commerceOrderItem.setPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceOrderItem;
    }

    public CommerceOrderItem remove(long commerceOrderItemId) throws NoSuchOrderItemException {
        return this.remove(Long.valueOf(commerceOrderItemId));
    }

    public CommerceOrderItem remove(Serializable primaryKey) throws NoSuchOrderItemException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem commerceOrderItem = (CommerceOrderItem)session.get(CommerceOrderItemImpl.class, primaryKey);
            if (commerceOrderItem == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceOrderItem commerceOrderItem2 = (CommerceOrderItem)this.remove((BaseModel)commerceOrderItem);
            return commerceOrderItem2;
        }
        catch (NoSuchOrderItemException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem removeImpl(CommerceOrderItem commerceOrderItem) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceOrderItem)) {
                commerceOrderItem = (CommerceOrderItem)session.get(CommerceOrderItemImpl.class, commerceOrderItem.getPrimaryKeyObj());
            }
            if (commerceOrderItem != null) {
                session.delete((Object)commerceOrderItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceOrderItem != null) {
            this.clearCache(commerceOrderItem);
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem updateImpl(CommerceOrderItem commerceOrderItem) {
        boolean isNew = commerceOrderItem.isNew();
        if (!(commerceOrderItem instanceof CommerceOrderItemModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceOrderItem.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceOrderItem);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceOrderItem proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceOrderItem implementation " + commerceOrderItem.getClass());
        }
        CommerceOrderItemModelImpl commerceOrderItemModelImpl = (CommerceOrderItemModelImpl)commerceOrderItem;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceOrderItem.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceOrderItem.setCreateDate(now);
            } else {
                commerceOrderItem.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceOrderItemModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceOrderItem.setModifiedDate(now);
            } else {
                commerceOrderItem.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (commerceOrderItem.isNew()) {
                session.save((Object)commerceOrderItem);
                commerceOrderItem.setNew(false);
            } else {
                commerceOrderItem = (CommerceOrderItem)session.merge((Object)commerceOrderItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommerceOrderItemModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commerceOrderItemModelImpl.getCommerceOrderId()};
            this.finderCache.removeResult(this._finderPathCountByCommerceOrderId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderId, args);
            args = new Object[]{commerceOrderItemModelImpl.getCProductId()};
            this.finderCache.removeResult(this._finderPathCountByCProductId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCProductId, args);
            args = new Object[]{commerceOrderItemModelImpl.getCPInstanceId()};
            this.finderCache.removeResult(this._finderPathCountByCPInstanceId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCPInstanceId, args);
            args = new Object[]{commerceOrderItemModelImpl.getCommerceOrderId(), commerceOrderItemModelImpl.getCPInstanceId()};
            this.finderCache.removeResult(this._finderPathCountByC_I, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_I, args);
            args = new Object[]{commerceOrderItemModelImpl.getCommerceOrderId(), commerceOrderItemModelImpl.isSubscription()};
            this.finderCache.removeResult(this._finderPathCountByC_S, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commerceOrderItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCommerceOrderId.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceOrderItemModelImpl.getOriginalCommerceOrderId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceOrderId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderId, args);
                args = new Object[]{commerceOrderItemModelImpl.getCommerceOrderId()};
                this.finderCache.removeResult(this._finderPathCountByCommerceOrderId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCommerceOrderId, args);
            }
            if ((commerceOrderItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCProductId.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceOrderItemModelImpl.getOriginalCProductId()};
                this.finderCache.removeResult(this._finderPathCountByCProductId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCProductId, args);
                args = new Object[]{commerceOrderItemModelImpl.getCProductId()};
                this.finderCache.removeResult(this._finderPathCountByCProductId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCProductId, args);
            }
            if ((commerceOrderItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCPInstanceId.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceOrderItemModelImpl.getOriginalCPInstanceId()};
                this.finderCache.removeResult(this._finderPathCountByCPInstanceId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCPInstanceId, args);
                args = new Object[]{commerceOrderItemModelImpl.getCPInstanceId()};
                this.finderCache.removeResult(this._finderPathCountByCPInstanceId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCPInstanceId, args);
            }
            if ((commerceOrderItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_I.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceOrderItemModelImpl.getOriginalCommerceOrderId(), commerceOrderItemModelImpl.getOriginalCPInstanceId()};
                this.finderCache.removeResult(this._finderPathCountByC_I, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_I, args);
                args = new Object[]{commerceOrderItemModelImpl.getCommerceOrderId(), commerceOrderItemModelImpl.getCPInstanceId()};
                this.finderCache.removeResult(this._finderPathCountByC_I, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_I, args);
            }
            if ((commerceOrderItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_S.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceOrderItemModelImpl.getOriginalCommerceOrderId(), commerceOrderItemModelImpl.getOriginalSubscription()};
                this.finderCache.removeResult(this._finderPathCountByC_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
                args = new Object[]{commerceOrderItemModelImpl.getCommerceOrderId(), commerceOrderItemModelImpl.isSubscription()};
                this.finderCache.removeResult(this._finderPathCountByC_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
            }
        }
        this.entityCache.putResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, (Serializable)Long.valueOf(commerceOrderItem.getPrimaryKey()), (Serializable)commerceOrderItem, false);
        this.clearUniqueFindersCache(commerceOrderItemModelImpl, false);
        this.cacheUniqueFindersCache(commerceOrderItemModelImpl);
        commerceOrderItem.resetOriginalValues();
        return commerceOrderItem;
    }

    public CommerceOrderItem findByPrimaryKey(Serializable primaryKey) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByPrimaryKey(primaryKey);
        if (commerceOrderItem == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem findByPrimaryKey(long commerceOrderItemId) throws NoSuchOrderItemException {
        return this.findByPrimaryKey(Long.valueOf(commerceOrderItemId));
    }

    public CommerceOrderItem fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommerceOrderItem commerceOrderItem = (CommerceOrderItem)serializable;
        if (commerceOrderItem == null) {
            Session session = null;
            try {
                session = this.openSession();
                commerceOrderItem = (CommerceOrderItem)session.get(CommerceOrderItemImpl.class, primaryKey);
                if (commerceOrderItem != null) {
                    this.cacheResult(commerceOrderItem);
                } else {
                    this.entityCache.putResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem fetchByPrimaryKey(long commerceOrderItemId) {
        return this.fetchByPrimaryKey(Long.valueOf(commerceOrderItemId));
    }

    public Map<Serializable, CommerceOrderItem> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommerceOrderItem> map = new HashMap<Serializable, CommerceOrderItem>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommerceOrderItem commerceOrderItem = this.fetchByPrimaryKey(primaryKey);
            if (commerceOrderItem != null) {
                map.put(primaryKey, commerceOrderItem);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommerceOrderItem)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (CommerceOrderItem commerceOrderItem : q.list()) {
                map.put(commerceOrderItem.getPrimaryKeyObj(), commerceOrderItem);
                this.cacheResult(commerceOrderItem);
                uncachedPrimaryKeys.remove(commerceOrderItem.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommerceOrderItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceOrderItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceOrderItem> findAll(int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findAll(int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COMMERCEORDERITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEORDERITEM;
                sql = sql.concat(" ORDER BY commerceOrderItem.createDate ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceOrderItem commerceOrderItem : this.findAll()) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMMERCEORDERITEM);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceOrderItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCommerceOrderId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCommerceOrderId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCommerceOrderId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCommerceOrderId", new String[]{Long.class.getName()}, 68L);
        this._finderPathCountByCommerceOrderId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCommerceOrderId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCProductId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCProductId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCProductId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCProductId", new String[]{Long.class.getName()}, 66L);
        this._finderPathCountByCProductId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCProductId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCPInstanceId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCPInstanceId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCPInstanceId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCPInstanceId", new String[]{Long.class.getName()}, 65L);
        this._finderPathCountByCPInstanceId = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCPInstanceId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByC_I = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_I", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_I = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_I", new String[]{Long.class.getName(), Long.class.getName()}, 69L);
        this._finderPathCountByC_I = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_I", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByC_S = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_S = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Boolean.class.getName()}, 100L);
        this._finderPathCountByC_S = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Boolean.class.getName()});
        this._finderPathFetchByC_ERC = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, CommerceOrderItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, 24L);
        this._finderPathCountByC_ERC = new FinderPath(CommerceOrderItemModelImpl.ENTITY_CACHE_ENABLED, CommerceOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceOrderItemImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

