/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentExpectedDateException;
import com.liferay.commerce.exception.CommerceShipmentShippingDateException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.base.CommerceShipmentLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;

public class CommerceShipmentLocalServiceImpl
extends CommerceShipmentLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        commerceShipment.setGroupId(commerceOrder.getGroupId());
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setCommerceAccountId(commerceOrder.getCommerceAccountId());
        commerceShipment.setCommerceAddressId(commerceOrder.getShippingAddressId());
        commerceShipment.setCommerceShippingMethodId(commerceOrder.getCommerceShippingMethodId());
        commerceShipment.setShippingOptionName(commerceOrder.getShippingOptionName());
        commerceShipment.setStatus(0);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipment deleteCommerceShipment(CommerceShipment commerceShipment) {
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItems(commerceShipment.getCommerceShipmentId());
        this.commerceShipmentPersistence.remove((BaseModel)commerceShipment);
        return commerceShipment;
    }

    @Override
    public CommerceShipment deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        return this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment);
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByG_S(groupIds, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByGroupIds(groupIds, start, end, orderByComparator);
    }

    public int getCommerceShipmentsCount(long[] groupIds) {
        return this.commerceShipmentPersistence.countByGroupIds(groupIds);
    }

    public int getCommerceShipmentsCount(long[] groupIds, int status) {
        return this.commerceShipmentPersistence.countByG_S(groupIds, status);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        String name = null;
        String description = null;
        String street1 = null;
        String street2 = null;
        String street3 = null;
        String city = null;
        String zip = null;
        long commerceRegionId = 0L;
        long commerceCountryId = 0L;
        String phoneNumber = null;
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        CommerceAddress commerceAddress = commerceShipment.fetchCommerceAddress();
        if (commerceAddress != null) {
            name = commerceAddress.getName();
            description = commerceAddress.getDescription();
            street1 = commerceAddress.getStreet1();
            street2 = commerceAddress.getStreet2();
            street3 = commerceAddress.getStreet3();
            city = commerceAddress.getCity();
            zip = commerceAddress.getZip();
            commerceRegionId = commerceAddress.getCommerceRegionId();
            commerceCountryId = commerceAddress.getCommerceCountryId();
            phoneNumber = commerceAddress.getPhoneNumber();
        }
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this.userLocalService.getUser(commerceShipment.getUserId());
        int oldStatus = commerceShipment.getStatus();
        this.validate(status, oldStatus);
        Date shippingDate = PortalUtil.getDate((int)shippingDateMonth, (int)shippingDateDay, (int)shippingDateYear, (int)shippingDateHour, (int)shippingDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentShippingDateException.class);
        Date expectedDate = PortalUtil.getDate((int)expectedDateMonth, (int)expectedDateDay, (int)expectedDateYear, (int)expectedDateHour, (int)expectedDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentExpectedDateException.class);
        CommerceAddress commerceAddress = this.updateCommerceShipmentAddress(commerceShipment, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber);
        commerceShipment.setCommerceAddressId(commerceAddress.getCommerceAddressId());
        commerceShipment.setCarrier(carrier);
        commerceShipment.setTrackingNumber(trackingNumber);
        commerceShipment.setShippingDate(shippingDate);
        commerceShipment.setExpectedDate(expectedDate);
        commerceShipment.setStatus(status);
        this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
        this.updateCommerceOrderStatus(commerceShipment.getCommerceShipmentId(), status, oldStatus);
        return commerceShipment;
    }

    protected void updateCommerceOrderStatus(long commerceShipmentId, int status, int oldStatus) throws PortalException {
        if (status <= oldStatus) {
            return;
        }
        List commerceShipmentItems = this.commerceShipmentItemLocalService.getCommerceShipmentItems(commerceShipmentId, -1, -1, null);
        if (commerceShipmentItems.isEmpty()) {
            return;
        }
        CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)commerceShipmentItems.get(0);
        CommerceOrderItem commerceOrderItem = commerceShipmentItem.fetchCommerceOrderItem();
        if (commerceOrderItem == null) {
            return;
        }
        long commerceOrderId = commerceOrderItem.getCommerceOrderId();
        List commerceOrderItems = this.commerceOrderItemLocalService.getAvailableForShipmentCommerceOrderItems(commerceOrderId);
        if (status == 1) {
            this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 12);
        } else if (status == 2) {
            if (commerceOrderItems.isEmpty()) {
                this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 15);
            } else {
                this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 14);
            }
        } else if (status == 3 && commerceOrderItems.isEmpty()) {
            this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 0);
        }
    }

    protected CommerceAddress updateCommerceShipmentAddress(CommerceShipment commerceShipment, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber) throws PortalException {
        CommerceAddress commerceAddress = commerceShipment.fetchCommerceAddress();
        if (Objects.equals(name, commerceAddress.getName()) && Objects.equals(description, commerceAddress.getDescription()) && Objects.equals(street1, commerceAddress.getStreet1()) && Objects.equals(street2, commerceAddress.getStreet2()) && Objects.equals(street3, commerceAddress.getStreet3()) && Objects.equals(city, commerceAddress.getCity()) && Objects.equals(zip, commerceAddress.getZip()) && Objects.equals(commerceRegionId, commerceAddress.getCommerceRegionId()) && Objects.equals(commerceCountryId, commerceAddress.getCommerceCountryId()) && Objects.equals(phoneNumber, commerceAddress.getPhoneNumber())) {
            return commerceAddress;
        }
        return this.commerceAddressLocalService.addCommerceAddress(commerceShipment.getModelClassName(), commerceShipment.getCommerceShipmentId(), name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, false, false, ServiceContextThreadLocal.getServiceContext());
    }

    protected void validate(int status, int oldStatus) throws PortalException {
        if (status < oldStatus) {
            throw new CommerceShipmentStatusException();
        }
    }
}

