/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.base.CommerceOrderItemServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.List;

public class CommerceOrderItemServiceImpl
extends CommerceOrderItemServiceBaseImpl {
    @ServiceReference(type=CommerceProductViewPermission.class)
    protected CommerceProductViewPermission commerceProductViewPermission;
    @ServiceReference(type=CPInstanceLocalService.class)
    protected CPInstanceLocalService cpInstanceLocalService;
    private static volatile ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceOrderItemServiceImpl.class, (String)"_commerceOrderModelResourcePermission", CommerceOrder.class);

    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderItemLocalService.addCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, shippedQuantity, json, commerceContext, serviceContext);
    }

    public void deleteCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
    }

    public void deleteCommerceOrderItem(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem, commerceContext);
    }

    public void deleteCommerceOrderItems(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItems(commerceOrderId);
    }

    public CommerceOrderItem fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchByExternalReferenceCode(companyId, externalReferenceCode);
        if (commerceOrderItem != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem fetchCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(commerceOrderItemId);
        if (commerceOrderItem != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        }
        return commerceOrderItem;
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getAvailableForShipmentCommerceOrderItems(commerceOrderId);
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return this.commerceOrderItemLocalService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItemId, commerceInventoryWarehouseId);
    }

    public CommerceOrderItem getCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return commerceOrderItem;
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItems(commerceOrderId, start, end);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(commerceOrderId);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(commerceOrderId, cpInstanceId);
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.search(commerceOrderId, keywords, start, end, sort);
    }

    public BaseModelSearchResult<CommerceOrderItem> search(long commerceOrderId, String sku, String name, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.search(commerceOrderId, sku, name, andOperator, start, end, sort);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), quantity, json, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, deliveryGroup, shippingAddressId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal unitPrice, BigDecimal promoPrice, BigDecimal discountAmount, BigDecimal finalPrice, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemPrices(commerceOrderItemId, unitPrice, promoPrice, discountAmount, finalPrice, discountPercentageLevel1, discountPercentageLevel2, discountPercentageLevel3, discountPercentageLevel4);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(commerceOrderItemId, unitPrice);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice, int quantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(commerceOrderItemId, unitPrice, quantity);
    }

    public CommerceOrderItem upsertCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, String json, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        CommerceOrder commerceOrder = this.commerceOrderService.getCommerceOrder(commerceOrderId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE");
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this.commerceProductViewPermission.check(this.getPermissionChecker(), commerceAccount.getCommerceAccountId(), commerceOrder.getGroupId(), cpInstance.getCPDefinitionId());
        return this.commerceOrderItemLocalService.upsertCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, shippedQuantity, json, commerceContext, serviceContext);
    }
}

