/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.commerce.model.CommerceOrderSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceOrder service. Represents a row in the &quot;CommerceOrder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface </code>CommerceOrderModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceOrderModelImpl
	extends BaseModelImpl<CommerceOrder> implements CommerceOrderModel {

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order model instance should use the <code>CommerceOrder</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceOrder";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"commerceOrderId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"commerceAccountId", Types.BIGINT},
		{"commerceCurrencyId", Types.BIGINT},
		{"billingAddressId", Types.BIGINT}, {"shippingAddressId", Types.BIGINT},
		{"commercePaymentMethodKey", Types.VARCHAR},
		{"transactionId", Types.CLOB},
		{"commerceShippingMethodId", Types.BIGINT},
		{"shippingOptionName", Types.VARCHAR},
		{"purchaseOrderNumber", Types.VARCHAR}, {"couponCode", Types.VARCHAR},
		{"lastPriceUpdateDate", Types.TIMESTAMP}, {"subtotal", Types.DECIMAL},
		{"subtotalDiscountAmount", Types.DECIMAL},
		{"subtotalDiscountPercentLevel1", Types.DECIMAL},
		{"subtotalDiscountPercentLevel2", Types.DECIMAL},
		{"subtotalDiscountPercentLevel3", Types.DECIMAL},
		{"subtotalDiscountPercentLevel4", Types.DECIMAL},
		{"shippingAmount", Types.DECIMAL},
		{"shippingDiscountAmount", Types.DECIMAL},
		{"shippingDiscountPercentLevel1", Types.DECIMAL},
		{"shippingDiscountPercentLevel2", Types.DECIMAL},
		{"shippingDiscountPercentLevel3", Types.DECIMAL},
		{"shippingDiscountPercentLevel4", Types.DECIMAL},
		{"taxAmount", Types.DECIMAL}, {"total", Types.DECIMAL},
		{"totalDiscountAmount", Types.DECIMAL},
		{"totalDiscountPercentageLevel1", Types.DECIMAL},
		{"totalDiscountPercentageLevel2", Types.DECIMAL},
		{"totalDiscountPercentageLevel3", Types.DECIMAL},
		{"totalDiscountPercentageLevel4", Types.DECIMAL},
		{"advanceStatus", Types.VARCHAR}, {"paymentStatus", Types.INTEGER},
		{"orderStatus", Types.INTEGER}, {"printedNote", Types.VARCHAR},
		{"requestedDeliveryDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceOrderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceAccountId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCurrencyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("billingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commercePaymentMethodKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("transactionId", Types.CLOB);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingOptionName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("purchaseOrderNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("couponCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPriceUpdateDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("subtotal", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("taxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("total", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("advanceStatus", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("paymentStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("orderStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("printedNote", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("requestedDeliveryDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceOrder (uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commerceOrderId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceAccountId LONG,commerceCurrencyId LONG,billingAddressId LONG,shippingAddressId LONG,commercePaymentMethodKey VARCHAR(75) null,transactionId TEXT null,commerceShippingMethodId LONG,shippingOptionName VARCHAR(255) null,purchaseOrderNumber VARCHAR(75) null,couponCode VARCHAR(75) null,lastPriceUpdateDate DATE null,subtotal DECIMAL(30, 16) null,subtotalDiscountAmount DECIMAL(30, 16) null,subtotalDiscountPercentLevel1 DECIMAL(30, 16) null,subtotalDiscountPercentLevel2 DECIMAL(30, 16) null,subtotalDiscountPercentLevel3 DECIMAL(30, 16) null,subtotalDiscountPercentLevel4 DECIMAL(30, 16) null,shippingAmount DECIMAL(30, 16) null,shippingDiscountAmount DECIMAL(30, 16) null,shippingDiscountPercentLevel1 DECIMAL(30, 16) null,shippingDiscountPercentLevel2 DECIMAL(30, 16) null,shippingDiscountPercentLevel3 DECIMAL(30, 16) null,shippingDiscountPercentLevel4 DECIMAL(30, 16) null,taxAmount DECIMAL(30, 16) null,total DECIMAL(30, 16) null,totalDiscountAmount DECIMAL(30, 16) null,totalDiscountPercentageLevel1 DECIMAL(30, 16) null,totalDiscountPercentageLevel2 DECIMAL(30, 16) null,totalDiscountPercentageLevel3 DECIMAL(30, 16) null,totalDiscountPercentageLevel4 DECIMAL(30, 16) null,advanceStatus VARCHAR(75) null,paymentStatus INTEGER,orderStatus INTEGER,printedNote VARCHAR(75) null,requestedDeliveryDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommerceOrder";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceOrder.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceOrder.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceOrder"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceOrder"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceOrder"),
		true);

	public static final long BILLINGADDRESSID_COLUMN_BITMASK = 1L;

	public static final long COMMERCEACCOUNTID_COLUMN_BITMASK = 2L;

	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	public static final long CREATEDATE_COLUMN_BITMASK = 8L;

	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 16L;

	public static final long GROUPID_COLUMN_BITMASK = 32L;

	public static final long ORDERSTATUS_COLUMN_BITMASK = 64L;

	public static final long SHIPPINGADDRESSID_COLUMN_BITMASK = 128L;

	public static final long USERID_COLUMN_BITMASK = 256L;

	public static final long UUID_COLUMN_BITMASK = 512L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceOrder toModel(CommerceOrderSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceOrder model = new CommerceOrderImpl();

		model.setUuid(soapModel.getUuid());
		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommerceOrderId(soapModel.getCommerceOrderId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceAccountId(soapModel.getCommerceAccountId());
		model.setCommerceCurrencyId(soapModel.getCommerceCurrencyId());
		model.setBillingAddressId(soapModel.getBillingAddressId());
		model.setShippingAddressId(soapModel.getShippingAddressId());
		model.setCommercePaymentMethodKey(
			soapModel.getCommercePaymentMethodKey());
		model.setTransactionId(soapModel.getTransactionId());
		model.setCommerceShippingMethodId(
			soapModel.getCommerceShippingMethodId());
		model.setShippingOptionName(soapModel.getShippingOptionName());
		model.setPurchaseOrderNumber(soapModel.getPurchaseOrderNumber());
		model.setCouponCode(soapModel.getCouponCode());
		model.setLastPriceUpdateDate(soapModel.getLastPriceUpdateDate());
		model.setSubtotal(soapModel.getSubtotal());
		model.setSubtotalDiscountAmount(soapModel.getSubtotalDiscountAmount());
		model.setSubtotalDiscountPercentageLevel1(
			soapModel.getSubtotalDiscountPercentageLevel1());
		model.setSubtotalDiscountPercentageLevel2(
			soapModel.getSubtotalDiscountPercentageLevel2());
		model.setSubtotalDiscountPercentageLevel3(
			soapModel.getSubtotalDiscountPercentageLevel3());
		model.setSubtotalDiscountPercentageLevel4(
			soapModel.getSubtotalDiscountPercentageLevel4());
		model.setShippingAmount(soapModel.getShippingAmount());
		model.setShippingDiscountAmount(soapModel.getShippingDiscountAmount());
		model.setShippingDiscountPercentageLevel1(
			soapModel.getShippingDiscountPercentageLevel1());
		model.setShippingDiscountPercentageLevel2(
			soapModel.getShippingDiscountPercentageLevel2());
		model.setShippingDiscountPercentageLevel3(
			soapModel.getShippingDiscountPercentageLevel3());
		model.setShippingDiscountPercentageLevel4(
			soapModel.getShippingDiscountPercentageLevel4());
		model.setTaxAmount(soapModel.getTaxAmount());
		model.setTotal(soapModel.getTotal());
		model.setTotalDiscountAmount(soapModel.getTotalDiscountAmount());
		model.setTotalDiscountPercentageLevel1(
			soapModel.getTotalDiscountPercentageLevel1());
		model.setTotalDiscountPercentageLevel2(
			soapModel.getTotalDiscountPercentageLevel2());
		model.setTotalDiscountPercentageLevel3(
			soapModel.getTotalDiscountPercentageLevel3());
		model.setTotalDiscountPercentageLevel4(
			soapModel.getTotalDiscountPercentageLevel4());
		model.setAdvanceStatus(soapModel.getAdvanceStatus());
		model.setPaymentStatus(soapModel.getPaymentStatus());
		model.setOrderStatus(soapModel.getOrderStatus());
		model.setPrintedNote(soapModel.getPrintedNote());
		model.setRequestedDeliveryDate(soapModel.getRequestedDeliveryDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceOrder> toModels(CommerceOrderSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceOrder> models = new ArrayList<CommerceOrder>(
			soapModels.length);

		for (CommerceOrderSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceOrder"));

	public CommerceOrderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceOrderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceOrder.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceOrder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceOrder)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceOrder, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceOrder, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceOrder)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceOrder, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceOrder, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceOrder>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceOrder.class.getClassLoader(), CommerceOrder.class,
			ModelWrapper.class);

		try {
			Constructor<CommerceOrder> constructor =
				(Constructor<CommerceOrder>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException roe) {
					throw new InternalError(roe);
				}
			};
		}
		catch (NoSuchMethodException nsme) {
			throw new InternalError(nsme);
		}
	}

	private static final Map<String, Function<CommerceOrder, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceOrder, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<CommerceOrder, Object>>();
		Map<String, BiConsumer<CommerceOrder, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<CommerceOrder, ?>>();

		attributeGetterFunctions.put(
			"uuid",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getUuid();
				}

			});
		attributeSetterBiConsumers.put(
			"uuid",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(CommerceOrder commerceOrder, Object uuid) {
					commerceOrder.setUuid((String)uuid);
				}

			});
		attributeGetterFunctions.put(
			"externalReferenceCode",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getExternalReferenceCode();
				}

			});
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object externalReferenceCode) {

					commerceOrder.setExternalReferenceCode(
						(String)externalReferenceCode);
				}

			});
		attributeGetterFunctions.put(
			"commerceOrderId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCommerceOrderId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceOrderId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object commerceOrderId) {

					commerceOrder.setCommerceOrderId((Long)commerceOrderId);
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getGroupId();
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object groupId) {

					commerceOrder.setGroupId((Long)groupId);
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCompanyId();
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object companyId) {

					commerceOrder.setCompanyId((Long)companyId);
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(CommerceOrder commerceOrder, Object userId) {
					commerceOrder.setUserId((Long)userId);
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object userName) {

					commerceOrder.setUserName((String)userName);
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCreateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object createDate) {

					commerceOrder.setCreateDate((Date)createDate);
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getModifiedDate();
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object modifiedDate) {

					commerceOrder.setModifiedDate((Date)modifiedDate);
				}

			});
		attributeGetterFunctions.put(
			"commerceAccountId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCommerceAccountId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceAccountId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object commerceAccountId) {

					commerceOrder.setCommerceAccountId((Long)commerceAccountId);
				}

			});
		attributeGetterFunctions.put(
			"commerceCurrencyId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCommerceCurrencyId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceCurrencyId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object commerceCurrencyId) {

					commerceOrder.setCommerceCurrencyId(
						(Long)commerceCurrencyId);
				}

			});
		attributeGetterFunctions.put(
			"billingAddressId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getBillingAddressId();
				}

			});
		attributeSetterBiConsumers.put(
			"billingAddressId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object billingAddressId) {

					commerceOrder.setBillingAddressId((Long)billingAddressId);
				}

			});
		attributeGetterFunctions.put(
			"shippingAddressId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingAddressId();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingAddressId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object shippingAddressId) {

					commerceOrder.setShippingAddressId((Long)shippingAddressId);
				}

			});
		attributeGetterFunctions.put(
			"commercePaymentMethodKey",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCommercePaymentMethodKey();
				}

			});
		attributeSetterBiConsumers.put(
			"commercePaymentMethodKey",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object commercePaymentMethodKey) {

					commerceOrder.setCommercePaymentMethodKey(
						(String)commercePaymentMethodKey);
				}

			});
		attributeGetterFunctions.put(
			"transactionId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTransactionId();
				}

			});
		attributeSetterBiConsumers.put(
			"transactionId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object transactionId) {

					commerceOrder.setTransactionId((String)transactionId);
				}

			});
		attributeGetterFunctions.put(
			"commerceShippingMethodId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCommerceShippingMethodId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceShippingMethodId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object commerceShippingMethodId) {

					commerceOrder.setCommerceShippingMethodId(
						(Long)commerceShippingMethodId);
				}

			});
		attributeGetterFunctions.put(
			"shippingOptionName",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingOptionName();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingOptionName",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object shippingOptionName) {

					commerceOrder.setShippingOptionName(
						(String)shippingOptionName);
				}

			});
		attributeGetterFunctions.put(
			"purchaseOrderNumber",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getPurchaseOrderNumber();
				}

			});
		attributeSetterBiConsumers.put(
			"purchaseOrderNumber",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object purchaseOrderNumber) {

					commerceOrder.setPurchaseOrderNumber(
						(String)purchaseOrderNumber);
				}

			});
		attributeGetterFunctions.put(
			"couponCode",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getCouponCode();
				}

			});
		attributeSetterBiConsumers.put(
			"couponCode",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object couponCode) {

					commerceOrder.setCouponCode((String)couponCode);
				}

			});
		attributeGetterFunctions.put(
			"lastPriceUpdateDate",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getLastPriceUpdateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"lastPriceUpdateDate",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object lastPriceUpdateDate) {

					commerceOrder.setLastPriceUpdateDate(
						(Date)lastPriceUpdateDate);
				}

			});
		attributeGetterFunctions.put(
			"subtotal",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getSubtotal();
				}

			});
		attributeSetterBiConsumers.put(
			"subtotal",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object subtotal) {

					commerceOrder.setSubtotal((BigDecimal)subtotal);
				}

			});
		attributeGetterFunctions.put(
			"subtotalDiscountAmount",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getSubtotalDiscountAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"subtotalDiscountAmount",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object subtotalDiscountAmount) {

					commerceOrder.setSubtotalDiscountAmount(
						(BigDecimal)subtotalDiscountAmount);
				}

			});
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel1",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getSubtotalDiscountPercentageLevel1();
				}

			});
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel1",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object subtotalDiscountPercentageLevel1) {

					commerceOrder.setSubtotalDiscountPercentageLevel1(
						(BigDecimal)subtotalDiscountPercentageLevel1);
				}

			});
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel2",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getSubtotalDiscountPercentageLevel2();
				}

			});
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel2",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object subtotalDiscountPercentageLevel2) {

					commerceOrder.setSubtotalDiscountPercentageLevel2(
						(BigDecimal)subtotalDiscountPercentageLevel2);
				}

			});
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel3",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getSubtotalDiscountPercentageLevel3();
				}

			});
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel3",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object subtotalDiscountPercentageLevel3) {

					commerceOrder.setSubtotalDiscountPercentageLevel3(
						(BigDecimal)subtotalDiscountPercentageLevel3);
				}

			});
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel4",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getSubtotalDiscountPercentageLevel4();
				}

			});
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel4",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object subtotalDiscountPercentageLevel4) {

					commerceOrder.setSubtotalDiscountPercentageLevel4(
						(BigDecimal)subtotalDiscountPercentageLevel4);
				}

			});
		attributeGetterFunctions.put(
			"shippingAmount",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingAmount",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object shippingAmount) {

					commerceOrder.setShippingAmount((BigDecimal)shippingAmount);
				}

			});
		attributeGetterFunctions.put(
			"shippingDiscountAmount",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingDiscountAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingDiscountAmount",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object shippingDiscountAmount) {

					commerceOrder.setShippingDiscountAmount(
						(BigDecimal)shippingDiscountAmount);
				}

			});
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel1",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingDiscountPercentageLevel1();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel1",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object shippingDiscountPercentageLevel1) {

					commerceOrder.setShippingDiscountPercentageLevel1(
						(BigDecimal)shippingDiscountPercentageLevel1);
				}

			});
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel2",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingDiscountPercentageLevel2();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel2",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object shippingDiscountPercentageLevel2) {

					commerceOrder.setShippingDiscountPercentageLevel2(
						(BigDecimal)shippingDiscountPercentageLevel2);
				}

			});
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel3",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingDiscountPercentageLevel3();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel3",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object shippingDiscountPercentageLevel3) {

					commerceOrder.setShippingDiscountPercentageLevel3(
						(BigDecimal)shippingDiscountPercentageLevel3);
				}

			});
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel4",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getShippingDiscountPercentageLevel4();
				}

			});
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel4",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object shippingDiscountPercentageLevel4) {

					commerceOrder.setShippingDiscountPercentageLevel4(
						(BigDecimal)shippingDiscountPercentageLevel4);
				}

			});
		attributeGetterFunctions.put(
			"taxAmount",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTaxAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"taxAmount",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object taxAmount) {

					commerceOrder.setTaxAmount((BigDecimal)taxAmount);
				}

			});
		attributeGetterFunctions.put(
			"total",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTotal();
				}

			});
		attributeSetterBiConsumers.put(
			"total",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(CommerceOrder commerceOrder, Object total) {
					commerceOrder.setTotal((BigDecimal)total);
				}

			});
		attributeGetterFunctions.put(
			"totalDiscountAmount",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTotalDiscountAmount();
				}

			});
		attributeSetterBiConsumers.put(
			"totalDiscountAmount",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object totalDiscountAmount) {

					commerceOrder.setTotalDiscountAmount(
						(BigDecimal)totalDiscountAmount);
				}

			});
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel1",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTotalDiscountPercentageLevel1();
				}

			});
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel1",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object totalDiscountPercentageLevel1) {

					commerceOrder.setTotalDiscountPercentageLevel1(
						(BigDecimal)totalDiscountPercentageLevel1);
				}

			});
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel2",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTotalDiscountPercentageLevel2();
				}

			});
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel2",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object totalDiscountPercentageLevel2) {

					commerceOrder.setTotalDiscountPercentageLevel2(
						(BigDecimal)totalDiscountPercentageLevel2);
				}

			});
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel3",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTotalDiscountPercentageLevel3();
				}

			});
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel3",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object totalDiscountPercentageLevel3) {

					commerceOrder.setTotalDiscountPercentageLevel3(
						(BigDecimal)totalDiscountPercentageLevel3);
				}

			});
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel4",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getTotalDiscountPercentageLevel4();
				}

			});
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel4",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder,
					Object totalDiscountPercentageLevel4) {

					commerceOrder.setTotalDiscountPercentageLevel4(
						(BigDecimal)totalDiscountPercentageLevel4);
				}

			});
		attributeGetterFunctions.put(
			"advanceStatus",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getAdvanceStatus();
				}

			});
		attributeSetterBiConsumers.put(
			"advanceStatus",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object advanceStatus) {

					commerceOrder.setAdvanceStatus((String)advanceStatus);
				}

			});
		attributeGetterFunctions.put(
			"paymentStatus",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getPaymentStatus();
				}

			});
		attributeSetterBiConsumers.put(
			"paymentStatus",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object paymentStatus) {

					commerceOrder.setPaymentStatus((Integer)paymentStatus);
				}

			});
		attributeGetterFunctions.put(
			"orderStatus",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getOrderStatus();
				}

			});
		attributeSetterBiConsumers.put(
			"orderStatus",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object orderStatus) {

					commerceOrder.setOrderStatus((Integer)orderStatus);
				}

			});
		attributeGetterFunctions.put(
			"printedNote",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getPrintedNote();
				}

			});
		attributeSetterBiConsumers.put(
			"printedNote",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object printedNote) {

					commerceOrder.setPrintedNote((String)printedNote);
				}

			});
		attributeGetterFunctions.put(
			"requestedDeliveryDate",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getRequestedDeliveryDate();
				}

			});
		attributeSetterBiConsumers.put(
			"requestedDeliveryDate",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object requestedDeliveryDate) {

					commerceOrder.setRequestedDeliveryDate(
						(Date)requestedDeliveryDate);
				}

			});
		attributeGetterFunctions.put(
			"status",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getStatus();
				}

			});
		attributeSetterBiConsumers.put(
			"status",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(CommerceOrder commerceOrder, Object status) {
					commerceOrder.setStatus((Integer)status);
				}

			});
		attributeGetterFunctions.put(
			"statusByUserId",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getStatusByUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"statusByUserId",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object statusByUserId) {

					commerceOrder.setStatusByUserId((Long)statusByUserId);
				}

			});
		attributeGetterFunctions.put(
			"statusByUserName",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getStatusByUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"statusByUserName",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object statusByUserName) {

					commerceOrder.setStatusByUserName((String)statusByUserName);
				}

			});
		attributeGetterFunctions.put(
			"statusDate",
			new Function<CommerceOrder, Object>() {

				@Override
				public Object apply(CommerceOrder commerceOrder) {
					return commerceOrder.getStatusDate();
				}

			});
		attributeSetterBiConsumers.put(
			"statusDate",
			new BiConsumer<CommerceOrder, Object>() {

				@Override
				public void accept(
					CommerceOrder commerceOrder, Object statusDate) {

					commerceOrder.setStatusDate((Date)statusDate);
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		_columnBitmask |= EXTERNALREFERENCECODE_COLUMN_BITMASK;

		if (_originalExternalReferenceCode == null) {
			_originalExternalReferenceCode = _externalReferenceCode;
		}

		_externalReferenceCode = externalReferenceCode;
	}

	public String getOriginalExternalReferenceCode() {
		return GetterUtil.getString(_originalExternalReferenceCode);
	}

	@JSON
	@Override
	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	@Override
	public void setCommerceOrderId(long commerceOrderId) {
		_commerceOrderId = commerceOrderId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		if (_originalCreateDate == null) {
			_originalCreateDate = _createDate;
		}

		_createDate = createDate;
	}

	public Date getOriginalCreateDate() {
		return _originalCreateDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceAccountId() {
		return _commerceAccountId;
	}

	@Override
	public void setCommerceAccountId(long commerceAccountId) {
		_columnBitmask |= COMMERCEACCOUNTID_COLUMN_BITMASK;

		if (!_setOriginalCommerceAccountId) {
			_setOriginalCommerceAccountId = true;

			_originalCommerceAccountId = _commerceAccountId;
		}

		_commerceAccountId = commerceAccountId;
	}

	public long getOriginalCommerceAccountId() {
		return _originalCommerceAccountId;
	}

	@JSON
	@Override
	public long getCommerceCurrencyId() {
		return _commerceCurrencyId;
	}

	@Override
	public void setCommerceCurrencyId(long commerceCurrencyId) {
		_commerceCurrencyId = commerceCurrencyId;
	}

	@JSON
	@Override
	public long getBillingAddressId() {
		return _billingAddressId;
	}

	@Override
	public void setBillingAddressId(long billingAddressId) {
		_columnBitmask |= BILLINGADDRESSID_COLUMN_BITMASK;

		if (!_setOriginalBillingAddressId) {
			_setOriginalBillingAddressId = true;

			_originalBillingAddressId = _billingAddressId;
		}

		_billingAddressId = billingAddressId;
	}

	public long getOriginalBillingAddressId() {
		return _originalBillingAddressId;
	}

	@JSON
	@Override
	public long getShippingAddressId() {
		return _shippingAddressId;
	}

	@Override
	public void setShippingAddressId(long shippingAddressId) {
		_columnBitmask |= SHIPPINGADDRESSID_COLUMN_BITMASK;

		if (!_setOriginalShippingAddressId) {
			_setOriginalShippingAddressId = true;

			_originalShippingAddressId = _shippingAddressId;
		}

		_shippingAddressId = shippingAddressId;
	}

	public long getOriginalShippingAddressId() {
		return _originalShippingAddressId;
	}

	@JSON
	@Override
	public String getCommercePaymentMethodKey() {
		if (_commercePaymentMethodKey == null) {
			return "";
		}
		else {
			return _commercePaymentMethodKey;
		}
	}

	@Override
	public void setCommercePaymentMethodKey(String commercePaymentMethodKey) {
		_commercePaymentMethodKey = commercePaymentMethodKey;
	}

	@JSON
	@Override
	public String getTransactionId() {
		if (_transactionId == null) {
			return "";
		}
		else {
			return _transactionId;
		}
	}

	@Override
	public void setTransactionId(String transactionId) {
		_transactionId = transactionId;
	}

	@JSON
	@Override
	public long getCommerceShippingMethodId() {
		return _commerceShippingMethodId;
	}

	@Override
	public void setCommerceShippingMethodId(long commerceShippingMethodId) {
		_commerceShippingMethodId = commerceShippingMethodId;
	}

	@JSON
	@Override
	public String getShippingOptionName() {
		if (_shippingOptionName == null) {
			return "";
		}
		else {
			return _shippingOptionName;
		}
	}

	@Override
	public void setShippingOptionName(String shippingOptionName) {
		_shippingOptionName = shippingOptionName;
	}

	@JSON
	@Override
	public String getPurchaseOrderNumber() {
		if (_purchaseOrderNumber == null) {
			return "";
		}
		else {
			return _purchaseOrderNumber;
		}
	}

	@Override
	public void setPurchaseOrderNumber(String purchaseOrderNumber) {
		_purchaseOrderNumber = purchaseOrderNumber;
	}

	@JSON
	@Override
	public String getCouponCode() {
		if (_couponCode == null) {
			return "";
		}
		else {
			return _couponCode;
		}
	}

	@Override
	public void setCouponCode(String couponCode) {
		_couponCode = couponCode;
	}

	@JSON
	@Override
	public Date getLastPriceUpdateDate() {
		return _lastPriceUpdateDate;
	}

	@Override
	public void setLastPriceUpdateDate(Date lastPriceUpdateDate) {
		_lastPriceUpdateDate = lastPriceUpdateDate;
	}

	@JSON
	@Override
	public BigDecimal getSubtotal() {
		return _subtotal;
	}

	@Override
	public void setSubtotal(BigDecimal subtotal) {
		_subtotal = subtotal;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountAmount() {
		return _subtotalDiscountAmount;
	}

	@Override
	public void setSubtotalDiscountAmount(BigDecimal subtotalDiscountAmount) {
		_subtotalDiscountAmount = subtotalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel1() {
		return _subtotalDiscountPercentageLevel1;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel1(
		BigDecimal subtotalDiscountPercentageLevel1) {

		_subtotalDiscountPercentageLevel1 = subtotalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel2() {
		return _subtotalDiscountPercentageLevel2;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel2(
		BigDecimal subtotalDiscountPercentageLevel2) {

		_subtotalDiscountPercentageLevel2 = subtotalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel3() {
		return _subtotalDiscountPercentageLevel3;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel3(
		BigDecimal subtotalDiscountPercentageLevel3) {

		_subtotalDiscountPercentageLevel3 = subtotalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel4() {
		return _subtotalDiscountPercentageLevel4;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel4(
		BigDecimal subtotalDiscountPercentageLevel4) {

		_subtotalDiscountPercentageLevel4 = subtotalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getShippingAmount() {
		return _shippingAmount;
	}

	@Override
	public void setShippingAmount(BigDecimal shippingAmount) {
		_shippingAmount = shippingAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountAmount() {
		return _shippingDiscountAmount;
	}

	@Override
	public void setShippingDiscountAmount(BigDecimal shippingDiscountAmount) {
		_shippingDiscountAmount = shippingDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel1() {
		return _shippingDiscountPercentageLevel1;
	}

	@Override
	public void setShippingDiscountPercentageLevel1(
		BigDecimal shippingDiscountPercentageLevel1) {

		_shippingDiscountPercentageLevel1 = shippingDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel2() {
		return _shippingDiscountPercentageLevel2;
	}

	@Override
	public void setShippingDiscountPercentageLevel2(
		BigDecimal shippingDiscountPercentageLevel2) {

		_shippingDiscountPercentageLevel2 = shippingDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel3() {
		return _shippingDiscountPercentageLevel3;
	}

	@Override
	public void setShippingDiscountPercentageLevel3(
		BigDecimal shippingDiscountPercentageLevel3) {

		_shippingDiscountPercentageLevel3 = shippingDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel4() {
		return _shippingDiscountPercentageLevel4;
	}

	@Override
	public void setShippingDiscountPercentageLevel4(
		BigDecimal shippingDiscountPercentageLevel4) {

		_shippingDiscountPercentageLevel4 = shippingDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getTaxAmount() {
		return _taxAmount;
	}

	@Override
	public void setTaxAmount(BigDecimal taxAmount) {
		_taxAmount = taxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotal() {
		return _total;
	}

	@Override
	public void setTotal(BigDecimal total) {
		_total = total;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountAmount() {
		return _totalDiscountAmount;
	}

	@Override
	public void setTotalDiscountAmount(BigDecimal totalDiscountAmount) {
		_totalDiscountAmount = totalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel1() {
		return _totalDiscountPercentageLevel1;
	}

	@Override
	public void setTotalDiscountPercentageLevel1(
		BigDecimal totalDiscountPercentageLevel1) {

		_totalDiscountPercentageLevel1 = totalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel2() {
		return _totalDiscountPercentageLevel2;
	}

	@Override
	public void setTotalDiscountPercentageLevel2(
		BigDecimal totalDiscountPercentageLevel2) {

		_totalDiscountPercentageLevel2 = totalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel3() {
		return _totalDiscountPercentageLevel3;
	}

	@Override
	public void setTotalDiscountPercentageLevel3(
		BigDecimal totalDiscountPercentageLevel3) {

		_totalDiscountPercentageLevel3 = totalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel4() {
		return _totalDiscountPercentageLevel4;
	}

	@Override
	public void setTotalDiscountPercentageLevel4(
		BigDecimal totalDiscountPercentageLevel4) {

		_totalDiscountPercentageLevel4 = totalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public String getAdvanceStatus() {
		if (_advanceStatus == null) {
			return "";
		}
		else {
			return _advanceStatus;
		}
	}

	@Override
	public void setAdvanceStatus(String advanceStatus) {
		_advanceStatus = advanceStatus;
	}

	@JSON
	@Override
	public int getPaymentStatus() {
		return _paymentStatus;
	}

	@Override
	public void setPaymentStatus(int paymentStatus) {
		_paymentStatus = paymentStatus;
	}

	@JSON
	@Override
	public int getOrderStatus() {
		return _orderStatus;
	}

	@Override
	public void setOrderStatus(int orderStatus) {
		_columnBitmask |= ORDERSTATUS_COLUMN_BITMASK;

		if (!_setOriginalOrderStatus) {
			_setOriginalOrderStatus = true;

			_originalOrderStatus = _orderStatus;
		}

		_orderStatus = orderStatus;
	}

	public int getOriginalOrderStatus() {
		return _originalOrderStatus;
	}

	@JSON
	@Override
	public String getPrintedNote() {
		if (_printedNote == null) {
			return "";
		}
		else {
			return _printedNote;
		}
	}

	@Override
	public void setPrintedNote(String printedNote) {
		_printedNote = printedNote;
	}

	@JSON
	@Override
	public Date getRequestedDeliveryDate() {
		return _requestedDeliveryDate;
	}

	@Override
	public void setRequestedDeliveryDate(Date requestedDeliveryDate) {
		_requestedDeliveryDate = requestedDeliveryDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceOrder.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceOrder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceOrder toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceOrder>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceOrderImpl commerceOrderImpl = new CommerceOrderImpl();

		commerceOrderImpl.setUuid(getUuid());
		commerceOrderImpl.setExternalReferenceCode(getExternalReferenceCode());
		commerceOrderImpl.setCommerceOrderId(getCommerceOrderId());
		commerceOrderImpl.setGroupId(getGroupId());
		commerceOrderImpl.setCompanyId(getCompanyId());
		commerceOrderImpl.setUserId(getUserId());
		commerceOrderImpl.setUserName(getUserName());
		commerceOrderImpl.setCreateDate(getCreateDate());
		commerceOrderImpl.setModifiedDate(getModifiedDate());
		commerceOrderImpl.setCommerceAccountId(getCommerceAccountId());
		commerceOrderImpl.setCommerceCurrencyId(getCommerceCurrencyId());
		commerceOrderImpl.setBillingAddressId(getBillingAddressId());
		commerceOrderImpl.setShippingAddressId(getShippingAddressId());
		commerceOrderImpl.setCommercePaymentMethodKey(
			getCommercePaymentMethodKey());
		commerceOrderImpl.setTransactionId(getTransactionId());
		commerceOrderImpl.setCommerceShippingMethodId(
			getCommerceShippingMethodId());
		commerceOrderImpl.setShippingOptionName(getShippingOptionName());
		commerceOrderImpl.setPurchaseOrderNumber(getPurchaseOrderNumber());
		commerceOrderImpl.setCouponCode(getCouponCode());
		commerceOrderImpl.setLastPriceUpdateDate(getLastPriceUpdateDate());
		commerceOrderImpl.setSubtotal(getSubtotal());
		commerceOrderImpl.setSubtotalDiscountAmount(
			getSubtotalDiscountAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1(
			getSubtotalDiscountPercentageLevel1());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2(
			getSubtotalDiscountPercentageLevel2());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3(
			getSubtotalDiscountPercentageLevel3());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4(
			getSubtotalDiscountPercentageLevel4());
		commerceOrderImpl.setShippingAmount(getShippingAmount());
		commerceOrderImpl.setShippingDiscountAmount(
			getShippingDiscountAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel1(
			getShippingDiscountPercentageLevel1());
		commerceOrderImpl.setShippingDiscountPercentageLevel2(
			getShippingDiscountPercentageLevel2());
		commerceOrderImpl.setShippingDiscountPercentageLevel3(
			getShippingDiscountPercentageLevel3());
		commerceOrderImpl.setShippingDiscountPercentageLevel4(
			getShippingDiscountPercentageLevel4());
		commerceOrderImpl.setTaxAmount(getTaxAmount());
		commerceOrderImpl.setTotal(getTotal());
		commerceOrderImpl.setTotalDiscountAmount(getTotalDiscountAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel1(
			getTotalDiscountPercentageLevel1());
		commerceOrderImpl.setTotalDiscountPercentageLevel2(
			getTotalDiscountPercentageLevel2());
		commerceOrderImpl.setTotalDiscountPercentageLevel3(
			getTotalDiscountPercentageLevel3());
		commerceOrderImpl.setTotalDiscountPercentageLevel4(
			getTotalDiscountPercentageLevel4());
		commerceOrderImpl.setAdvanceStatus(getAdvanceStatus());
		commerceOrderImpl.setPaymentStatus(getPaymentStatus());
		commerceOrderImpl.setOrderStatus(getOrderStatus());
		commerceOrderImpl.setPrintedNote(getPrintedNote());
		commerceOrderImpl.setRequestedDeliveryDate(getRequestedDeliveryDate());
		commerceOrderImpl.setStatus(getStatus());
		commerceOrderImpl.setStatusByUserId(getStatusByUserId());
		commerceOrderImpl.setStatusByUserName(getStatusByUserName());
		commerceOrderImpl.setStatusDate(getStatusDate());

		commerceOrderImpl.resetOriginalValues();

		return commerceOrderImpl;
	}

	@Override
	public int compareTo(CommerceOrder commerceOrder) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceOrder.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceOrder)) {
			return false;
		}

		CommerceOrder commerceOrder = (CommerceOrder)obj;

		long primaryKey = commerceOrder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceOrderModelImpl commerceOrderModelImpl = this;

		commerceOrderModelImpl._originalUuid = commerceOrderModelImpl._uuid;

		commerceOrderModelImpl._originalExternalReferenceCode =
			commerceOrderModelImpl._externalReferenceCode;

		commerceOrderModelImpl._originalGroupId =
			commerceOrderModelImpl._groupId;

		commerceOrderModelImpl._setOriginalGroupId = false;

		commerceOrderModelImpl._originalCompanyId =
			commerceOrderModelImpl._companyId;

		commerceOrderModelImpl._setOriginalCompanyId = false;

		commerceOrderModelImpl._originalUserId = commerceOrderModelImpl._userId;

		commerceOrderModelImpl._setOriginalUserId = false;

		commerceOrderModelImpl._originalCreateDate =
			commerceOrderModelImpl._createDate;

		commerceOrderModelImpl._setModifiedDate = false;

		commerceOrderModelImpl._originalCommerceAccountId =
			commerceOrderModelImpl._commerceAccountId;

		commerceOrderModelImpl._setOriginalCommerceAccountId = false;

		commerceOrderModelImpl._originalBillingAddressId =
			commerceOrderModelImpl._billingAddressId;

		commerceOrderModelImpl._setOriginalBillingAddressId = false;

		commerceOrderModelImpl._originalShippingAddressId =
			commerceOrderModelImpl._shippingAddressId;

		commerceOrderModelImpl._setOriginalShippingAddressId = false;

		commerceOrderModelImpl._originalOrderStatus =
			commerceOrderModelImpl._orderStatus;

		commerceOrderModelImpl._setOriginalOrderStatus = false;

		commerceOrderModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceOrder> toCacheModel() {
		CommerceOrderCacheModel commerceOrderCacheModel =
			new CommerceOrderCacheModel();

		commerceOrderCacheModel.uuid = getUuid();

		String uuid = commerceOrderCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceOrderCacheModel.uuid = null;
		}

		commerceOrderCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceOrderCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceOrderCacheModel.externalReferenceCode = null;
		}

		commerceOrderCacheModel.commerceOrderId = getCommerceOrderId();

		commerceOrderCacheModel.groupId = getGroupId();

		commerceOrderCacheModel.companyId = getCompanyId();

		commerceOrderCacheModel.userId = getUserId();

		commerceOrderCacheModel.userName = getUserName();

		String userName = commerceOrderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceOrderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceOrderCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceOrderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceOrderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceOrderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.commerceAccountId = getCommerceAccountId();

		commerceOrderCacheModel.commerceCurrencyId = getCommerceCurrencyId();

		commerceOrderCacheModel.billingAddressId = getBillingAddressId();

		commerceOrderCacheModel.shippingAddressId = getShippingAddressId();

		commerceOrderCacheModel.commercePaymentMethodKey =
			getCommercePaymentMethodKey();

		String commercePaymentMethodKey =
			commerceOrderCacheModel.commercePaymentMethodKey;

		if ((commercePaymentMethodKey != null) &&
			(commercePaymentMethodKey.length() == 0)) {

			commerceOrderCacheModel.commercePaymentMethodKey = null;
		}

		commerceOrderCacheModel.transactionId = getTransactionId();

		String transactionId = commerceOrderCacheModel.transactionId;

		if ((transactionId != null) && (transactionId.length() == 0)) {
			commerceOrderCacheModel.transactionId = null;
		}

		commerceOrderCacheModel.commerceShippingMethodId =
			getCommerceShippingMethodId();

		commerceOrderCacheModel.shippingOptionName = getShippingOptionName();

		String shippingOptionName = commerceOrderCacheModel.shippingOptionName;

		if ((shippingOptionName != null) &&
			(shippingOptionName.length() == 0)) {

			commerceOrderCacheModel.shippingOptionName = null;
		}

		commerceOrderCacheModel.purchaseOrderNumber = getPurchaseOrderNumber();

		String purchaseOrderNumber =
			commerceOrderCacheModel.purchaseOrderNumber;

		if ((purchaseOrderNumber != null) &&
			(purchaseOrderNumber.length() == 0)) {

			commerceOrderCacheModel.purchaseOrderNumber = null;
		}

		commerceOrderCacheModel.couponCode = getCouponCode();

		String couponCode = commerceOrderCacheModel.couponCode;

		if ((couponCode != null) && (couponCode.length() == 0)) {
			commerceOrderCacheModel.couponCode = null;
		}

		Date lastPriceUpdateDate = getLastPriceUpdateDate();

		if (lastPriceUpdateDate != null) {
			commerceOrderCacheModel.lastPriceUpdateDate =
				lastPriceUpdateDate.getTime();
		}
		else {
			commerceOrderCacheModel.lastPriceUpdateDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.subtotal = getSubtotal();

		commerceOrderCacheModel.subtotalDiscountAmount =
			getSubtotalDiscountAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel1 =
			getSubtotalDiscountPercentageLevel1();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel2 =
			getSubtotalDiscountPercentageLevel2();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel3 =
			getSubtotalDiscountPercentageLevel3();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel4 =
			getSubtotalDiscountPercentageLevel4();

		commerceOrderCacheModel.shippingAmount = getShippingAmount();

		commerceOrderCacheModel.shippingDiscountAmount =
			getShippingDiscountAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel1 =
			getShippingDiscountPercentageLevel1();

		commerceOrderCacheModel.shippingDiscountPercentageLevel2 =
			getShippingDiscountPercentageLevel2();

		commerceOrderCacheModel.shippingDiscountPercentageLevel3 =
			getShippingDiscountPercentageLevel3();

		commerceOrderCacheModel.shippingDiscountPercentageLevel4 =
			getShippingDiscountPercentageLevel4();

		commerceOrderCacheModel.taxAmount = getTaxAmount();

		commerceOrderCacheModel.total = getTotal();

		commerceOrderCacheModel.totalDiscountAmount = getTotalDiscountAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel1 =
			getTotalDiscountPercentageLevel1();

		commerceOrderCacheModel.totalDiscountPercentageLevel2 =
			getTotalDiscountPercentageLevel2();

		commerceOrderCacheModel.totalDiscountPercentageLevel3 =
			getTotalDiscountPercentageLevel3();

		commerceOrderCacheModel.totalDiscountPercentageLevel4 =
			getTotalDiscountPercentageLevel4();

		commerceOrderCacheModel.advanceStatus = getAdvanceStatus();

		String advanceStatus = commerceOrderCacheModel.advanceStatus;

		if ((advanceStatus != null) && (advanceStatus.length() == 0)) {
			commerceOrderCacheModel.advanceStatus = null;
		}

		commerceOrderCacheModel.paymentStatus = getPaymentStatus();

		commerceOrderCacheModel.orderStatus = getOrderStatus();

		commerceOrderCacheModel.printedNote = getPrintedNote();

		String printedNote = commerceOrderCacheModel.printedNote;

		if ((printedNote != null) && (printedNote.length() == 0)) {
			commerceOrderCacheModel.printedNote = null;
		}

		Date requestedDeliveryDate = getRequestedDeliveryDate();

		if (requestedDeliveryDate != null) {
			commerceOrderCacheModel.requestedDeliveryDate =
				requestedDeliveryDate.getTime();
		}
		else {
			commerceOrderCacheModel.requestedDeliveryDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.status = getStatus();

		commerceOrderCacheModel.statusByUserId = getStatusByUserId();

		commerceOrderCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commerceOrderCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceOrderCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceOrderCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceOrderCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceOrderCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((CommerceOrder)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceOrder)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceOrder>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _uuid;
	private String _originalUuid;
	private String _externalReferenceCode;
	private String _originalExternalReferenceCode;
	private long _commerceOrderId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _originalCreateDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceAccountId;
	private long _originalCommerceAccountId;
	private boolean _setOriginalCommerceAccountId;
	private long _commerceCurrencyId;
	private long _billingAddressId;
	private long _originalBillingAddressId;
	private boolean _setOriginalBillingAddressId;
	private long _shippingAddressId;
	private long _originalShippingAddressId;
	private boolean _setOriginalShippingAddressId;
	private String _commercePaymentMethodKey;
	private String _transactionId;
	private long _commerceShippingMethodId;
	private String _shippingOptionName;
	private String _purchaseOrderNumber;
	private String _couponCode;
	private Date _lastPriceUpdateDate;
	private BigDecimal _subtotal;
	private BigDecimal _subtotalDiscountAmount;
	private BigDecimal _subtotalDiscountPercentageLevel1;
	private BigDecimal _subtotalDiscountPercentageLevel2;
	private BigDecimal _subtotalDiscountPercentageLevel3;
	private BigDecimal _subtotalDiscountPercentageLevel4;
	private BigDecimal _shippingAmount;
	private BigDecimal _shippingDiscountAmount;
	private BigDecimal _shippingDiscountPercentageLevel1;
	private BigDecimal _shippingDiscountPercentageLevel2;
	private BigDecimal _shippingDiscountPercentageLevel3;
	private BigDecimal _shippingDiscountPercentageLevel4;
	private BigDecimal _taxAmount;
	private BigDecimal _total;
	private BigDecimal _totalDiscountAmount;
	private BigDecimal _totalDiscountPercentageLevel1;
	private BigDecimal _totalDiscountPercentageLevel2;
	private BigDecimal _totalDiscountPercentageLevel3;
	private BigDecimal _totalDiscountPercentageLevel4;
	private String _advanceStatus;
	private int _paymentStatus;
	private int _orderStatus;
	private int _originalOrderStatus;
	private boolean _setOriginalOrderStatus;
	private String _printedNote;
	private Date _requestedDeliveryDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private CommerceOrder _escapedModel;

}