/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryHelper;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/order_status"}, service={MessageListener.class})
public class CommerceOrderStatusMessageListener
extends BaseMessageListener {
    @Reference
    private CommerceNotificationHelper _commerceNotificationHelper;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceSubscriptionEntryHelper _commerceSubscriptionEntryHelper;

    protected void doReceive(Message message) throws Exception {
        int orderStatus = message.getInteger("orderStatus");
        if (orderStatus == 1) {
            long commerceOrderId = message.getLong("commerceOrderId");
            CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
            this._commerceNotificationHelper.sendNotifications(commerceOrder.getGroupId(), "order-placed", (Object)commerceOrder);
            this._commerceSubscriptionEntryHelper.checkCommerceSubscriptions(commerceOrder);
        }
    }
}

