/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceSubscriptionCPInstanceIdException;
import com.liferay.commerce.exception.CommerceSubscriptionEntryNextIterationDateException;
import com.liferay.commerce.exception.CommerceSubscriptionEntryStartDateException;
import com.liferay.commerce.exception.CommerceSubscriptionEntrySubscriptionStatusException;
import com.liferay.commerce.exception.CommerceSubscriptionTypeException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPSubscriptionInfo;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPSubscriptionType;
import com.liferay.commerce.product.util.CPSubscriptionTypeRegistry;
import com.liferay.commerce.service.base.CommerceSubscriptionEntryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;

public class CommerceSubscriptionEntryLocalServiceImpl
extends CommerceSubscriptionEntryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    @ServiceReference(type=CommerceChannelLocalService.class)
    private CommerceChannelLocalService _commerceChannelLocalService;
    @ServiceReference(type=CommerceNotificationHelper.class)
    private CommerceNotificationHelper _commerceNotificationHelper;
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CPInstanceLocalService.class)
    private CPInstanceLocalService _cpInstanceLocalService;
    @ServiceReference(type=CPSubscriptionTypeRegistry.class)
    private CPSubscriptionTypeRegistry _cpSubscriptionTypeRegistry;

    public CommerceSubscriptionEntry addCommerceSubscriptionEntry(long cpInstanceId, long commerceOrderItemId, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        return this.commerceSubscriptionEntryLocalService.addCommerceSubscriptionEntry(cpInstance.getCPInstanceUuid(), cpDefinition.getCProductId(), commerceOrderItemId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceSubscriptionEntry addCommerceSubscriptionEntry(String cpInstanceUuid, long cProductId, long commerceOrderItemId, ServiceContext serviceContext) throws PortalException {
        CPSubscriptionInfo cpSubscriptionInfo = null;
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCProductInstance(cProductId, cpInstanceUuid);
        if (cpInstance != null) {
            cpSubscriptionInfo = cpInstance.getCPSubscriptionInfo();
        }
        if (cpSubscriptionInfo == null) {
            throw new CommerceSubscriptionCPInstanceIdException();
        }
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(cpSubscriptionInfo.getSubscriptionType());
        this.validateCPSubscriptionType(cpSubscriptionType);
        long groupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(serviceContext.getScopeGroupId());
        long commerceSubscriptionEntryId = this.counterLocalService.increment();
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.create(commerceSubscriptionEntryId);
        commerceSubscriptionEntry.setUuid(serviceContext.getUuid());
        commerceSubscriptionEntry.setGroupId(groupId);
        commerceSubscriptionEntry.setCompanyId(user.getCompanyId());
        commerceSubscriptionEntry.setUserId(user.getUserId());
        commerceSubscriptionEntry.setUserName(user.getFullName());
        commerceSubscriptionEntry.setCPInstanceUuid(cpInstanceUuid);
        commerceSubscriptionEntry.setCProductId(cProductId);
        commerceSubscriptionEntry.setCommerceOrderItemId(commerceOrderItemId);
        commerceSubscriptionEntry.setSubscriptionLength(cpSubscriptionInfo.getSubscriptionLength());
        commerceSubscriptionEntry.setSubscriptionType(cpSubscriptionInfo.getSubscriptionType());
        commerceSubscriptionEntry.setCurrentCycle(1L);
        commerceSubscriptionEntry.setMaxSubscriptionCycles(cpSubscriptionInfo.getMaxSubscriptionCycles());
        commerceSubscriptionEntry.setSubscriptionTypeSettingsProperties(cpSubscriptionInfo.getSubscriptionTypeSettingsProperties());
        commerceSubscriptionEntry.setSubscriptionStatus(0);
        commerceSubscriptionEntry.setLastIterationDate(new Date());
        Date subscriptionNextIterationDate = cpSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), cpSubscriptionInfo.getSubscriptionLength(), cpSubscriptionInfo.getSubscriptionTypeSettingsProperties(), null);
        commerceSubscriptionEntry.setNextIterationDate(subscriptionNextIterationDate);
        Date subscriptionStartDate = cpSubscriptionType.getSubscriptionStartDate(user.getTimeZone(), cpSubscriptionInfo.getSubscriptionTypeSettingsProperties());
        commerceSubscriptionEntry.setStartDate(subscriptionStartDate);
        this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
        return commerceSubscriptionEntry;
    }

    public CommerceSubscriptionEntry fetchCommerceSubscriptionEntries(String cpInstanceUuid, long cProductId, long commerceOrderItemId) {
        return this.commerceSubscriptionEntryPersistence.fetchByC_C_C(cpInstanceUuid, cProductId, commerceOrderItemId);
    }

    public List<CommerceSubscriptionEntry> getActiveCommerceSubscriptionEntries() {
        return this.commerceSubscriptionEntryPersistence.findBySubscriptionStatus(0);
    }

    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(long companyId, long userId, int start, int end, OrderByComparator<CommerceSubscriptionEntry> orderByComparator) {
        return this.commerceSubscriptionEntryPersistence.findByC_U(companyId, userId, start, end, orderByComparator);
    }

    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(long companyId, long groupId, long userId, int start, int end, OrderByComparator<CommerceSubscriptionEntry> orderByComparator) {
        return this.commerceSubscriptionEntryPersistence.findByG_C_U(groupId, companyId, userId, start, end, orderByComparator);
    }

    public int getCommerceSubscriptionEntriesCount(long companyId, long userId) {
        return this.commerceSubscriptionEntryPersistence.countByC_U(companyId, userId);
    }

    public int getCommerceSubscriptionEntriesCount(long companyId, long groupId, long userId) {
        return this.commerceSubscriptionEntryPersistence.countByG_C_U(groupId, companyId, userId);
    }

    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntriesToRenew() {
        return this.commerceSubscriptionEntryFinder.findByNextIterationDate(new Date());
    }

    public CommerceSubscriptionEntry incrementCommerceSubscriptionEntryCycle(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        long currentSubscriptionCycle = commerceSubscriptionEntry.getCurrentCycle();
        commerceSubscriptionEntry.setCurrentCycle(currentSubscriptionCycle + 1L);
        User user = this.userLocalService.getUser(commerceSubscriptionEntry.getUserId());
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(commerceSubscriptionEntry.getSubscriptionType());
        this.validateCPSubscriptionType(cpSubscriptionType);
        commerceSubscriptionEntry.setLastIterationDate(commerceSubscriptionEntry.getNextIterationDate());
        Date subscriptionNextIterationDate = cpSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), commerceSubscriptionEntry.getSubscriptionLength(), commerceSubscriptionEntry.getSubscriptionTypeSettingsProperties(), commerceSubscriptionEntry.getNextIterationDate());
        commerceSubscriptionEntry.setNextIterationDate(subscriptionNextIterationDate);
        CommerceSubscriptionEntry updatedSubscriptionEntry = (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        if (commerceOrderItem != null) {
            CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
            this._commerceNotificationHelper.sendNotifications(commerceOrder.getGroupId(), "subscription-renewed", (Object)commerceOrder);
        }
        return updatedSubscriptionEntry;
    }

    public BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(long companyId, long groupId, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, maxSubscriptionCycles, subscriptionStatus, keywords, start, end, sort);
        return this.searchCommerceSubscriptionEntries(searchContext);
    }

    public BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(long companyId, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, null, maxSubscriptionCycles, subscriptionStatus, keywords, start, end, sort);
        return this.searchCommerceSubscriptionEntries(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceSubscriptionEntry updateCommerceSubscriptionEntry(long commerceSubscriptionEntryId, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsProperties, long maxSubscriptionCycles, int subscriptionStatus, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int nextIterationDateMonth, int nextIterationDateDay, int nextIterationDateYear, int nextIterationDateHour, int nextIterationDateMinute) throws PortalException {
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(subscriptionType);
        this.validateCPSubscriptionType(cpSubscriptionType);
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        User user = this.userLocalService.getUser(commerceSubscriptionEntry.getUserId());
        this.validateSubscriptionStatus(subscriptionStatus, commerceSubscriptionEntry.getSubscriptionStatus());
        commerceSubscriptionEntry.setSubscriptionLength(subscriptionLength);
        commerceSubscriptionEntry.setSubscriptionType(subscriptionType);
        commerceSubscriptionEntry.setSubscriptionTypeSettingsProperties(subscriptionTypeSettingsProperties);
        commerceSubscriptionEntry.setMaxSubscriptionCycles(maxSubscriptionCycles);
        commerceSubscriptionEntry.setSubscriptionStatus(subscriptionStatus);
        Date nextIterationDate = PortalUtil.getDate((int)nextIterationDateMonth, (int)nextIterationDateDay, (int)nextIterationDateYear, (int)nextIterationDateHour, (int)nextIterationDateMinute, (TimeZone)user.getTimeZone(), CommerceSubscriptionEntryNextIterationDateException.class);
        commerceSubscriptionEntry.setNextIterationDate(nextIterationDate);
        Date startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (TimeZone)user.getTimeZone(), CommerceSubscriptionEntryStartDateException.class);
        commerceSubscriptionEntry.setStartDate(startDate);
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    public CommerceSubscriptionEntry updateCommerceSubscriptionEntryIterationDates(long commerceSubscriptionEntryId, Date lastIterationDate) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        User user = this.userLocalService.getUser(commerceSubscriptionEntry.getUserId());
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(commerceSubscriptionEntry.getSubscriptionType());
        this.validateCPSubscriptionType(cpSubscriptionType);
        commerceSubscriptionEntry.setLastIterationDate(lastIterationDate);
        Date subscriptionNextIterationDate = cpSubscriptionType.getSubscriptionNextIterationDate(user.getTimeZone(), commerceSubscriptionEntry.getSubscriptionLength(), commerceSubscriptionEntry.getSubscriptionTypeSettingsProperties(), lastIterationDate);
        commerceSubscriptionEntry.setNextIterationDate(subscriptionNextIterationDate);
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceSubscriptionEntry updateSubscriptionStatus(long commerceSubscriptionEntryId, int subscriptionStatus) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryPersistence.findByPrimaryKey(commerceSubscriptionEntryId);
        this.validateSubscriptionStatus(subscriptionStatus, commerceSubscriptionEntry.getSubscriptionStatus());
        commerceSubscriptionEntry.setSubscriptionStatus(subscriptionStatus);
        return (CommerceSubscriptionEntry)this.commerceSubscriptionEntryPersistence.update((BaseModel)commerceSubscriptionEntry);
    }

    protected SearchContext buildSearchContext(long companyId, Long groupId, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("entryClassPK", keywords);
        attributes.put("CPInstanceId", keywords);
        attributes.put("sku", keywords);
        if (maxSubscriptionCycles != null) {
            attributes.put("maxSubscriptionCycles", maxSubscriptionCycles);
        }
        if (subscriptionStatus != null) {
            attributes.put("subscriptionStatus", subscriptionStatus);
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("keywords", keywords);
        attributes.put("params", params);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setStart(start);
        searchContext.setEnd(end);
        if (groupId != null) {
            searchContext.setGroupIds(new long[]{groupId});
        }
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        return searchContext;
    }

    protected List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceSubscriptionEntry> commerceSubscriptionEntries = new ArrayList<CommerceSubscriptionEntry>(documents.size());
        for (Document document : documents) {
            long commerceSubscriptionEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceSubscriptionEntry commerceSubscriptionEntry = this.fetchCommerceSubscriptionEntry(commerceSubscriptionEntryId);
            if (commerceSubscriptionEntry == null) {
                commerceSubscriptionEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceSubscriptionEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceSubscriptionEntries == null) continue;
            commerceSubscriptionEntries.add(commerceSubscriptionEntry);
        }
        return commerceSubscriptionEntries;
    }

    protected BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceSubscriptionEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceSubscriptionEntry> commerceSubscriptionEntries = this.getCommerceSubscriptionEntries(hits);
            if (commerceSubscriptionEntries == null) continue;
            return new BaseModelSearchResult(commerceSubscriptionEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validateCPSubscriptionType(CPSubscriptionType cpSubscriptionType) throws PortalException {
        if (cpSubscriptionType == null) {
            throw new CommerceSubscriptionTypeException();
        }
    }

    protected void validateSubscriptionStatus(int subscriptionStatus, int oldSubscriptionStatus) throws PortalException {
        if (oldSubscriptionStatus == 1) {
            return;
        }
        if (subscriptionStatus < oldSubscriptionStatus) {
            throw new CommerceSubscriptionEntrySubscriptionStatusException();
        }
    }
}

