/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_1_0;

import com.liferay.commerce.model.impl.CommerceSubscriptionEntryModelImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CommerceSubscriptionEntryUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceSubscriptionEntryUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;
    private final CPInstanceLocalService _cpInstanceLocalService;

    public CommerceSubscriptionEntryUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService, CPInstanceLocalService cpInstanceLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
        this._cpInstanceLocalService = cpInstanceLocalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        this._addColumn(CommerceSubscriptionEntryModelImpl.class, "CommerceSubscriptionEntry", "CPInstanceUUID", "VARCHAR(75)");
        this._addColumn(CommerceSubscriptionEntryModelImpl.class, "CommerceSubscriptionEntry", "CProductId", "LONG");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Statement s = null;
        try {
            ps = this.connection.prepareStatement("update CommerceSubscriptionEntry set CProductId = ?,CPInstanceUUID = ? where CPInstanceId = ?");
            s = this.connection.createStatement();
            rs = s.executeQuery("select distinct CPInstanceId from CommerceSubscriptionEntry");
            while (rs.next()) {
                long cpInstanceId = rs.getLong("CPInstanceId");
                CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
                ps.setLong(1, cpDefinition.getCProductId());
                ps.setString(2, cpInstance.getCPInstanceUuid());
                ps.setLong(3, cpInstanceId);
                ps.execute();
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps);
            DataAccess.cleanUp(s, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps);
        DataAccess.cleanUp((Statement)s, (ResultSet)rs);
        this.runSQL("alter table CommerceSubscriptionEntry drop column CPInstanceId");
    }

    private void _addColumn(Class<?> entityClass, String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        if (!this.hasColumn(tableName, columnName)) {
            this.alter(entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, columnName + " " + columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", columnName, tableName));
        }
    }
}

