/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_1_0;

import com.liferay.commerce.model.impl.CPDAvailabilityEstimateModelImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CPDAvailabilityEstimateUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CPDAvailabilityEstimateUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;

    public CPDAvailabilityEstimateUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        this._addColumn(CPDAvailabilityEstimateModelImpl.class, "CPDAvailabilityEstimate", "CProductId", "LONG");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Statement s = null;
        try {
            ps = this.connection.prepareStatement("update CPDAvailabilityEstimate set CProductId = ? where CPDefinitionId = ?");
            s = this.connection.createStatement();
            rs = s.executeQuery("select distinct CPDefinitionId from CPDAvailabilityEstimate");
            while (rs.next()) {
                long cpDefinitionId = rs.getLong("CPDefinitionId");
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
                ps.setLong(1, cpDefinition.getCProductId());
                ps.setLong(2, cpDefinitionId);
                ps.execute();
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps);
            DataAccess.cleanUp(s, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps);
        DataAccess.cleanUp((Statement)s, (ResultSet)rs);
        this.runSQL("alter table CPDAvailabilityEstimate drop column CPDefinitionId");
    }

    private void _addColumn(Class<?> entityClass, String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        if (!this.hasColumn(tableName, columnName)) {
            this.alter(entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, columnName + " " + columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", columnName, tableName));
        }
    }
}

