/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_1_0;

import com.liferay.commerce.model.impl.CPDAvailabilityEstimateModelImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;

public class CPDAvailabilityEstimateUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CPDAvailabilityEstimateUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;

    public CPDAvailabilityEstimateUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws Exception {
        this._addColumn(CPDAvailabilityEstimateModelImpl.class, "CPDAvailabilityEstimate", "CProductId", "LONG");
        this._addIndexes("CPDAvailabilityEstimate");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Statement s = null;
        try {
            ps = this.connection.prepareStatement("update CPDAvailabilityEstimate set CProductId = ? where CPDefinitionId = ?");
            s = this.connection.createStatement();
            rs = s.executeQuery("select distinct CPDefinitionId from CPDAvailabilityEstimate");
            while (rs.next()) {
                long cpDefinitionId = rs.getLong("CPDefinitionId");
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
                ps.setLong(1, cpDefinition.getCProductId());
                ps.setLong(2, cpDefinitionId);
                ps.execute();
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps);
            DataAccess.cleanUp(s, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps);
        DataAccess.cleanUp((Statement)s, (ResultSet)rs);
        this.runSQL("drop index IX_86A2368F on CPDAvailabilityEstimate");
        this.runSQL("alter table CPDAvailabilityEstimate drop column CPDefinitionId");
    }

    private void _addColumn(Class<?> entityClass, String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        if (!this.hasColumn(tableName, columnName)) {
            this.alter(entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, columnName + " " + columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", columnName, tableName));
        }
    }

    private void _addIndexes(String tableName) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        List indexesSQL = this.getIndexesSQL(clazz.getClassLoader(), tableName);
        for (ObjectValuePair indexSQL : indexesSQL) {
            IndexMetadata indexMetadata = (IndexMetadata)indexSQL.getValue();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Adding index %s to table %s", indexMetadata.getIndexName(), tableName));
            }
            if (!this._tableHasIndex(tableName, indexMetadata.getIndexName())) {
                this.runSQL(indexMetadata.getCreateSQL(null));
                continue;
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)String.format("Index %s already exists on table %s", indexMetadata.getIndexName(), tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _tableHasIndex(String tableName, String indexName) throws Exception {
        boolean bl;
        ResultSet rs = null;
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            rs = metadata.getIndexInfo(null, null, tableName, false, false);
            while (rs.next()) {
                String curIndexName = rs.getString("index_name");
                if (!Objects.equals(indexName, curIndexName)) break block4;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(rs);
            throw throwable;
        }
        {
            block4: {
                DataAccess.cleanUp((ResultSet)rs);
                return bl;
            }
            continue;
        }
        DataAccess.cleanUp((ResultSet)rs);
        return false;
    }
}

