/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderSoap;
import com.liferay.commerce.service.CommerceOrderServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.List;

@ProviderType
public class CommerceOrderServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(CommerceOrderServiceSoap.class);

    public static CommerceOrderSoap addCommerceOrder(long groupId, long userId, long commerceAccountId, long commerceCurrencyId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.addCommerceOrder((long)groupId, (long)userId, (long)commerceAccountId, (long)commerceCurrencyId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long shippingAddressId, String purchaseOrderNumber) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.addCommerceOrder((long)groupId, (long)commerceAccountId, (long)commerceCurrencyId, (long)shippingAddressId, (String)purchaseOrderNumber);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap addCommerceOrder(long groupId, long commerceAccountId, long shippingAddressId, String purchaseOrderNumber) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.addCommerceOrder((long)groupId, (long)commerceAccountId, (long)shippingAddressId, (String)purchaseOrderNumber);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.applyCouponCode((long)commerceOrderId, (String)couponCode, (CommerceContext)commerceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap approveCommerceOrder(long commerceOrderId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.approveCommerceOrder((long)commerceOrderId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap checkoutCommerceOrder(long commerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.checkoutCommerceOrder((long)commerceOrderId, (CommerceContext)commerceContext, (ServiceContext)serviceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteCommerceOrder(long commerceOrderId) throws RemoteException {
        try {
            CommerceOrderServiceUtil.deleteCommerceOrder((long)commerceOrderId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.executeWorkflowTransition((long)commerceOrderId, (long)workflowTaskId, (String)transitionName, (String)comment);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.fetchByExternalReferenceCode((long)companyId, (String)externalReferenceCode);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap fetchCommerceOrder(long commerceOrderId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.fetchCommerceOrder((long)commerceOrderId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.fetchCommerceOrder((long)commerceAccountId, (long)groupId, (int)orderStatus);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap fetchCommerceOrder(String uuid, long groupId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.fetchCommerceOrder((String)uuid, (long)groupId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int[] getAvailableOrderStatuses(long commerceOrderId) throws RemoteException {
        try {
            int[] returnValue = CommerceOrderServiceUtil.getAvailableOrderStatuses((long)commerceOrderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap getCommerceOrder(long commerceOrderId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.getCommerceOrder((long)commerceOrderId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.getCommerceOrderByUuidAndGroupId((String)uuid, (long)groupId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap[] getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws RemoteException {
        try {
            List returnValue = CommerceOrderServiceUtil.getCommerceOrders((long)groupId, (int)start, (int)end, orderByComparator);
            return CommerceOrderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap[] getCommerceOrders(long groupId, int[] orderStatuses) throws RemoteException {
        try {
            List returnValue = CommerceOrderServiceUtil.getCommerceOrders((long)groupId, (int[])orderStatuses);
            return CommerceOrderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap[] getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws RemoteException {
        try {
            List returnValue = CommerceOrderServiceUtil.getCommerceOrders((long)groupId, (int[])orderStatuses, (int)start, (int)end);
            return CommerceOrderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap[] getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws RemoteException {
        try {
            List returnValue = CommerceOrderServiceUtil.getCommerceOrders((long)groupId, (long)commerceAccountId, (int)start, (int)end, orderByComparator);
            return CommerceOrderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCommerceOrdersCount(long groupId) throws RemoteException {
        try {
            int returnValue = CommerceOrderServiceUtil.getCommerceOrdersCount((long)groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCommerceOrdersCount(long groupId, long commerceAccountId) throws RemoteException {
        try {
            int returnValue = CommerceOrderServiceUtil.getCommerceOrdersCount((long)groupId, (long)commerceAccountId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap[] getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws RemoteException {
        try {
            List returnValue = CommerceOrderServiceUtil.getPendingCommerceOrders((long)groupId, (long)commerceAccountId, (String)keywords, (int)start, (int)end);
            return CommerceOrderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws RemoteException {
        try {
            int returnValue = CommerceOrderServiceUtil.getPendingCommerceOrdersCount((long)groupId, (long)commerceAccountId, (String)keywords);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap[] getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws RemoteException {
        try {
            List returnValue = CommerceOrderServiceUtil.getPlacedCommerceOrders((long)groupId, (long)commerceAccountId, (String)keywords, (int)start, (int)end);
            return CommerceOrderSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws RemoteException {
        try {
            int returnValue = CommerceOrderServiceUtil.getPlacedCommerceOrdersCount((long)groupId, (long)commerceAccountId, (String)keywords);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrderServiceUtil.mergeGuestCommerceOrder((long)guestCommerceOrderId, (long)userCommerceOrderId, (CommerceContext)commerceContext, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.reorderCommerceOrder((long)commerceOrderId, (CommerceContext)commerceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap submitCommerceOrder(long commerceOrderId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.submitCommerceOrder((long)commerceOrderId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateBillingAddress((long)commerceOrderId, (String)name, (String)description, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)commerceRegionId, (long)commerceCountryId, (String)phoneNumber, (ServiceContext)serviceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateCommerceOrder((long)commerceOrderId, (long)billingAddressId, (long)shippingAddressId, (String)commercePaymentMethodKey, (long)commerceShippingMethodId, (String)shippingOptionName, (String)purchaseOrderNumber, (BigDecimal)subtotal, (BigDecimal)shippingAmount, (BigDecimal)total, (String)advanceStatus, (CommerceContext)commerceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateCommerceOrder((long)commerceOrderId, (long)billingAddressId, (long)shippingAddressId, (String)commercePaymentMethodKey, (long)commerceShippingMethodId, (String)shippingOptionName, (String)purchaseOrderNumber, (BigDecimal)subtotal, (BigDecimal)shippingAmount, (BigDecimal)total, (String)advanceStatus, (String)externalReferenceCode, (CommerceContext)commerceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateCommercePaymentMethodKey((long)commerceOrderId, (String)commercePaymentMethodKey);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateCustomFields(long commerceOrderId, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateCustomFields((long)commerceOrderId, (ServiceContext)serviceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateOrderStatus(long commerceOrderId, int orderStatus) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateOrderStatus((long)commerceOrderId, (int)orderStatus);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updatePaymentStatus(long commerceOrderId, int paymentStatus) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updatePaymentStatus((long)commerceOrderId, (int)paymentStatus);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updatePaymentStatusAndTransactionId((long)commerceOrderId, (int)paymentStatus, (String)transactionId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updatePurchaseOrderNumber((long)commerceOrderId, (String)purchaseOrderNumber);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateShippingAddress((long)commerceOrderId, (String)name, (String)description, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)commerceRegionId, (long)commerceCountryId, (String)phoneNumber, (ServiceContext)serviceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateTransactionId(long commerceOrderId, String transactionId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateTransactionId((long)commerceOrderId, (String)transactionId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap updateUser(long commerceOrderId, long userId) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.updateUser((long)commerceOrderId, (long)userId);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CommerceOrderSoap upsertCommerceOrder(long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext, ServiceContext serviceContext) throws RemoteException {
        try {
            CommerceOrder returnValue = CommerceOrderServiceUtil.upsertCommerceOrder((long)commerceAccountId, (long)commerceCurrencyId, (long)billingAddressId, (long)shippingAddressId, (String)commercePaymentMethodKey, (long)commerceShippingMethodId, (String)shippingOptionName, (String)purchaseOrderNumber, (BigDecimal)subtotal, (BigDecimal)shippingAmount, (BigDecimal)total, (int)paymentStatus, (int)orderStatus, (String)advanceStatus, (String)externalReferenceCode, (CommerceContext)commerceContext, (ServiceContext)serviceContext);
            return CommerceOrderSoap.toSoapModel((CommerceOrder)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

