/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.base.CommerceShipmentServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceShipmentServiceImpl
extends CommerceShipmentServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceShipmentServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.addCommerceShipment(commerceOrderId, serviceContext);
    }

    public void deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment);
    }

    public CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
    }

    public List<CommerceShipment> getCommerceShipments(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipments(groupId, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipments(groupId, start, end, orderByComparator);
    }

    public int getCommerceShipmentsCount(long groupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(groupId);
    }

    public int getCommerceShipmentsCount(long groupId, int status) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCount(groupId, status);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }
}

