/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.service.base.CommerceShipmentItemLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;
import java.util.concurrent.Callable;

public class CommerceShipmentItemLocalServiceImpl
extends CommerceShipmentItemLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentItemLocalServiceImpl.class);
    @ServiceReference(type=CPDefinitionInventoryEngineRegistry.class)
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem addCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceWarehouseId, int quantity, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this.validate(commerceOrderItem, commerceWarehouseId, quantity, quantity);
        long commerceShipmentItemId = this.counterLocalService.increment();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.create(commerceShipmentItemId);
        commerceShipmentItem.setGroupId(groupId);
        commerceShipmentItem.setCompanyId(user.getCompanyId());
        commerceShipmentItem.setUserId(user.getUserId());
        commerceShipmentItem.setUserName(user.getFullName());
        commerceShipmentItem.setCommerceShipmentId(commerceShipmentId);
        commerceShipmentItem.setCommerceOrderItemId(commerceOrderItemId);
        commerceShipmentItem.setCommerceWarehouseId(commerceWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        commerceOrderItem = this.commerceOrderItemLocalService.incrementShippedQuantity(commerceOrderItemId, quantity);
        this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), quantity);
        return commerceShipmentItem;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipmentItem deleteCommerceShipmentItem(CommerceShipmentItem commerceShipmentItem) {
        CommerceOrderItem commerceOrderItem = null;
        int shippedQuantity = commerceShipmentItem.getQuantity() * -1;
        try {
            commerceOrderItem = this.commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), shippedQuantity);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        try {
            this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), shippedQuantity);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        this.commerceShipmentItemPersistence.remove((BaseModel)commerceShipmentItem);
        return commerceShipmentItem;
    }

    @Override
    public CommerceShipmentItem deleteCommerceShipmentItem(long commerceShipmentItemId) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem);
    }

    public void deleteCommerceShipmentItems(long commerceShipment) {
        List commerceShipmentItems = this.commerceShipmentItemPersistence.findByCommerceShipment(commerceShipment);
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem);
        }
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceOrderItemId) {
        return this.commerceShipmentItemFinder.findByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByCommerceShipment(commerceShipmentId, start, end, orderByComparator);
    }

    public int getCommerceShipmentItemsCount(long commerceShipmentId) {
        return this.commerceShipmentItemPersistence.countByCommerceShipment(commerceShipmentId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, int quantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        int newQuantity = quantity - commerceShipmentItem.getQuantity();
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        this.validate(commerceOrderItem, commerceShipmentItem.getCommerceWarehouseId(), quantity, newQuantity);
        this.commerceOrderItemLocalService.incrementShippedQuantity(commerceOrderItem.getCommerceOrderItemId(), newQuantity);
        this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), newQuantity);
        return commerceShipmentItem;
    }

    protected void validate(CommerceOrderItem commerceOrderItem, long commerceWarehouseId, int quantity, int newQuantity) throws PortalException {
        int availableQuantity = commerceOrderItem.getQuantity() - commerceOrderItem.getShippedQuantity();
        int commerceWarehouseQuantity = this.commerceOrderItemLocalService.getCommerceWarehouseItemQuantity(commerceOrderItem.getCommerceOrderItemId(), commerceWarehouseId);
        if (quantity <= 0 || newQuantity > availableQuantity || newQuantity > commerceWarehouseQuantity) {
            throw new CommerceShipmentItemQuantityException();
        }
    }

    private CommerceWarehouseItem _fetchCommerceWarehouseItem(long commerceShipmentItemId, long cpInstanceId) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this.commerceWarehouseItemLocalService.fetchCommerceWarehouseItem(commerceShipmentItem.getCommerceWarehouseId(), cpInstanceId);
    }

    private void _updateStockQuantity(CommerceOrderItem commerceOrderItem, long commerceShipmentItemId, int quantity) throws PortalException {
        if (commerceOrderItem == null) {
            return;
        }
        final CommerceWarehouseItem commerceWarehouseItem = this._fetchCommerceWarehouseItem(commerceShipmentItemId, commerceOrderItem.getCPInstanceId());
        if (commerceWarehouseItem == null) {
            return;
        }
        CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
        CPDefinitionInventory cpDefinitionInventory = this.cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinition.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        cpDefinitionInventoryEngine.updateStockQuantity(commerceWarehouseItem, quantity);
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("commerceWarehouseItemId", (Object)commerceWarehouseItem.getCommerceWarehouseItemId());
                MessageBusUtil.sendMessage((String)"liferay/stock_quantity", (Message)message);
                return null;
            }
        });
    }
}

