/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.product.content.contributor;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPSubscriptionInfo;
import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.product.util.CPSubscriptionType;
import com.liferay.commerce.product.util.CPSubscriptionTypeRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.product.content.contributor.name=subscriptionInfo"}, service={CPContentContributor.class})
public class SubscriptionInfoCPContentContributor
implements CPContentContributor {
    @Reference
    private CPSubscriptionTypeRegistry _cpSubscriptionTypeRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public String getName() {
        return "subscriptionInfo";
    }

    public JSONObject getValue(CPInstance cpInstance, HttpServletRequest httpServletRequest) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (cpInstance == null) {
            return jsonObject;
        }
        CPSubscriptionInfo cpSubscriptionInfo = cpInstance.getCPSubscriptionInfo();
        if (cpSubscriptionInfo == null) {
            jsonObject.put("subscriptionInfo", "");
            return jsonObject;
        }
        String subscriptionInfo = this._getSubscriptionInfo(cpSubscriptionInfo, httpServletRequest);
        jsonObject.put("subscriptionInfo", subscriptionInfo);
        return jsonObject;
    }

    private String _getSubscriptionInfo(CPSubscriptionInfo cpSubscriptionInfo, HttpServletRequest httpServletRequest) {
        long maxSubscriptionCycles = cpSubscriptionInfo.getMaxSubscriptionCycles();
        int subscriptionLength = cpSubscriptionInfo.getSubscriptionLength();
        String period = "";
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(cpSubscriptionInfo.getSubscriptionType());
        if (cpSubscriptionType != null) {
            period = cpSubscriptionType.getLabel(this._portal.getLocale(httpServletRequest));
        }
        StringBundler sb = new StringBundler(maxSubscriptionCycles > 0L ? 11 : 7);
        sb.append("(");
        sb.append(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"every"));
        sb.append(" ");
        sb.append(subscriptionLength);
        sb.append(" ");
        sb.append(this._getSuffix(subscriptionLength, period, httpServletRequest));
        sb.append(")");
        if (maxSubscriptionCycles > 0L) {
            long totalLength = (long)subscriptionLength * maxSubscriptionCycles;
            String duration = LanguageUtil.format((HttpServletRequest)httpServletRequest, (String)"duration-x", (Object)totalLength, (boolean)false);
            String durationSuffix = this._getSuffix(totalLength, period, httpServletRequest);
            sb.append(" ");
            sb.append(duration);
            sb.append(" ");
            sb.append(durationSuffix);
        }
        return sb.toString();
    }

    private String _getSuffix(long count, String period, HttpServletRequest httpServletRequest) {
        if (count > 1L) {
            return LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)(StringUtil.toLowerCase((String)period) + 's'));
        }
        return period;
    }
}

