/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.service.base.CommerceSubscriptionEntryServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.List;

public class CommerceSubscriptionEntryServiceImpl
extends CommerceSubscriptionEntryServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceSubscriptionEntryServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public void deleteCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceSubscriptionEntry.getGroupId(), "MANAGE_COMMERCE_SUBSCRIPTIONS");
        this.commerceSubscriptionEntryLocalService.deleteCommerceSubscriptionEntry(commerceSubscriptionEntryId);
    }

    public CommerceSubscriptionEntry fetchCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryLocalService.fetchCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        if (commerceSubscriptionEntry != null) {
            _portletResourcePermission.check(this.getPermissionChecker(), commerceSubscriptionEntry.getGroupId(), "MANAGE_COMMERCE_SUBSCRIPTIONS");
        }
        return commerceSubscriptionEntry;
    }

    public List<CommerceSubscriptionEntry> getCommerceSubscriptionEntries(long groupId, long userId, int start, int end, OrderByComparator<CommerceSubscriptionEntry> orderByComparator) throws PortalException {
        return this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntries(groupId, userId, start, end, orderByComparator);
    }

    public int getCommerceSubscriptionEntriesCount(long groupId, long userId) throws PortalException {
        return this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntriesCount(groupId, userId);
    }

    public BaseModelSearchResult<CommerceSubscriptionEntry> searchCommerceSubscriptionEntries(long companyId, long groupId, Long maxSubscriptionCycles, Integer subscriptionStatus, String keywords, int start, int end, Sort sort) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SUBSCRIPTIONS");
        return this.commerceSubscriptionEntryLocalService.searchCommerceSubscriptionEntries(companyId, groupId, maxSubscriptionCycles, subscriptionStatus, keywords, start, end, sort);
    }

    public CommerceSubscriptionEntry updateCommerceSubscriptionEntry(long commerceSubscriptionEntryId, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsProperties, long maxSubscriptionCycles, int subscriptionStatus, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int nextIterationDateMonth, int nextIterationDateDay, int nextIterationDateYear, int nextIterationDateHour, int nextIterationDateMinute) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceSubscriptionEntry.getGroupId(), "MANAGE_COMMERCE_SUBSCRIPTIONS");
        return this.commerceSubscriptionEntryLocalService.updateCommerceSubscriptionEntry(commerceSubscriptionEntryId, subscriptionLength, subscriptionType, subscriptionTypeSettingsProperties, maxSubscriptionCycles, subscriptionStatus, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, nextIterationDateMonth, nextIterationDateDay, nextIterationDateYear, nextIterationDateHour, nextIterationDateMinute);
    }

    public CommerceSubscriptionEntry updateSubscriptionStatus(long commerceSubscriptionEntryId, int subscriptionStatus) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this.commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceSubscriptionEntry.getGroupId(), "MANAGE_COMMERCE_SUBSCRIPTIONS");
        return this.commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntryId, subscriptionStatus);
    }
}

