/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.base.CommerceShipmentItemServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceShipmentItemServiceImpl
extends CommerceShipmentItemServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceShipmentItemServiceImpl.class, (String)"_commerceOrderModelResourcePermission", CommerceOrder.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceShipmentItemServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceShipmentItem addCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceWarehouseId, int quantity, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.addCommerceShipmentItem(commerceShipmentId, commerceOrderItemId, commerceWarehouseId, quantity, serviceContext);
    }

    public void deleteCommerceShipmentItem(long commerceShipmentItemId) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipmentItem.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItems(commerceOrderItemId);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItems(commerceShipmentId, start, end, orderByComparator);
    }

    public int getCommerceShipmentItemsCount(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItemsCount(commerceShipmentId);
    }

    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, int quantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipmentItem.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.updateCommerceShipmentItem(commerceShipmentItemId, quantity);
    }
}

