/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_2_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.model.impl.CommerceOrderModelImpl;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommerceOrderUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderUpgradeProcess.class);
    private final CommerceAccountLocalService _commerceAccountLocalService;
    private final UserLocalService _userLocalService;

    public CommerceOrderUpgradeProcess(CommerceAccountLocalService commerceAccountLocalService, UserLocalService userLocalService) {
        this._commerceAccountLocalService = commerceAccountLocalService;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._addColumn(CommerceOrderModelImpl.class, "CommerceOrder", "commerceAccountId", "LONG");
        if (this.hasColumn("CommerceOrder", "siteGroupId")) {
            this.runSQL("update CommerceOrder set groupId = siteGroupId");
            this._dropColumn("CommerceOrder", "siteGroupId");
        }
        if (!this.hasColumn("CommerceOrder", "orderOrganizationId") || !this.hasColumn("CommerceOrder", "orderUserId")) {
            return;
        }
        String updateCommerceOrderSQL1 = "update CommerceOrder set commerceAccountId = ? where orderOrganizationId = ?";
        String updateCommerceOrderSQL2 = "update CommerceOrder set commerceAccountId = ? where orderUserId = ?";
        try (PreparedStatement ps1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCommerceOrderSQL1);
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCommerceOrderSQL2);
             Statement s = this.connection.createStatement(1003, 1007);
             ResultSet rs = s.executeQuery("select distinct orderOrganizationId, orderUserId from CommerceOrder");){
            while (rs.next()) {
                long commerceAccountId = 0L;
                long orderOrganizationId = rs.getLong("orderOrganizationId");
                long orderUserId = rs.getLong("orderUserId");
                if (orderOrganizationId > 0L) {
                    commerceAccountId = this._getCommerceAccountId(orderOrganizationId);
                    if (commerceAccountId == 0L) {
                        _log.error((Object)("No CommerceAccount for orderOrganizationId " + orderOrganizationId));
                        continue;
                    }
                    ps1.setLong(1, commerceAccountId);
                    ps1.setLong(2, orderOrganizationId);
                    ps1.execute();
                    continue;
                }
                if (orderUserId <= 0L) continue;
                User user = this._userLocalService.getUser(orderUserId);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(user.getCompanyId());
                serviceContext.setUserId(user.getUserId());
                CommerceAccount commerceAccount = this._commerceAccountLocalService.addPersonalCommerceAccount(user.getUserId(), "", "", serviceContext);
                commerceAccountId = commerceAccount.getCommerceAccountId();
                ps2.setLong(1, commerceAccountId);
                ps2.setLong(2, orderUserId);
                ps2.execute();
            }
            ps1.executeBatch();
            ps2.executeBatch();
        }
        this._dropColumn("CommerceOrder", "orderOrganizationId");
        this._dropColumn("CommerceOrder", "orderUserId");
    }

    private void _addColumn(Class<?> entityClass, String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        if (!this.hasColumn(tableName, columnName)) {
            this.alter(entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, columnName + " " + columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", columnName, tableName));
        }
    }

    private void _dropColumn(String tableName, String columnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping column %s from table %s", columnName, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " drop column ", columnName}));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already does not exist on table %s", columnName, tableName));
        }
    }

    private long _getCommerceAccountId(long organizationId) throws SQLException {
        String sql = "select commerceAccountId from CommerceAccountOrganizationRel where organizationId = " + organizationId;
        try (Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery(sql);){
            if (rs.next()) {
                long l = rs.getLong("commerceAccountId");
                return l;
            }
        }
        return 0L;
    }
}

